/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.lang.reflect.Array;
import java.net.URL;
import java.text.BreakIterator;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import weka.Run;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.WekaPackageManager;

public final class Utils
implements RevisionHandler {
    public static double log2 = Math.log(2.0);
    public static double SMALL = 1.0E-6;

    public static boolean isMissingValue(double val) {
        return Double.isNaN(val);
    }

    public static double missingValue() {
        return Double.NaN;
    }

    public static <T> T cast(Object x) {
        return (T)x;
    }

    public static Properties readProperties(String resourceName) throws Exception {
        File propFile;
        Properties defaultProps = new Properties();
        try {
            Utils utils = new Utils();
            Enumeration<URL> urls = utils.getClass().getClassLoader().getResources(resourceName);
            boolean first = true;
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (first) {
                    defaultProps.load(url.openStream());
                    first = false;
                    continue;
                }
                Properties props = new Properties(defaultProps);
                props.load(url.openStream());
                defaultProps = props;
            }
        }
        catch (Exception ex) {
            System.err.println("Warning, unable to load properties file(s) from system resource (Utils.java): " + resourceName);
        }
        int slInd = resourceName.lastIndexOf(47);
        if (slInd != -1) {
            resourceName = resourceName.substring(slInd + 1);
        }
        Properties userProps = new Properties(defaultProps);
        if (!WekaPackageManager.PROPERTIES_DIR.exists()) {
            WekaPackageManager.PROPERTIES_DIR.mkdir();
        }
        if ((propFile = new File(String.valueOf(WekaPackageManager.PROPERTIES_DIR.toString()) + File.separator + resourceName)).exists()) {
            try {
                userProps.load(new FileInputStream(propFile));
            }
            catch (Exception ex) {
                throw new Exception("Problem reading user properties: " + propFile);
            }
        }
        Properties localProps = new Properties(userProps);
        propFile = new File(resourceName);
        if (propFile.exists()) {
            try {
                localProps.load(new FileInputStream(propFile));
            }
            catch (Exception ex) {
                throw new Exception("Problem reading local properties: " + propFile);
            }
        }
        return localProps;
    }

    public static final double correlation(double[] y1, double[] y2, int n) {
        double av1 = 0.0;
        double av2 = 0.0;
        double y11 = 0.0;
        double y22 = 0.0;
        double y12 = 0.0;
        if (n <= 1) {
            return 1.0;
        }
        int i = 0;
        while (i < n) {
            av1 += y1[i];
            av2 += y2[i];
            ++i;
        }
        av1 /= (double)n;
        av2 /= (double)n;
        i = 0;
        while (i < n) {
            y11 += (y1[i] - av1) * (y1[i] - av1);
            y22 += (y2[i] - av2) * (y2[i] - av2);
            y12 += (y1[i] - av1) * (y2[i] - av2);
            ++i;
        }
        double c = y11 * y22 == 0.0 ? 1.0 : y12 / Math.sqrt(Math.abs(y11 * y22));
        return c;
    }

    public static String removeSubstring(String inString, String substring) {
        StringBuffer result = new StringBuffer();
        int oldLoc = 0;
        int loc = 0;
        while ((loc = inString.indexOf(substring, oldLoc)) != -1) {
            result.append(inString.substring(oldLoc, loc));
            oldLoc = loc + substring.length();
        }
        result.append(inString.substring(oldLoc));
        return result.toString();
    }

    public static String replaceSubstring(String inString, String subString, String replaceString) {
        StringBuffer result = new StringBuffer();
        int oldLoc = 0;
        int loc = 0;
        while ((loc = inString.indexOf(subString, oldLoc)) != -1) {
            result.append(inString.substring(oldLoc, loc));
            result.append(replaceString);
            oldLoc = loc + subString.length();
        }
        result.append(inString.substring(oldLoc));
        return result.toString();
    }

    public static String padLeft(String inString, int length) {
        return Utils.fixStringLength(inString, length, false);
    }

    public static String padRight(String inString, int length) {
        return Utils.fixStringLength(inString, length, true);
    }

    private static String fixStringLength(String inString, int length, boolean right) {
        if (inString.length() < length) {
            while (inString.length() < length) {
                String string = inString = right ? inString.concat(" ") : " ".concat(inString);
            }
        } else if (inString.length() > length) {
            inString = inString.substring(0, length);
        }
        return inString;
    }

    public static String doubleToString(double value, int afterDecimalPoint) {
        double temp = value * Math.pow(10.0, afterDecimalPoint);
        if (Math.abs(temp) < 9.223372036854776E18) {
            long precisionValue = temp > 0.0 ? (long)(temp + 0.5) : -((long)(Math.abs(temp) + 0.5));
            StringBuffer stringBuffer = precisionValue == 0L ? new StringBuffer(String.valueOf(0)) : new StringBuffer(String.valueOf(precisionValue));
            if (afterDecimalPoint == 0) {
                return stringBuffer.toString();
            }
            int dotPosition = stringBuffer.length() - afterDecimalPoint;
            while (precisionValue < 0L && dotPosition < 1 || dotPosition < 0) {
                if (precisionValue < 0L) {
                    stringBuffer.insert(1, '0');
                } else {
                    stringBuffer.insert(0, '0');
                }
                ++dotPosition;
            }
            stringBuffer.insert(dotPosition, '.');
            if (precisionValue < 0L && stringBuffer.charAt(1) == '.') {
                stringBuffer.insert(1, '0');
            } else if (stringBuffer.charAt(0) == '.') {
                stringBuffer.insert(0, '0');
            }
            int currentPos = stringBuffer.length() - 1;
            while (currentPos > dotPosition && stringBuffer.charAt(currentPos) == '0') {
                stringBuffer.setCharAt(currentPos--, ' ');
            }
            if (stringBuffer.charAt(currentPos) == '.') {
                stringBuffer.setCharAt(currentPos, ' ');
            }
            return stringBuffer.toString().trim();
        }
        return new String("" + value);
    }

    public static String doubleToString(double value, int width, int afterDecimalPoint) {
        int dotPosition;
        String tempString = Utils.doubleToString(value, afterDecimalPoint);
        if (afterDecimalPoint >= width || tempString.indexOf(69) != -1) {
            return tempString;
        }
        char[] result = new char[width];
        int i = 0;
        while (i < result.length) {
            result[i] = 32;
            ++i;
        }
        if (afterDecimalPoint > 0) {
            dotPosition = tempString.indexOf(46);
            if (dotPosition == -1) {
                dotPosition = tempString.length();
            } else {
                result[width - afterDecimalPoint - 1] = 46;
            }
        } else {
            dotPosition = tempString.length();
        }
        int offset = width - afterDecimalPoint - dotPosition;
        if (afterDecimalPoint > 0) {
            --offset;
        }
        if (offset < 0) {
            return tempString;
        }
        int i2 = 0;
        while (i2 < dotPosition) {
            result[offset + i2] = tempString.charAt(i2);
            ++i2;
        }
        i2 = dotPosition + 1;
        while (i2 < tempString.length()) {
            result[offset + i2] = tempString.charAt(i2);
            ++i2;
        }
        return new String(result);
    }

    public static Class<?> getArrayClass(Class<?> c) {
        if (c.getComponentType().isArray()) {
            return Utils.getArrayClass(c.getComponentType());
        }
        return c.getComponentType();
    }

    public static int getArrayDimensions(Class<?> array) {
        if (array.getComponentType().isArray()) {
            return 1 + Utils.getArrayDimensions(array.getComponentType());
        }
        return 1;
    }

    public static int getArrayDimensions(Object array) {
        return Utils.getArrayDimensions(array.getClass());
    }

    public static String arrayToString(Object array) {
        String result = "";
        int dimensions = Utils.getArrayDimensions(array);
        if (dimensions == 0) {
            result = "null";
        } else if (dimensions == 1) {
            int i = 0;
            while (i < Array.getLength(array)) {
                if (i > 0) {
                    result = String.valueOf(result) + ",";
                }
                result = Array.get(array, i) == null ? String.valueOf(result) + "null" : String.valueOf(result) + Array.get(array, i).toString();
                ++i;
            }
        } else {
            int i = 0;
            while (i < Array.getLength(array)) {
                if (i > 0) {
                    result = String.valueOf(result) + ",";
                }
                result = String.valueOf(result) + "[" + Utils.arrayToString(Array.get(array, i)) + "]";
                ++i;
            }
        }
        return result;
    }

    public static boolean eq(double a, double b) {
        return a == b || a - b < SMALL && b - a < SMALL;
    }

    public static void checkForRemainingOptions(String[] options) throws Exception {
        int illegalOptionsFound = 0;
        StringBuffer text = new StringBuffer();
        if (options == null) {
            return;
        }
        String[] stringArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            if (option.length() > 0) {
                ++illegalOptionsFound;
                text.append(String.valueOf(option) + ' ');
            }
            ++n2;
        }
        if (illegalOptionsFound > 0) {
            throw new Exception("Illegal options: " + text);
        }
    }

    public static boolean getFlag(char flag, String[] options) throws Exception {
        return Utils.getFlag("" + flag, options);
    }

    public static boolean getFlag(String flag, String[] options) throws Exception {
        int pos = Utils.getOptionPos(flag, options);
        if (pos > -1) {
            options[pos] = "";
        }
        return pos > -1;
    }

    public static String getOption(char flag, String[] options) throws Exception {
        return Utils.getOption("" + flag, options);
    }

    public static String getOption(String flag, String[] options) throws Exception {
        int i = Utils.getOptionPos(flag, options);
        if (i > -1) {
            if (options[i].equals("-" + flag)) {
                if (i + 1 == options.length) {
                    throw new Exception("No value given for -" + flag + " option.");
                }
                options[i] = "";
                String newString = new String(options[i + 1]);
                options[i + 1] = "";
                return newString;
            }
            if (options[i].charAt(1) == '-') {
                return "";
            }
        }
        return "";
    }

    public static int getOptionPos(char flag, String[] options) {
        return Utils.getOptionPos("" + flag, options);
    }

    public static int getOptionPos(String flag, String[] options) {
        if (options == null) {
            return -1;
        }
        int i = 0;
        while (i < options.length) {
            block6: {
                if (options[i].length() > 0 && options[i].charAt(0) == '-') {
                    try {
                        Double.valueOf(options[i]);
                    }
                    catch (NumberFormatException e) {
                        if (options[i].equals("-" + flag)) {
                            return i;
                        }
                        if (options[i].charAt(1) != '-') break block6;
                        return -1;
                    }
                }
            }
            ++i;
        }
        return -1;
    }

    public static String quote(String string) {
        boolean quote = false;
        if (string.indexOf(10) != -1 || string.indexOf(13) != -1 || string.indexOf(39) != -1 || string.indexOf(34) != -1 || string.indexOf(92) != -1 || string.indexOf(9) != -1 || string.indexOf(37) != -1 || string.indexOf(30) != -1) {
            string = Utils.backQuoteChars(string);
            quote = true;
        }
        if (quote || string.indexOf(123) != -1 || string.indexOf(125) != -1 || string.indexOf(44) != -1 || string.equals("?") || string.indexOf(32) != -1 || string.equals("")) {
            string = "'".concat(string).concat("'");
        }
        return string;
    }

    public static String unquote(String string) {
        if (string.startsWith("'") && string.endsWith("'") && ((string = string.substring(1, string.length() - 1)).indexOf("\\n") != -1 || string.indexOf("\\r") != -1 || string.indexOf("\\'") != -1 || string.indexOf("\\\"") != -1 || string.indexOf("\\\\") != -1 || string.indexOf("\\t") != -1 || string.indexOf("\\%") != -1 || string.indexOf("\\u001E") != -1)) {
            string = Utils.unbackQuoteChars(string);
        }
        return string;
    }

    public static String backQuoteChars(String string) {
        char[] charsFind = new char[]{'\\', '\'', '\t', '\n', '\r', '\"', '%', '\u001e'};
        String[] charsReplace = new String[]{"\\\\", "\\'", "\\t", "\\n", "\\r", "\\\"", "\\%", "\\u001E"};
        int i = 0;
        while (i < charsFind.length) {
            if (string.indexOf(charsFind[i]) != -1) {
                int index;
                StringBuffer newStringBuffer = new StringBuffer();
                while ((index = string.indexOf(charsFind[i])) != -1) {
                    if (index > 0) {
                        newStringBuffer.append(string.substring(0, index));
                    }
                    newStringBuffer.append(charsReplace[i]);
                    string = index + 1 < string.length() ? string.substring(index + 1) : "";
                }
                newStringBuffer.append(string);
                string = newStringBuffer.toString();
            }
            ++i;
        }
        return string;
    }

    public static String convertNewLines(String string) {
        int index;
        StringBuffer newStringBuffer = new StringBuffer();
        while ((index = string.indexOf(10)) != -1) {
            if (index > 0) {
                newStringBuffer.append(string.substring(0, index));
            }
            newStringBuffer.append('\\');
            newStringBuffer.append('n');
            string = index + 1 < string.length() ? string.substring(index + 1) : "";
        }
        newStringBuffer.append(string);
        string = newStringBuffer.toString();
        newStringBuffer = new StringBuffer();
        while ((index = string.indexOf(13)) != -1) {
            if (index > 0) {
                newStringBuffer.append(string.substring(0, index));
            }
            newStringBuffer.append('\\');
            newStringBuffer.append('r');
            string = index + 1 < string.length() ? string.substring(index + 1) : "";
        }
        newStringBuffer.append(string);
        return newStringBuffer.toString();
    }

    public static String revertNewLines(String string) {
        int index;
        StringBuffer newStringBuffer = new StringBuffer();
        while ((index = string.indexOf("\\n")) != -1) {
            if (index > 0) {
                newStringBuffer.append(string.substring(0, index));
            }
            newStringBuffer.append('\n');
            string = index + 2 < string.length() ? string.substring(index + 2) : "";
        }
        newStringBuffer.append(string);
        string = newStringBuffer.toString();
        newStringBuffer = new StringBuffer();
        while ((index = string.indexOf("\\r")) != -1) {
            if (index > 0) {
                newStringBuffer.append(string.substring(0, index));
            }
            newStringBuffer.append('\r');
            string = index + 2 < string.length() ? string.substring(index + 2) : "";
        }
        newStringBuffer.append(string);
        return newStringBuffer.toString();
    }

    public static String[] partitionOptions(String[] options) {
        int i = 0;
        while (i < options.length) {
            if (options[i].equals("--")) {
                options[i++] = "";
                String[] result = new String[options.length - i];
                int j = i;
                while (j < options.length) {
                    result[j - i] = options[j];
                    options[j] = "";
                    ++j;
                }
                return result;
            }
            ++i;
        }
        return new String[0];
    }

    public static String unbackQuoteChars(String string) {
        String[] charsFind = new String[]{"\\\\", "\\'", "\\t", "\\n", "\\r", "\\\"", "\\%", "\\u001E"};
        char[] charsReplace = new char[]{'\\', '\'', '\t', '\n', '\r', '\"', '%', '\u001e'};
        int[] pos = new int[charsFind.length];
        String str = new String(string);
        StringBuffer newStringBuffer = new StringBuffer();
        while (str.length() > 0) {
            int curPos = str.length();
            int index = -1;
            int i = 0;
            while (i < pos.length) {
                pos[i] = str.indexOf(charsFind[i]);
                if (pos[i] > -1 && pos[i] < curPos) {
                    index = i;
                    curPos = pos[i];
                }
                ++i;
            }
            if (index == -1) {
                newStringBuffer.append(str);
                str = "";
                continue;
            }
            newStringBuffer.append(str.substring(0, pos[index]));
            newStringBuffer.append(charsReplace[index]);
            str = str.substring(pos[index] + charsFind[index].length());
        }
        return newStringBuffer.toString();
    }

    public static String[] splitOptions(String quotedOptionString) throws Exception {
        int i;
        Vector<String> optionsVec = new Vector<String>();
        String str = new String(quotedOptionString);
        while (true) {
            String optStr;
            i = 0;
            while (i < str.length() && Character.isWhitespace(str.charAt(i))) {
                ++i;
            }
            if ((str = str.substring(i)).length() == 0) break;
            if (str.charAt(0) == '\"') {
                i = 1;
                while (i < str.length()) {
                    if (str.charAt(i) == str.charAt(0)) break;
                    if (str.charAt(i) == '\\' && ++i >= str.length()) {
                        throw new Exception("String should not finish with \\");
                    }
                    ++i;
                }
                if (i >= str.length()) {
                    throw new Exception("Quote parse error.");
                }
                optStr = str.substring(1, i);
                optStr = Utils.unbackQuoteChars(optStr);
                optionsVec.addElement(optStr);
                str = str.substring(i + 1);
                continue;
            }
            i = 0;
            while (i < str.length() && !Character.isWhitespace(str.charAt(i))) {
                ++i;
            }
            optStr = str.substring(0, i);
            optionsVec.addElement(optStr);
            str = str.substring(i);
        }
        String[] options = new String[optionsVec.size()];
        i = 0;
        while (i < optionsVec.size()) {
            options[i] = (String)optionsVec.elementAt(i);
            ++i;
        }
        return options;
    }

    public static String joinOptions(String[] optionArray) {
        String optionString = "";
        String[] stringArray = optionArray;
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (!element.equals("")) {
                boolean escape = false;
                int n3 = 0;
                while (n3 < element.length()) {
                    if (Character.isWhitespace(element.charAt(n3))) {
                        escape = true;
                        break;
                    }
                    ++n3;
                }
                optionString = escape ? String.valueOf(optionString) + '\"' + Utils.backQuoteChars(element) + '\"' : String.valueOf(optionString) + element;
                optionString = String.valueOf(optionString) + " ";
            }
            ++n2;
        }
        return optionString.trim();
    }

    public static Object forName(Class<?> classType, String className, String[] options) throws Exception {
        List<String> matches = Run.findSchemeMatch(classType, className, false, true);
        if (matches.size() == 0) {
            throw new Exception("Can't find class called: " + className);
        }
        if (matches.size() > 1) {
            StringBuffer sb = new StringBuffer("More than one possibility matched '" + className + "':\n");
            for (String s : matches) {
                sb.append("  " + s + '\n');
            }
            throw new Exception(sb.toString());
        }
        className = matches.get(0);
        Class<?> c = null;
        try {
            c = Class.forName(className);
        }
        catch (Exception ex) {
            throw new Exception("Can't find class called: " + className);
        }
        Object o = c.newInstance();
        if (o instanceof OptionHandler && options != null) {
            ((OptionHandler)o).setOptions(options);
            Utils.checkForRemainingOptions(options);
        }
        return o;
    }

    public static String toCommandLine(Object obj) {
        StringBuffer result = new StringBuffer();
        if (obj != null) {
            result.append(obj.getClass().getName());
            if (obj instanceof OptionHandler) {
                result.append(" " + Utils.joinOptions(((OptionHandler)obj).getOptions()));
            }
        }
        return result.toString().trim();
    }

    public static double info(int[] counts) {
        int total = 0;
        double x = 0.0;
        int[] nArray = counts;
        int n = counts.length;
        int n2 = 0;
        while (n2 < n) {
            int count = nArray[n2];
            x -= Utils.xlogx(count);
            total += count;
            ++n2;
        }
        return x + Utils.xlogx(total);
    }

    public static boolean smOrEq(double a, double b) {
        return a - b < SMALL || a <= b;
    }

    public static boolean grOrEq(double a, double b) {
        return b - a < SMALL || a >= b;
    }

    public static boolean sm(double a, double b) {
        return b - a > SMALL;
    }

    public static boolean gr(double a, double b) {
        return a - b > SMALL;
    }

    public static int kthSmallestValue(int[] array, int k) {
        int[] index = Utils.initialIndex(array.length);
        return array[index[Utils.select(array, index, 0, array.length - 1, k)]];
    }

    public static double kthSmallestValue(double[] array, int k) {
        int[] index = Utils.initialIndex(array.length);
        return array[index[Utils.select(array, index, 0, array.length - 1, k)]];
    }

    public static double log2(double a) {
        return Math.log(a) / log2;
    }

    public static int maxIndex(double[] doubles) {
        double maximum = 0.0;
        int maxIndex = 0;
        int i = 0;
        while (i < doubles.length) {
            if (i == 0 || doubles[i] > maximum) {
                maxIndex = i;
                maximum = doubles[i];
            }
            ++i;
        }
        return maxIndex;
    }

    public static int maxIndex(int[] ints) {
        int maximum = 0;
        int maxIndex = 0;
        int i = 0;
        while (i < ints.length) {
            if (i == 0 || ints[i] > maximum) {
                maxIndex = i;
                maximum = ints[i];
            }
            ++i;
        }
        return maxIndex;
    }

    public static double mean(double[] vector) {
        double sum = 0.0;
        if (vector.length == 0) {
            return 0.0;
        }
        double[] dArray = vector;
        int n = vector.length;
        int n2 = 0;
        while (n2 < n) {
            double element = dArray[n2];
            sum += element;
            ++n2;
        }
        return sum / (double)vector.length;
    }

    public static int minIndex(int[] ints) {
        int minimum = 0;
        int minIndex = 0;
        int i = 0;
        while (i < ints.length) {
            if (i == 0 || ints[i] < minimum) {
                minIndex = i;
                minimum = ints[i];
            }
            ++i;
        }
        return minIndex;
    }

    public static int minIndex(double[] doubles) {
        double minimum = 0.0;
        int minIndex = 0;
        int i = 0;
        while (i < doubles.length) {
            if (i == 0 || doubles[i] < minimum) {
                minIndex = i;
                minimum = doubles[i];
            }
            ++i;
        }
        return minIndex;
    }

    public static void normalize(double[] doubles) {
        double sum = 0.0;
        double[] dArray = doubles;
        int n = doubles.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            sum += d;
            ++n2;
        }
        Utils.normalize(doubles, sum);
    }

    public static void normalize(double[] doubles, double sum) {
        if (Double.isNaN(sum)) {
            throw new IllegalArgumentException("Can't normalize array. Sum is NaN.");
        }
        if (sum == 0.0) {
            throw new IllegalArgumentException("Can't normalize array. Sum is zero.");
        }
        int i = 0;
        while (i < doubles.length) {
            int n = i++;
            doubles[n] = doubles[n] / sum;
        }
    }

    public static double[] logs2probs(double[] a) {
        double max = a[Utils.maxIndex(a)];
        double sum = 0.0;
        double[] result = new double[a.length];
        int i = 0;
        while (i < a.length) {
            result[i] = Math.exp(a[i] - max);
            sum += result[i];
            ++i;
        }
        Utils.normalize(result, sum);
        return result;
    }

    public static double probToLogOdds(double prob) {
        if (Utils.gr(prob, 1.0) || Utils.sm(prob, 0.0)) {
            throw new IllegalArgumentException("probToLogOdds: probability must be in [0,1] " + prob);
        }
        double p = SMALL + (1.0 - 2.0 * SMALL) * prob;
        return Math.log(p / (1.0 - p));
    }

    public static int round(double value) {
        int roundedValue = value > 0.0 ? (int)(value + 0.5) : -((int)(Math.abs(value) + 0.5));
        return roundedValue;
    }

    public static int probRound(double value, Random rand) {
        if (value >= 0.0) {
            double lower = Math.floor(value);
            double prob = value - lower;
            if (rand.nextDouble() < prob) {
                return (int)lower + 1;
            }
            return (int)lower;
        }
        double lower = Math.floor(Math.abs(value));
        double prob = Math.abs(value) - lower;
        if (rand.nextDouble() < prob) {
            return -((int)lower + 1);
        }
        return -((int)lower);
    }

    public static void replaceMissingWithMAX_VALUE(double[] array) {
        int i = 0;
        while (i < array.length) {
            if (Utils.isMissingValue(array[i])) {
                array[i] = Double.MAX_VALUE;
            }
            ++i;
        }
    }

    public static double roundDouble(double value, int afterDecimalPoint) {
        double mask = Math.pow(10.0, afterDecimalPoint);
        return (double)Math.round(value * mask) / mask;
    }

    public static int[] sort(int[] array) {
        int[] index = Utils.initialIndex(array.length);
        int[] newIndex = new int[array.length];
        Utils.quickSort(array, index, 0, array.length - 1);
        int i = 0;
        while (i < index.length) {
            int numEqual = 1;
            int j = i + 1;
            while (j < index.length && array[index[i]] == array[index[j]]) {
                ++numEqual;
                ++j;
            }
            if (numEqual > 1) {
                int[] helpIndex = new int[numEqual];
                j = 0;
                while (j < numEqual) {
                    helpIndex[j] = i + j;
                    ++j;
                }
                Utils.quickSort(index, helpIndex, 0, numEqual - 1);
                j = 0;
                while (j < numEqual) {
                    newIndex[i + j] = index[helpIndex[j]];
                    ++j;
                }
                i += numEqual;
                continue;
            }
            newIndex[i] = index[i];
            ++i;
        }
        return newIndex;
    }

    public static int[] sort(double[] array) {
        int[] index = Utils.initialIndex(array.length);
        if (array.length > 1) {
            array = (double[])array.clone();
            Utils.replaceMissingWithMAX_VALUE(array);
            Utils.quickSort(array, index, 0, array.length - 1);
        }
        return index;
    }

    public static int[] sortWithNoMissingValues(double[] array) {
        int[] index = Utils.initialIndex(array.length);
        if (array.length > 1) {
            Utils.quickSort(array, index, 0, array.length - 1);
        }
        return index;
    }

    public static int[] stableSort(double[] array) {
        int[] index = Utils.initialIndex(array.length);
        if (array.length > 1) {
            int[] newIndex = new int[array.length];
            array = (double[])array.clone();
            Utils.replaceMissingWithMAX_VALUE(array);
            Utils.quickSort(array, index, 0, array.length - 1);
            int i = 0;
            while (i < index.length) {
                int numEqual = 1;
                int j = i + 1;
                while (j < index.length && Utils.eq(array[index[i]], array[index[j]])) {
                    ++numEqual;
                    ++j;
                }
                if (numEqual > 1) {
                    int[] helpIndex = new int[numEqual];
                    j = 0;
                    while (j < numEqual) {
                        helpIndex[j] = i + j;
                        ++j;
                    }
                    Utils.quickSort(index, helpIndex, 0, numEqual - 1);
                    j = 0;
                    while (j < numEqual) {
                        newIndex[i + j] = index[helpIndex[j]];
                        ++j;
                    }
                    i += numEqual;
                    continue;
                }
                newIndex[i] = index[i];
                ++i;
            }
            return newIndex;
        }
        return index;
    }

    public static double variance(double[] vector) {
        double sum = 0.0;
        double sumSquared = 0.0;
        if (vector.length <= 1) {
            return 0.0;
        }
        double[] dArray = vector;
        int n = vector.length;
        int n2 = 0;
        while (n2 < n) {
            double element = dArray[n2];
            sum += element;
            sumSquared += element * element;
            ++n2;
        }
        double result = (sumSquared - sum * sum / (double)vector.length) / (double)(vector.length - 1);
        if (result < 0.0) {
            return 0.0;
        }
        return result;
    }

    public static double sum(double[] doubles) {
        double sum = 0.0;
        double[] dArray = doubles;
        int n = doubles.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            sum += d;
            ++n2;
        }
        return sum;
    }

    public static int sum(int[] ints) {
        int sum = 0;
        int[] nArray = ints;
        int n = ints.length;
        int n2 = 0;
        while (n2 < n) {
            int j = nArray[n2];
            sum += j;
            ++n2;
        }
        return sum;
    }

    public static double xlogx(int c) {
        if (c == 0) {
            return 0.0;
        }
        return (double)c * Utils.log2(c);
    }

    private static int[] initialIndex(int size) {
        int[] index = new int[size];
        int i = 0;
        while (i < size) {
            index[i] = i;
            ++i;
        }
        return index;
    }

    private static int sortLeftRightAndCenter(double[] array, int[] index, int l, int r) {
        int c = (l + r) / 2;
        Utils.conditionalSwap(array, index, l, c);
        Utils.conditionalSwap(array, index, l, r);
        Utils.conditionalSwap(array, index, c, r);
        return c;
    }

    private static void swap(int[] index, int l, int r) {
        int help = index[l];
        index[l] = index[r];
        index[r] = help;
    }

    private static void conditionalSwap(double[] array, int[] index, int left, int right) {
        if (array[index[left]] > array[index[right]]) {
            int help = index[left];
            index[left] = index[right];
            index[right] = help;
        }
    }

    private static int partition(double[] array, int[] index, int l, int r, double pivot) {
        --r;
        while (true) {
            if (array[index[++l]] < pivot) {
                continue;
            }
            while (array[index[--r]] > pivot) {
            }
            if (l >= r) {
                return l;
            }
            Utils.swap(index, l, r);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static int partition(int[] array, int[] index, int l, int r) {
        pivot = array[index[(l + r) / 2]];
        ** GOTO lbl15
        {
            ++l;
            do {
                if ((double)array[index[l]] < pivot && l < r) continue block0;
                while ((double)array[index[r]] > pivot && l < r) {
                    --r;
                }
                if (l >= r) continue;
                help = index[l];
                index[l] = index[r];
                index[r] = help;
                ++l;
                --r;
lbl15:
                // 3 sources

            } while (l < r);
        }
        if (l == r && (double)array[index[r]] > pivot) {
            --r;
        }
        return r;
    }

    private static void quickSort(double[] array, int[] index, int left, int right) {
        int diff = right - left;
        switch (diff) {
            case 0: {
                return;
            }
            case 1: {
                Utils.conditionalSwap(array, index, left, right);
                return;
            }
            case 2: {
                Utils.conditionalSwap(array, index, left, left + 1);
                Utils.conditionalSwap(array, index, left, right);
                Utils.conditionalSwap(array, index, left + 1, right);
                return;
            }
        }
        int pivotLocation = Utils.sortLeftRightAndCenter(array, index, left, right);
        Utils.swap(index, pivotLocation, right - 1);
        int center = Utils.partition(array, index, left, right, array[index[right - 1]]);
        Utils.swap(index, center, right - 1);
        Utils.quickSort(array, index, left, center - 1);
        Utils.quickSort(array, index, center + 1, right);
    }

    private static void quickSort(int[] array, int[] index, int left, int right) {
        if (left < right) {
            int middle = Utils.partition(array, index, left, right);
            Utils.quickSort(array, index, left, middle);
            Utils.quickSort(array, index, middle + 1, right);
        }
    }

    private static int select(double[] array, int[] index, int left, int right, int k) {
        int diff = right - left;
        switch (diff) {
            case 0: {
                return left;
            }
            case 1: {
                Utils.conditionalSwap(array, index, left, right);
                return left + k - 1;
            }
            case 2: {
                Utils.conditionalSwap(array, index, left, left + 1);
                Utils.conditionalSwap(array, index, left, right);
                Utils.conditionalSwap(array, index, left + 1, right);
                return left + k - 1;
            }
        }
        int pivotLocation = Utils.sortLeftRightAndCenter(array, index, left, right);
        Utils.swap(index, pivotLocation, right - 1);
        int center = Utils.partition(array, index, left, right, array[index[right - 1]]);
        Utils.swap(index, center, right - 1);
        if (center - left + 1 >= k) {
            return Utils.select(array, index, left, center, k);
        }
        return Utils.select(array, index, center + 1, right, k - (center - left + 1));
    }

    public static File convertToRelativePath(File absolute) throws Exception {
        File result = null;
        if (File.separator.equals("\\")) {
            try {
                String fileStr = absolute.getPath();
                fileStr = String.valueOf(fileStr.substring(0, 1).toLowerCase()) + fileStr.substring(1);
                result = Utils.createRelativePath(new File(fileStr));
            }
            catch (Exception e) {
                result = Utils.createRelativePath(absolute);
            }
        } else {
            result = Utils.createRelativePath(absolute);
        }
        return result;
    }

    protected static File createRelativePath(File absolute) throws Exception {
        File userDir = new File(System.getProperty("user.dir"));
        String userPath = String.valueOf(userDir.getAbsolutePath()) + File.separator;
        String targetPath = String.valueOf(new File(absolute.getParent()).getPath()) + File.separator;
        String fileName = absolute.getName();
        StringBuffer relativePath = new StringBuffer();
        int subdir = targetPath.indexOf(userPath);
        if (subdir == 0) {
            if (userPath.length() == targetPath.length()) {
                relativePath.append(fileName);
            } else {
                int ll = userPath.length();
                relativePath.append(targetPath.substring(ll));
                relativePath.append(fileName);
            }
        } else {
            int sepCount = 0;
            String temp = new String(userPath);
            while (temp.indexOf(File.separator) != -1) {
                int ind = temp.indexOf(File.separator);
                ++sepCount;
                temp = temp.substring(ind + 1, temp.length());
            }
            String targetTemp = new String(targetPath);
            String userTemp = new String(userPath);
            int tcount = 0;
            while (targetTemp.indexOf(File.separator) != -1) {
                String upart;
                int ind = targetTemp.indexOf(File.separator);
                int ind2 = userTemp.indexOf(File.separator);
                String tpart = targetTemp.substring(0, ind + 1);
                if (tpart.compareTo(upart = userTemp.substring(0, ind2 + 1)) != 0) {
                    if (tcount != 0) break;
                    tcount = -1;
                    break;
                }
                ++tcount;
                targetTemp = targetTemp.substring(ind + 1, targetTemp.length());
                userTemp = userTemp.substring(ind2 + 1, userTemp.length());
            }
            if (tcount == -1) {
                throw new Exception("Can't construct a path to file relative to user dir.");
            }
            if (targetTemp.indexOf(File.separator) == -1) {
                targetTemp = "";
            }
            int i = 0;
            while (i < sepCount - tcount) {
                relativePath.append(".." + File.separator);
                ++i;
            }
            relativePath.append(String.valueOf(targetTemp) + fileName);
        }
        return new File(relativePath.toString());
    }

    private static int select(int[] array, int[] index, int left, int right, int k) {
        if (left == right) {
            return left;
        }
        int middle = Utils.partition(array, index, left, right);
        if (middle - left + 1 >= k) {
            return Utils.select(array, index, left, middle, k);
        }
        return Utils.select(array, index, middle + 1, right, k - (middle - left + 1));
    }

    public static boolean getDontShowDialog(String dialogName) {
        File wekaHome = WekaPackageManager.WEKA_HOME;
        if (!wekaHome.exists()) {
            return false;
        }
        File dialogSubDir = new File(String.valueOf(wekaHome.toString()) + File.separator + "systemDialogs");
        if (!dialogSubDir.exists()) {
            return false;
        }
        File dialogFile = new File(String.valueOf(dialogSubDir.toString()) + File.separator + dialogName);
        return dialogFile.exists();
    }

    public static void setDontShowDialog(String dialogName) throws Exception {
        File wekaHome = WekaPackageManager.WEKA_HOME;
        if (!wekaHome.exists()) {
            return;
        }
        File dialogSubDir = new File(String.valueOf(wekaHome.toString()) + File.separator + "systemDialogs");
        if (!dialogSubDir.exists() && !dialogSubDir.mkdir()) {
            return;
        }
        File dialogFile = new File(String.valueOf(dialogSubDir.toString()) + File.separator + dialogName);
        dialogFile.createNewFile();
    }

    public static String getDontShowDialogResponse(String dialogName) throws Exception {
        if (!Utils.getDontShowDialog(dialogName)) {
            return null;
        }
        File wekaHome = WekaPackageManager.WEKA_HOME;
        File dialogSubDir = new File(String.valueOf(wekaHome.toString()) + File.separator + "systemDialogs" + File.separator + dialogName);
        BufferedReader br = new BufferedReader(new FileReader(dialogSubDir));
        String response = br.readLine();
        br.close();
        return response;
    }

    public static void setDontShowDialogResponse(String dialogName, String response) throws Exception {
        File wekaHome = WekaPackageManager.WEKA_HOME;
        if (!wekaHome.exists()) {
            return;
        }
        File dialogSubDir = new File(String.valueOf(wekaHome.toString()) + File.separator + "systemDialogs");
        if (!dialogSubDir.exists() && !dialogSubDir.mkdir()) {
            return;
        }
        File dialogFile = new File(String.valueOf(dialogSubDir.toString()) + File.separator + dialogName);
        BufferedWriter br = new BufferedWriter(new FileWriter(dialogFile));
        br.write(String.valueOf(response) + "\n");
        br.flush();
        br.close();
    }

    public static String[] breakUp(String s, int columns) {
        Vector<String> result = new Vector<String>();
        String punctuation = " .,;:!?'\"";
        String[] lines = s.split("\n");
        int i = 0;
        while (i < lines.length) {
            BreakIterator boundary = BreakIterator.getWordInstance();
            boundary.setText(lines[i]);
            int boundaryStart = boundary.first();
            int boundaryEnd = boundary.next();
            String line = "";
            while (boundaryEnd != -1) {
                String word = lines[i].substring(boundaryStart, boundaryEnd);
                if (line.length() >= columns) {
                    if (word.length() == 1 && punctuation.indexOf(word.charAt(0)) > -1) {
                        line = String.valueOf(line) + word;
                        word = "";
                    }
                    result.add(line);
                    line = "";
                }
                line = String.valueOf(line) + word;
                boundaryStart = boundaryEnd;
                boundaryEnd = boundary.next();
            }
            if (line.length() > 0) {
                result.add(line);
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10319 $");
    }

    public static void main(String[] ops) {
        double[] doublesWithNaN = new double[]{4.5, 6.7, Double.NaN, 3.4, 4.8, 1.2, 3.4};
        double[] doubles = new double[]{4.5, 6.7, 6.7, 3.4, 4.8, 1.2, 3.4, 6.7, 6.7, 3.4};
        int[] ints = new int[]{12, 6, 2, 18, 16, 6, 7, 5, 18, 18, 17};
        try {
            int n;
            int n2;
            String[] stringArray;
            System.out.println("First option split up:");
            if (ops.length > 0) {
                String[] firstOptionSplitUp;
                stringArray = firstOptionSplitUp = Utils.splitOptions(ops[0]);
                n2 = firstOptionSplitUp.length;
                n = 0;
                while (n < n2) {
                    String element = stringArray[n];
                    System.out.println(element);
                    ++n;
                }
            }
            System.out.println("Partitioned options: ");
            String[] partitionedOptions = Utils.partitionOptions(ops);
            stringArray = partitionedOptions;
            n2 = partitionedOptions.length;
            n = 0;
            while (n < n2) {
                String partitionedOption = stringArray[n];
                System.out.println(partitionedOption);
                ++n;
            }
            System.out.println("Get position of flag -f: " + Utils.getOptionPos('f', ops));
            System.out.println("Get flag -f: " + Utils.getFlag('f', ops));
            System.out.println("Get position of option -o: " + Utils.getOptionPos('o', ops));
            System.out.println("Get option -o: " + Utils.getOption('o', ops));
            System.out.println("Checking for remaining options... ");
            Utils.checkForRemainingOptions(ops);
            System.out.println("Original array with NaN (doubles): ");
            double[] dArray = doublesWithNaN;
            int n3 = doublesWithNaN.length;
            n2 = 0;
            while (n2 < n3) {
                double element = dArray[n2];
                System.out.print(String.valueOf(element) + " ");
                ++n2;
            }
            System.out.println();
            System.out.println("Original array (doubles): ");
            dArray = doubles;
            n3 = doubles.length;
            n2 = 0;
            while (n2 < n3) {
                double d = dArray[n2];
                System.out.print(String.valueOf(d) + " ");
                ++n2;
            }
            System.out.println();
            System.out.println("Original array (ints): ");
            int[] nArray = ints;
            n2 = ints.length;
            n = 0;
            while (n < n2) {
                int j = nArray[n];
                System.out.print(String.valueOf(j) + " ");
                ++n;
            }
            System.out.println();
            System.out.println("Correlation: " + Utils.correlation(doubles, doubles, doubles.length));
            System.out.println("Mean: " + Utils.mean(doubles));
            System.out.println("Variance: " + Utils.variance(doubles));
            System.out.println("Sum (doubles): " + Utils.sum(doubles));
            System.out.println("Sum (ints): " + Utils.sum(ints));
            System.out.println("Max index (doubles): " + Utils.maxIndex(doubles));
            System.out.println("Max index (ints): " + Utils.maxIndex(ints));
            System.out.println("Min index (doubles): " + Utils.minIndex(doubles));
            System.out.println("Min index (ints): " + Utils.minIndex(ints));
            System.out.println("Median (doubles): " + Utils.kthSmallestValue(doubles, doubles.length / 2));
            System.out.println("Median (ints): " + Utils.kthSmallestValue(ints, ints.length / 2));
            System.out.println("Sorted array with NaN (doubles): ");
            int[] sorted = Utils.sort(doublesWithNaN);
            int i = 0;
            while (i < doublesWithNaN.length) {
                System.out.print(String.valueOf(doublesWithNaN[sorted[i]]) + " ");
                ++i;
            }
            System.out.println();
            System.out.println("Sorted array (doubles): ");
            sorted = Utils.sort(doubles);
            i = 0;
            while (i < doubles.length) {
                System.out.print(String.valueOf(doubles[sorted[i]]) + " ");
                ++i;
            }
            System.out.println();
            System.out.println("Sorted array (ints): ");
            sorted = Utils.sort(ints);
            i = 0;
            while (i < ints.length) {
                System.out.print(String.valueOf(ints[sorted[i]]) + " ");
                ++i;
            }
            System.out.println();
            System.out.println("Indices from stable sort (doubles): ");
            sorted = Utils.stableSort(doubles);
            i = 0;
            while (i < doubles.length) {
                System.out.print(String.valueOf(sorted[i]) + " ");
                ++i;
            }
            System.out.println();
            System.out.println("Indices from sort (ints): ");
            sorted = Utils.sort(ints);
            i = 0;
            while (i < ints.length) {
                System.out.print(String.valueOf(sorted[i]) + " ");
                ++i;
            }
            System.out.println();
            System.out.println("Normalized array (doubles): ");
            Utils.normalize(doubles);
            double[] dArray2 = doubles;
            int n4 = doubles.length;
            int n5 = 0;
            while (n5 < n4) {
                double d = dArray2[n5];
                System.out.print(String.valueOf(d) + " ");
                ++n5;
            }
            System.out.println();
            System.out.println("Normalized again (doubles): ");
            Utils.normalize(doubles, Utils.sum(doubles));
            dArray2 = doubles;
            n4 = doubles.length;
            n5 = 0;
            while (n5 < n4) {
                double d = dArray2[n5];
                System.out.print(String.valueOf(d) + " ");
                ++n5;
            }
            System.out.println();
            System.out.println("-4.58: " + Utils.doubleToString(-4.57826535, 2));
            System.out.println("-6.78: " + Utils.doubleToString(-6.78214234, 6, 2));
            System.out.println("5.70001 == 5.7 ? " + Utils.eq(5.70001, 5.7));
            System.out.println("5.70001 > 5.7 ? " + Utils.gr(5.70001, 5.7));
            System.out.println("5.70001 >= 5.7 ? " + Utils.grOrEq(5.70001, 5.7));
            System.out.println("5.7 < 5.70001 ? " + Utils.sm(5.7, 5.70001));
            System.out.println("5.7 <= 5.70001 ? " + Utils.smOrEq(5.7, 5.70001));
            System.out.println("Info (ints): " + Utils.info(ints));
            System.out.println("log2(4.6): " + Utils.log2(4.6));
            System.out.println("5 * log(5): " + Utils.xlogx(5));
            System.out.println("5.5 rounded: " + Utils.round(5.5));
            System.out.println("5.55555 rounded to 2 decimal places: " + Utils.roundDouble(5.55555, 2));
            System.out.println("Array-Dimensions of 'new int[][]': " + Utils.getArrayDimensions(new int[0][]));
            System.out.println("Array-Dimensions of 'new int[][]{{1,2,3},{4,5,6}}': " + Utils.getArrayDimensions(new int[][]{{1, 2, 3}, {4, 5, 6}}));
            String[][][] s = new String[3][4][];
            System.out.println("Array-Dimensions of 'new String[3][4][]': " + Utils.getArrayDimensions(s));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

