/*
 * Decompiled with CFR 0.152.
 */
package weka.core.logging;

import java.io.PrintStream;
import java.util.Date;
import weka.core.RevisionUtils;
import weka.core.Tee;
import weka.core.logging.FileLogger;
import weka.core.logging.Logger;

public class OutputLogger
extends FileLogger {
    protected OutputPrintStream m_StreamOut;
    protected OutputPrintStream m_StreamErr;
    protected Tee m_StdOut;
    protected Tee m_StdErr;

    @Override
    protected void initialize() {
        super.initialize();
        try {
            this.m_StdOut = new Tee(System.out);
            System.setOut(this.m_StdOut);
            this.m_StreamOut = new OutputPrintStream(this, this.m_StdOut.getDefault());
            this.m_StdOut.add(this.m_StreamOut);
            this.m_StdErr = new Tee(System.err);
            System.setErr(this.m_StdErr);
            this.m_StreamErr = new OutputPrintStream(this, this.m_StdErr.getDefault());
            this.m_StdErr.add(this.m_StreamErr);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void doLog(Logger.Level level, String msg, String cls, String method, int lineno) {
        this.append(String.valueOf(m_DateFormat.format(new Date())) + " " + cls + " " + method + this.m_LineFeed + (Object)((Object)level) + ": " + msg + this.m_LineFeed);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static class OutputPrintStream
    extends PrintStream {
        protected OutputLogger m_Owner;
        protected String m_LineFeed;

        public OutputPrintStream(OutputLogger owner, PrintStream stream) throws Exception {
            super(stream);
            this.m_Owner = owner;
            this.m_LineFeed = System.getProperty("line.separator");
        }

        @Override
        public void flush() {
        }

        @Override
        public void print(int x) {
            this.m_Owner.append("" + x);
        }

        @Override
        public void print(boolean x) {
            this.m_Owner.append("" + x);
        }

        @Override
        public void print(String x) {
            this.m_Owner.append(x);
        }

        @Override
        public void print(Object x) {
            this.m_Owner.append("" + x);
        }

        @Override
        public void println() {
            this.m_Owner.append(this.m_LineFeed);
        }

        @Override
        public void println(int x) {
            this.m_Owner.append(String.valueOf(x) + this.m_LineFeed);
        }

        @Override
        public void println(boolean x) {
            this.m_Owner.append(String.valueOf(x) + this.m_LineFeed);
        }

        @Override
        public void println(String x) {
            this.m_Owner.append(String.valueOf(x) + this.m_LineFeed);
        }

        @Override
        public void println(Object x) {
            this.m_Owner.append(x + this.m_LineFeed);
        }
    }
}

