/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import weka.core.Statistics;
import weka.core.Utils;
import weka.estimators.UnivariateDensityEstimator;
import weka.estimators.UnivariateIntervalEstimator;
import weka.estimators.UnivariateNormalEstimator;
import weka.estimators.UnivariateQuantileEstimator;

public class UnivariateEqualFrequencyHistogramEstimator
implements UnivariateDensityEstimator,
UnivariateIntervalEstimator,
UnivariateQuantileEstimator {
    protected TreeMap<Double, Double> m_TM = new TreeMap();
    protected double[] m_Boundaries = null;
    protected double[] m_Weights = null;
    protected double m_WeightedSum = 0.0;
    protected double m_WeightedSumSquared = 0.0;
    protected double m_SumOfWeights = 0.0;
    protected int m_NumBins = 10;
    protected double m_Width = Double.MAX_VALUE;
    protected double m_Exponent = -0.25;
    protected double m_MinWidth = 1.0E-6;
    public static final double CONST = -0.5 * Math.log(Math.PI * 2);
    protected int m_NumIntervals = 1000;
    protected boolean m_UpdateWeightsOnly = false;

    public int getNumBins() {
        return this.m_NumBins;
    }

    public void setNumBins(int numBins) {
        this.m_NumBins = numBins;
    }

    public void initializeStatistics() {
        this.updateBoundariesAndOrWeights();
        this.m_TM = new TreeMap();
        this.m_WeightedSum = 0.0;
        this.m_WeightedSumSquared = 0.0;
        this.m_SumOfWeights = 0.0;
        this.m_Weights = null;
    }

    public void setUpdateWeightsOnly(boolean flag) {
        this.m_UpdateWeightsOnly = flag;
    }

    public boolean getUpdateWeightsOnly() {
        return this.m_UpdateWeightsOnly;
    }

    @Override
    public void addValue(double value, double weight) {
        this.m_WeightedSum += value * weight;
        this.m_WeightedSumSquared += value * value * weight;
        this.m_SumOfWeights += weight;
        if (this.m_TM.get(value) == null) {
            this.m_TM.put(value, weight);
        } else {
            this.m_TM.put(value, this.m_TM.get(value) + weight);
        }
        if (!this.getUpdateWeightsOnly()) {
            this.m_Boundaries = null;
        }
        this.m_Weights = null;
    }

    protected void updateBoundariesAndOrWeights() {
        if (this.m_Weights != null) {
            return;
        }
        double mean = this.m_WeightedSum / this.m_SumOfWeights;
        double variance = this.m_WeightedSumSquared / this.m_SumOfWeights - mean * mean;
        if (variance < 0.0) {
            variance = 0.0;
        }
        this.m_Width = Math.sqrt(variance) * Math.pow(this.m_SumOfWeights, this.m_Exponent);
        if (this.m_Width <= this.m_MinWidth) {
            this.m_Width = this.m_MinWidth;
        }
        if (this.getUpdateWeightsOnly()) {
            this.updateWeightsOnly();
        } else {
            this.updateBoundariesAndWeights();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void updateWeightsOnly() throws IllegalArgumentException {
        itr = this.m_TM.entrySet().iterator();
        j = 1;
        this.m_Weights = new double[this.m_Boundaries.length - 1];
        while (itr.hasNext()) {
            entry = itr.next();
            value = entry.getKey();
            weight = entry.getValue();
            if (!(value < this.m_Boundaries[0]) && !(value > this.m_Boundaries[this.m_Boundaries.length - 1])) ** GOTO lbl11
            throw new IllegalArgumentException("Out-of-range value during weight update");
lbl-1000:
            // 1 sources

            {
                ++j;
lbl11:
                // 2 sources

                ** while (value > this.m_Boundaries[j])
            }
lbl12:
            // 1 sources

            v0 = j - 1;
            this.m_Weights[v0] = this.m_Weights[v0] + weight;
        }
    }

    protected void updateBoundariesAndWeights() {
        double[] values = new double[this.m_TM.size()];
        double[] weights = new double[this.m_TM.size()];
        Iterator<Map.Entry<Double, Double>> itr = this.m_TM.entrySet().iterator();
        int j = 0;
        while (itr.hasNext()) {
            Map.Entry<Double, Double> entry = itr.next();
            values[j] = entry.getKey();
            weights[j] = entry.getValue();
            ++j;
        }
        double freq = this.m_SumOfWeights / (double)this.m_NumBins;
        double[] cutPoints = new double[this.m_NumBins - 1];
        double[] binWeights = new double[this.m_NumBins];
        double sumOfWeights = this.m_SumOfWeights;
        double weightSumSoFar = 0.0;
        double lastWeightSum = 0.0;
        int cpindex = 0;
        int lastIndex = -1;
        int i = 0;
        while (i < values.length - 1) {
            weightSumSoFar += weights[i];
            sumOfWeights -= weights[i];
            if (weightSumSoFar >= freq) {
                if (freq - lastWeightSum < weightSumSoFar - freq && lastIndex != -1) {
                    cutPoints[cpindex] = (values[lastIndex] + values[lastIndex + 1]) / 2.0;
                    binWeights[cpindex] = lastWeightSum;
                    lastWeightSum = weightSumSoFar -= lastWeightSum;
                    lastIndex = i;
                } else {
                    cutPoints[cpindex] = (values[i] + values[i + 1]) / 2.0;
                    binWeights[cpindex] = weightSumSoFar;
                    weightSumSoFar = 0.0;
                    lastWeightSum = 0.0;
                    lastIndex = -1;
                }
                freq = (sumOfWeights + weightSumSoFar) / (double)(cutPoints.length + 1 - ++cpindex);
            } else {
                lastIndex = i;
                lastWeightSum = weightSumSoFar;
            }
            ++i;
        }
        if (cpindex < cutPoints.length && lastIndex != -1) {
            cutPoints[cpindex] = (values[lastIndex] + values[lastIndex + 1]) / 2.0;
            binWeights[cpindex] = lastWeightSum;
            binWeights[++cpindex] = weightSumSoFar - lastWeightSum;
        } else {
            binWeights[cpindex] = weightSumSoFar;
        }
        if (cpindex == 0) {
            this.m_Boundaries = null;
            this.m_Weights = null;
        } else {
            int n = cpindex;
            binWeights[n] = binWeights[n] + weights[values.length - 1];
            this.m_Boundaries = new double[cpindex + 2];
            this.m_Boundaries[0] = this.m_TM.firstKey();
            this.m_Boundaries[cpindex + 1] = this.m_TM.lastKey();
            System.arraycopy(cutPoints, 0, this.m_Boundaries, 1, cpindex);
            this.m_Weights = new double[cpindex + 1];
            System.arraycopy(binWeights, 0, this.m_Weights, 0, cpindex + 1);
        }
    }

    @Override
    public double[][] predictIntervals(double conf) {
        this.updateBoundariesAndOrWeights();
        double val = Statistics.normalInverse(1.0 - (1.0 - conf) / 2.0);
        double min = this.m_TM.firstKey() - val * this.m_Width;
        double max = this.m_TM.lastKey() + val * this.m_Width;
        double delta = (max - min) / (double)this.m_NumIntervals;
        double[] probabilities = new double[this.m_NumIntervals];
        double leftVal = Math.exp(this.logDensity(min));
        int i = 0;
        while (i < this.m_NumIntervals) {
            double rightVal = Math.exp(this.logDensity(min + (double)(i + 1) * delta));
            probabilities[i] = 0.5 * (leftVal + rightVal) * delta;
            leftVal = rightVal;
            ++i;
        }
        int[] sortedIndices = Utils.sort(probabilities);
        double sum = 0.0;
        boolean[] toUse = new boolean[probabilities.length];
        int k = 0;
        while (sum < conf && k < toUse.length) {
            toUse[sortedIndices[toUse.length - (k + 1)]] = true;
            sum += probabilities[sortedIndices[toUse.length - (k + 1)]];
            ++k;
        }
        probabilities = null;
        ArrayList<double[]> intervals = new ArrayList<double[]>();
        double[] interval = null;
        boolean haveStartedInterval = false;
        int i2 = 0;
        while (i2 < this.m_NumIntervals) {
            if (toUse[i2]) {
                if (!haveStartedInterval) {
                    haveStartedInterval = true;
                    interval = new double[]{min + (double)i2 * delta, min + (double)(i2 + 1) * delta};
                }
            } else if (haveStartedInterval) {
                haveStartedInterval = false;
                intervals.add(interval);
            }
            ++i2;
        }
        if (haveStartedInterval) {
            intervals.add(interval);
        }
        return (double[][])intervals.toArray((T[])new double[0][0]);
    }

    @Override
    public double predictQuantile(double percentage) {
        this.updateBoundariesAndOrWeights();
        double val = Statistics.normalInverse(0.975);
        double min = this.m_TM.firstKey() - val * this.m_Width;
        double max = this.m_TM.lastKey() + val * this.m_Width;
        double delta = (max - min) / (double)this.m_NumIntervals;
        double sum = 0.0;
        double leftVal = Math.exp(this.logDensity(min));
        int i = 0;
        while (i < this.m_NumIntervals) {
            if (sum >= percentage) {
                return min + (double)i * delta;
            }
            double rightVal = Math.exp(this.logDensity(min + (double)(i + 1) * delta));
            sum += 0.5 * (leftVal + rightVal) * delta;
            leftVal = rightVal;
            ++i;
        }
        return max;
    }

    @Override
    public double logDensity(double value) {
        this.updateBoundariesAndOrWeights();
        if (this.m_Boundaries == null) {
            return Math.log(Double.MIN_VALUE);
        }
        int index = Arrays.binarySearch(this.m_Boundaries, value);
        if (index == -1 || index == -this.m_Boundaries.length - 1) {
            double val = 0.0;
            val = index == -1 ? this.m_TM.firstKey() - value : value - this.m_TM.lastKey();
            return CONST - Math.log(this.m_Width) - 0.5 * (val * val / (this.m_Width * this.m_Width)) - Math.log(this.m_SumOfWeights + 2.0);
        }
        if (index == this.m_Boundaries.length - 1) {
            --index;
        } else if (index < 0) {
            index = -index - 2;
        }
        double width = this.m_Boundaries[index + 1] - this.m_Boundaries[index];
        double densSmearedOut = 1.0 / ((this.m_SumOfWeights + 2.0) * (this.m_Boundaries[this.m_Boundaries.length - 1] - this.m_Boundaries[0]));
        if (this.m_Weights[index] <= 0.0) {
            return Math.log(densSmearedOut);
        }
        return Math.log(densSmearedOut + this.m_Weights[index] / ((this.m_SumOfWeights + 2.0) * width));
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append("EqualFrequencyHistogram estimator\n\nBandwidth for out of range cases " + this.m_Width + ", total weight " + this.m_SumOfWeights);
        if (this.m_Boundaries != null) {
            text.append("\nLeft boundary\tRight boundary\tWeight\n");
            int i = 0;
            while (i < this.m_Boundaries.length - 1) {
                text.append(String.valueOf(this.m_Boundaries[i]) + "\t" + this.m_Boundaries[i + 1] + "\t" + this.m_Weights[i] + "\t" + Math.exp(this.logDensity((this.m_Boundaries[i + 1] + this.m_Boundaries[i]) / 2.0)) + "\n");
                ++i;
            }
        }
        return text.toString();
    }

    public static void main(String[] args) {
        Random r = new Random();
        UnivariateEqualFrequencyHistogramEstimator e = new UnivariateEqualFrequencyHistogramEstimator();
        System.out.println(e);
        double sum = 0.0;
        int i = 0;
        while (i < 1000) {
            sum += Math.exp(e.logDensity(r.nextDouble() * 10.0 - 5.0));
            ++i;
        }
        System.out.println("Approximate integral: " + 10.0 * sum / 1000.0);
        i = 0;
        while (i < 1000) {
            e.addValue(0.1 * r.nextGaussian() - 3.0, 1.0);
            e.addValue(r.nextGaussian() * 0.25, 3.0);
            ++i;
        }
        sum = 0.0;
        int points = 10000000;
        int i2 = 0;
        while (i2 < points) {
            double value = r.nextDouble() * 20.0 - 10.0;
            sum += Math.exp(e.logDensity(value));
            ++i2;
        }
        System.out.println(e);
        System.out.println("Approximate integral: " + 20.0 * sum / (double)points);
        double[][] Intervals = e.predictIntervals(0.9);
        System.out.println("Printing histogram intervals ---------------------");
        double[][] dArray = Intervals;
        int n = Intervals.length;
        int n2 = 0;
        while (n2 < n) {
            double[] interval = dArray[n2];
            System.out.println("Left: " + interval[0] + "\t Right: " + interval[1]);
            ++n2;
        }
        System.out.println("Finished histogram printing intervals ---------------------");
        double Covered = 0.0;
        int i3 = 0;
        while (i3 < 1000) {
            double val = -1.0;
            val = r.nextDouble() < 0.25 ? 0.1 * r.nextGaussian() - 3.0 : r.nextGaussian() * 0.25;
            double[][] dArray2 = Intervals;
            int n3 = Intervals.length;
            int n4 = 0;
            while (n4 < n3) {
                double[] interval = dArray2[n4];
                if (val >= interval[0] && val <= interval[1]) {
                    Covered += 1.0;
                    break;
                }
                ++n4;
            }
            ++i3;
        }
        System.out.println("Coverage at 0.9 level for histogram intervals: " + Covered / 1000.0);
        int j = 1;
        while (j < 5) {
            double[] normalInterval;
            double[] histogramInterval;
            int n5;
            int n6;
            double[][] dArray3;
            double val;
            double numTrain = Math.pow(10.0, j);
            System.out.println("Number of training cases: " + numTrain);
            UnivariateEqualFrequencyHistogramEstimator eHistogram = new UnivariateEqualFrequencyHistogramEstimator();
            UnivariateNormalEstimator eNormal = new UnivariateNormalEstimator();
            int i4 = 0;
            while ((double)i4 < numTrain) {
                double val2 = r.nextGaussian() * 1.5 + 0.5;
                eHistogram.addValue(val2, 1.0);
                eNormal.addValue(val2, 1.0);
                ++i4;
            }
            sum = 0.0;
            points = 10000000;
            i4 = 0;
            while (i4 < points) {
                double value = r.nextDouble() * 20.0 - 10.0;
                sum += Math.exp(eHistogram.logDensity(value));
                ++i4;
            }
            System.out.println(eHistogram);
            System.out.println("Approximate integral for histogram estimator: " + 20.0 * sum / (double)points);
            double loglikelihoodHistogram = 0.0;
            double loglikelihoodNormal = 0.0;
            int i5 = 0;
            while (i5 < 1000) {
                double val3 = r.nextGaussian() * 1.5 + 0.5;
                loglikelihoodHistogram += eHistogram.logDensity(val3);
                loglikelihoodNormal += eNormal.logDensity(val3);
                ++i5;
            }
            System.out.println("Loglikelihood for histogram estimator: " + loglikelihoodHistogram / 1000.0);
            System.out.println("Loglikelihood for normal estimator: " + loglikelihoodNormal / 1000.0);
            double[][] histogramIntervals = eHistogram.predictIntervals(0.95);
            double[][] normalIntervals = eNormal.predictIntervals(0.95);
            System.out.println("Printing histogram intervals ---------------------");
            double[][] dArray4 = histogramIntervals;
            int n7 = histogramIntervals.length;
            int n8 = 0;
            while (n8 < n7) {
                double[] histogramInterval2 = dArray4[n8];
                System.out.println("Left: " + histogramInterval2[0] + "\t Right: " + histogramInterval2[1]);
                ++n8;
            }
            System.out.println("Finished histogram printing intervals ---------------------");
            System.out.println("Printing normal intervals ---------------------");
            dArray4 = normalIntervals;
            n7 = normalIntervals.length;
            n8 = 0;
            while (n8 < n7) {
                double[] normalInterval2 = dArray4[n8];
                System.out.println("Left: " + normalInterval2[0] + "\t Right: " + normalInterval2[1]);
                ++n8;
            }
            System.out.println("Finished normal printing intervals ---------------------");
            double histogramCovered = 0.0;
            double normalCovered = 0.0;
            int i6 = 0;
            while (i6 < 1000) {
                val = r.nextGaussian() * 1.5 + 0.5;
                dArray3 = histogramIntervals;
                n6 = histogramIntervals.length;
                n5 = 0;
                while (n5 < n6) {
                    histogramInterval = dArray3[n5];
                    if (val >= histogramInterval[0] && val <= histogramInterval[1]) {
                        histogramCovered += 1.0;
                        break;
                    }
                    ++n5;
                }
                dArray3 = normalIntervals;
                n6 = normalIntervals.length;
                n5 = 0;
                while (n5 < n6) {
                    normalInterval = dArray3[n5];
                    if (val >= normalInterval[0] && val <= normalInterval[1]) {
                        normalCovered += 1.0;
                        break;
                    }
                    ++n5;
                }
                ++i6;
            }
            System.out.println("Coverage at 0.95 level for histogram intervals: " + histogramCovered / 1000.0);
            System.out.println("Coverage at 0.95 level for normal intervals: " + normalCovered / 1000.0);
            histogramIntervals = eHistogram.predictIntervals(0.8);
            normalIntervals = eNormal.predictIntervals(0.8);
            histogramCovered = 0.0;
            normalCovered = 0.0;
            i6 = 0;
            while (i6 < 1000) {
                val = r.nextGaussian() * 1.5 + 0.5;
                dArray3 = histogramIntervals;
                n6 = histogramIntervals.length;
                n5 = 0;
                while (n5 < n6) {
                    histogramInterval = dArray3[n5];
                    if (val >= histogramInterval[0] && val <= histogramInterval[1]) {
                        histogramCovered += 1.0;
                        break;
                    }
                    ++n5;
                }
                dArray3 = normalIntervals;
                n6 = normalIntervals.length;
                n5 = 0;
                while (n5 < n6) {
                    normalInterval = dArray3[n5];
                    if (val >= normalInterval[0] && val <= normalInterval[1]) {
                        normalCovered += 1.0;
                        break;
                    }
                    ++n5;
                }
                ++i6;
            }
            System.out.println("Coverage at 0.8 level for histogram intervals: " + histogramCovered / 1000.0);
            System.out.println("Coverage at 0.8 level for normal intervals: " + normalCovered / 1000.0);
            ++j;
        }
    }
}

