/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.Version;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixPlainText;

public class ResultMatrixGnuPlot
extends ResultMatrix {
    private static final long serialVersionUID = -234648254944790097L;

    public ResultMatrixGnuPlot() {
        this(1, 1);
    }

    public ResultMatrixGnuPlot(int cols, int rows) {
        super(cols, rows);
    }

    public ResultMatrixGnuPlot(ResultMatrix matrix) {
        super(matrix);
    }

    @Override
    public String globalInfo() {
        return "Generates output for a data and script file for GnuPlot.";
    }

    @Override
    public String getDisplayName() {
        return "GNUPlot";
    }

    @Override
    public void clear() {
        super.clear();
        this.LEFT_PARENTHESES = "";
        this.RIGHT_PARENTHESES = "";
    }

    @Override
    public int getDefaultRowNameWidth() {
        return 50;
    }

    @Override
    public int getDefaultColNameWidth() {
        return 50;
    }

    @Override
    public boolean getDefaultEnumerateColNames() {
        return false;
    }

    @Override
    public boolean getDefaultEnumerateRowNames() {
        return false;
    }

    @Override
    public String toStringHeader() {
        return new ResultMatrixPlainText(this).toStringHeader();
    }

    @Override
    public String toStringMatrix() {
        int n;
        StringBuffer result = new StringBuffer();
        String[][] cells = this.toArray();
        String generated = "# generated by WEKA " + Version.VERSION + "\n";
        result.append("\n");
        result.append("##################\n");
        result.append("# file: plot.dat #\n");
        result.append("##################\n");
        result.append(generated);
        result.append("# contains the data for the plot\n");
        result.append("\n");
        result.append("# key for the x-axis\n");
        int i = 1;
        while (i < cells.length - 1) {
            result.append("# " + i + " - " + cells[i][0] + "\n");
            ++i;
        }
        result.append("\n");
        result.append("# data for the plot\n");
        i = 1;
        while (i < cells.length - 1) {
            result.append(Integer.toString(i));
            n = 1;
            while (n < cells[i].length) {
                if (!this.isSignificance(n)) {
                    result.append(" ");
                    result.append(Utils.quote(cells[i][n]));
                }
                ++n;
            }
            result.append("\n");
            ++i;
        }
        result.append("#######\n");
        result.append("# end #\n");
        result.append("#######\n");
        result.append("\n");
        result.append("##################\n");
        result.append("# file: plot.scr #\n");
        result.append("##################\n");
        result.append(generated);
        result.append("# script to plot the data\n");
        result.append("\n");
        result.append("# display it in a window:\n");
        result.append("set terminal x11\n");
        result.append("set output\n");
        result.append("\n");
        result.append("# to display all data rows:\n");
        result.append("set xrange [0:" + (cells.length - 2 + 1) + "]\n");
        result.append("\n");
        result.append("# axis labels, e.g.:\n");
        result.append("#set xlabel \"Datasets\"\n");
        result.append("#set ylabel \"Accuracy in %\"\n");
        result.append("\n");
        result.append("# the plot commands\n");
        n = 1;
        i = 0;
        while (i < cells[0].length - 1) {
            if (this.isSignificance(++i)) continue;
            String line = i == 1 ? "plot" : "replot";
            line = String.valueOf(line) + " \"plot.dat\"";
            String title = "title \"" + cells[0][i] + "\"";
            line = String.valueOf(line) + " using 1:" + ++n;
            if (this.getShowStdDev()) {
                ++i;
                line = String.valueOf(line) + ":" + ++n;
            }
            line = String.valueOf(line) + " with";
            line = this.getShowStdDev() ? String.valueOf(line) + " yerrorbars" : String.valueOf(line) + " lines";
            line = String.valueOf(line) + " " + title;
            result.append(String.valueOf(line) + "\n");
        }
        result.append("\n");
        result.append("# generate ps:\n");
        result.append("#set terminal postscript\n");
        result.append("#set output \"plot.ps\"\n");
        result.append("#replot\n");
        result.append("\n");
        result.append("# generate png:\n");
        result.append("#set terminal png size 800,600\n");
        result.append("#set output \"plot.png\"\n");
        result.append("#replot\n");
        result.append("\n");
        result.append("# wait for user to hit <Return>\n");
        result.append("pause -1\n");
        result.append("#######\n");
        result.append("# end #\n");
        result.append("#######\n");
        return result.toString();
    }

    @Override
    public String toStringKey() {
        return new ResultMatrixPlainText(this).toStringKey();
    }

    @Override
    public String toStringSummary() {
        return new ResultMatrixPlainText(this).toStringSummary();
    }

    @Override
    public String toStringRanking() {
        return new ResultMatrixPlainText(this).toStringRanking();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        ResultMatrixGnuPlot matrix = new ResultMatrixGnuPlot(3, 3);
        matrix.addHeader("header1", "value1");
        matrix.addHeader("header2", "value2");
        matrix.addHeader("header2", "value3");
        int i = 0;
        while (i < matrix.getRowCount()) {
            int n = 0;
            while (n < matrix.getColCount()) {
                matrix.setMean(n, i, (i + 1) * n);
                matrix.setStdDev(n, i, (double)(i + 1) * (double)n / 100.0);
                if (i == n) {
                    if (i % 2 == 1) {
                        matrix.setSignificance(n, i, 1);
                    } else {
                        matrix.setSignificance(n, i, 2);
                    }
                }
                ++n;
            }
            ++i;
        }
        System.out.println("\n\n--> " + ((ResultMatrix)matrix).getDisplayName());
        System.out.println("\n1. complete\n");
        System.out.println(String.valueOf(((ResultMatrix)matrix).toStringHeader()) + "\n");
        System.out.println(String.valueOf(((ResultMatrix)matrix).toStringMatrix()) + "\n");
        System.out.println(((ResultMatrix)matrix).toStringKey());
        System.out.println("\n2. complete with std deviations\n");
        matrix.setShowStdDev(true);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n3. cols numbered\n");
        matrix.setPrintColNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n4. second col missing\n");
        matrix.setColHidden(1, true);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n5. last row missing, rows numbered too\n");
        matrix.setRowHidden(2, true);
        matrix.setPrintRowNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n6. mean prec to 3\n");
        matrix.setMeanPrec(3);
        matrix.setPrintRowNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
    }
}

