/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.PrintStream;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import weka.core.Tee;
import weka.core.Utils;
import weka.gui.LookAndFeel;

public class LogWindow
extends JFrame
implements CaretListener,
ChangeListener {
    private static final long serialVersionUID = 5650947361381061112L;
    public static final String STYLE_STDOUT = "stdout";
    public static final String STYLE_STDERR = "stderr";
    public static final Color COLOR_STDOUT = Color.BLACK;
    public static final Color COLOR_STDERR = Color.RED;
    public static final boolean DEBUG = false;
    public boolean m_UseWordwrap = true;
    protected JTextPane m_Output = new JTextPane();
    protected JButton m_ButtonClear = new JButton("Clear");
    protected JButton m_ButtonClose = new JButton("Close");
    protected JLabel m_LabelCurrentSize = new JLabel("currently: 0");
    protected JSpinner m_SpinnerMaxSize = new JSpinner();
    protected JCheckBox m_CheckBoxWordwrap = new JCheckBox("Use wordwrap");
    protected static Tee m_TeeOut = null;
    protected static Tee m_TeeErr = null;

    public LogWindow() {
        super("Weka - Log");
        boolean teeDone;
        this.createFrame();
        StyledDocument doc = this.m_Output.getStyledDocument();
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        style = doc.addStyle(STYLE_STDOUT, style);
        StyleConstants.setFontFamily(style, "monospaced");
        StyleConstants.setForeground(style, COLOR_STDOUT);
        style = StyleContext.getDefaultStyleContext().getStyle("default");
        style = doc.addStyle(STYLE_STDERR, style);
        StyleConstants.setFontFamily(style, "monospaced");
        StyleConstants.setForeground(style, COLOR_STDERR);
        boolean bl = teeDone = m_TeeOut != null || m_TeeErr != null;
        if (!teeDone) {
            m_TeeOut = new Tee(System.out);
            System.setOut(m_TeeOut);
        }
        m_TeeOut.add(new LogWindowPrintStream(this, m_TeeOut.getDefault(), STYLE_STDOUT));
        if (!teeDone) {
            m_TeeErr = new Tee(System.err);
            System.setErr(m_TeeErr);
        }
        m_TeeErr.add(new LogWindowPrintStream(this, m_TeeErr.getDefault(), STYLE_STDERR));
    }

    protected void createFrame() {
        this.setSize(600, 400);
        int width = this.getBounds().width;
        this.setLocation(this.getGraphicsConfiguration().getBounds().width - width, this.getLocation().y);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(this.m_Output), "Center");
        this.setWordwrap(this.m_UseWordwrap);
        JPanel panel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)panel, "South");
        JPanel panel3 = new JPanel(new BorderLayout());
        panel.add((Component)panel3, "South");
        JPanel panel2 = new JPanel(new FlowLayout(2));
        panel3.add((Component)panel2, "East");
        this.m_ButtonClear.setMnemonic('C');
        this.m_ButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogWindow.this.clear();
            }
        });
        panel2.add(this.m_ButtonClear);
        this.m_ButtonClose.setMnemonic('l');
        this.m_ButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogWindow.this.close();
            }
        });
        panel2.add(this.m_ButtonClose);
        panel2 = new JPanel(new GridLayout(1, 3));
        panel3.add((Component)panel2, "West");
        JPanel panel4 = new JPanel(new FlowLayout());
        panel2.add(panel4);
        SpinnerNumberModel model = (SpinnerNumberModel)this.m_SpinnerMaxSize.getModel();
        model.setMinimum(new Integer(1));
        model.setStepSize(new Integer(1000));
        model.setValue(new Integer(100000));
        model.addChangeListener(this);
        JLabel label = new JLabel("max. Size");
        label.setDisplayedMnemonic('m');
        label.setLabelFor(this.m_SpinnerMaxSize);
        panel4.add(label);
        panel4.add(this.m_SpinnerMaxSize);
        panel4 = new JPanel(new FlowLayout());
        panel2.add(panel4);
        panel4.add(this.m_LabelCurrentSize);
        panel4 = new JPanel(new FlowLayout());
        panel2.add(panel4);
        this.m_CheckBoxWordwrap.setSelected(this.m_UseWordwrap);
        this.m_CheckBoxWordwrap.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LogWindow.this.setWordwrap(LogWindow.this.m_CheckBoxWordwrap.isSelected());
            }
        });
        panel4.add(this.m_CheckBoxWordwrap);
    }

    public void clear() {
        this.m_Output.setText("");
    }

    public void close() {
        this.setVisible(false);
    }

    public void trim() {
        int maxSize;
        StyledDocument doc = this.m_Output.getStyledDocument();
        int size = doc.getLength();
        if (size > (maxSize = ((Integer)this.m_SpinnerMaxSize.getValue()).intValue())) {
            try {
                int pos = size - maxSize;
                while (!doc.getText(pos, 1).equals("\n")) {
                    ++pos;
                }
                while (doc.getText(pos, 1).equals("\n")) {
                    ++pos;
                }
                doc.remove(0, pos);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_Output.setCaretPosition(doc.getLength());
    }

    protected String colorToString(Color c) {
        String result = "#" + Utils.padLeft(Integer.toHexString(c.getRed()), 2) + Utils.padLeft(Integer.toHexString(c.getGreen()), 2) + Utils.padLeft(Integer.toHexString(c.getBlue()), 2);
        result = result.replaceAll("\\ ", "0").toUpperCase();
        return result;
    }

    public void setWordwrap(boolean wrap) {
        this.m_UseWordwrap = wrap;
        if (this.m_CheckBoxWordwrap.isSelected() != this.m_UseWordwrap) {
            this.m_CheckBoxWordwrap.setSelected(this.m_UseWordwrap);
        }
        Container parent = this.m_Output.getParent();
        JTextPane outputOld = this.m_Output;
        this.m_Output = this.m_UseWordwrap ? new JTextPane() : new JTextPane(){
            private static final long serialVersionUID = -8275856175921425981L;

            @Override
            public void setSize(Dimension d) {
                if (d.width < this.getGraphicsConfiguration().getBounds().width) {
                    d.width = this.getGraphicsConfiguration().getBounds().width;
                }
                super.setSize(d);
            }

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return false;
            }
        };
        this.m_Output.setEditable(false);
        this.m_Output.addCaretListener(this);
        this.m_Output.setDocument(outputOld.getDocument());
        this.m_Output.setCaretPosition(this.m_Output.getDocument().getLength());
        parent.add(this.m_Output);
        parent.remove(outputOld);
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.m_LabelCurrentSize.setText("currently: " + this.m_Output.getStyledDocument().getLength());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.m_SpinnerMaxSize.getModel()) {
            this.trim();
            this.validate();
            this.caretUpdate(null);
        }
    }

    public static void main(String[] args) {
        LookAndFeel.setLookAndFeel();
        LogWindow log = new LogWindow();
        log.setVisible(true);
        log.setDefaultCloseOperation(2);
        System.out.print("a");
        System.err.print("a");
        System.out.print("a");
        System.out.println();
        System.err.println(new Date());
    }

    protected class LogWindowPrintStream
    extends PrintStream {
        protected LogWindow m_Parent;
        protected String m_Style;

        public LogWindowPrintStream(LogWindow parent, PrintStream stream, String style) {
            super(stream);
            this.m_Parent = null;
            this.m_Style = null;
            this.m_Parent = parent;
            this.m_Style = style;
        }

        @Override
        public synchronized void flush() {
        }

        @Override
        public synchronized void print(int x) {
            this.print(new Integer(x).toString());
        }

        @Override
        public synchronized void print(boolean x) {
            this.print(new Boolean(x).toString());
        }

        @Override
        public synchronized void print(String x) {
            StyledDocument doc = this.m_Parent.m_Output.getStyledDocument();
            try {
                doc.insertString(doc.getLength(), x, doc.getStyle(this.m_Style));
                this.m_Parent.m_Output.setCaretPosition(doc.getLength());
                this.m_Parent.trim();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public synchronized void print(Object x) {
            if (x instanceof Throwable) {
                Throwable t = (Throwable)x;
                StackTraceElement[] trace = t.getStackTrace();
                String line = String.valueOf(t.getMessage()) + "\n";
                int i = 0;
                while (i < trace.length) {
                    line = String.valueOf(line) + "\t" + trace[i].toString() + "\n";
                    ++i;
                }
                x = line;
            }
            if (x == null) {
                this.print("null");
            } else {
                this.print(x.toString());
            }
        }

        @Override
        public synchronized void println() {
            this.print("\n");
        }

        @Override
        public synchronized void println(int x) {
            this.print(x);
            this.println();
        }

        @Override
        public synchronized void println(boolean x) {
            this.print(x);
            this.println();
        }

        @Override
        public synchronized void println(String x) {
            this.print(x);
            this.println();
        }

        @Override
        public synchronized void println(Object x) {
            this.print(x);
            this.println();
        }
    }
}

