/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.boundaryvisualizer;

import java.io.Serializable;
import java.util.Random;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.boundaryvisualizer.DataGenerator;

public class KDDataGenerator
implements DataGenerator,
Serializable {
    private static final long serialVersionUID = -958573275606402792L;
    private Instances m_instances;
    private double[] m_globalMeansOrModes;
    private final double m_laplaceConst = 1.0;
    private int m_seed = 1;
    private Random m_random;
    private boolean[] m_weightingDimensions;
    private double[] m_weightingValues;
    private static double m_normConst = Math.sqrt(Math.PI * 2);
    private int m_kernelBandwidth = 3;
    private double[][] m_kernelParams;
    protected double[] m_Min;
    protected double[] m_Max;

    @Override
    public void buildGenerator(Instances inputInstances) throws Exception {
        this.m_random = new Random(this.m_seed);
        this.m_instances = inputInstances;
        this.m_globalMeansOrModes = new double[this.m_instances.numAttributes()];
        if (this.m_weightingDimensions == null) {
            this.m_weightingDimensions = new boolean[this.m_instances.numAttributes()];
        }
        int i = 0;
        while (i < this.m_instances.numAttributes()) {
            if (i != this.m_instances.classIndex()) {
                this.m_globalMeansOrModes[i] = this.m_instances.meanOrMode(i);
            }
            ++i;
        }
        this.m_kernelParams = new double[this.m_instances.numInstances()][this.m_instances.numAttributes()];
        this.computeParams();
    }

    @Override
    public double[] getWeights() {
        double[] weights = new double[this.m_instances.numInstances()];
        int k = 0;
        while (k < this.m_instances.numInstances()) {
            double weight = 1.0;
            int i = 0;
            while (i < this.m_instances.numAttributes()) {
                if (this.m_weightingDimensions[i]) {
                    double mean = 0.0;
                    mean = !this.m_instances.instance(k).isMissing(i) ? this.m_instances.instance(k).value(i) : this.m_globalMeansOrModes[i];
                    double wm = 1.0;
                    wm = this.normalDens(this.m_weightingValues[i], mean, this.m_kernelParams[k][i]);
                    weight *= wm;
                }
                ++i;
            }
            weights[k] = weight;
            ++k;
        }
        return weights;
    }

    private double[] computeCumulativeDistribution(double[] dist) {
        double[] cumDist = new double[dist.length];
        double sum = 0.0;
        int i = 0;
        while (i < dist.length) {
            cumDist[i] = sum += dist[i];
            ++i;
        }
        return cumDist;
    }

    @Override
    public double[][] generateInstances(int[] indices) throws Exception {
        double[][] values = new double[this.m_instances.numInstances()][];
        int k = 0;
        while (k < indices.length) {
            values[indices[k]] = new double[this.m_instances.numAttributes()];
            int i = 0;
            while (i < this.m_instances.numAttributes()) {
                if (!this.m_weightingDimensions[i] && i != this.m_instances.classIndex()) {
                    if (this.m_instances.attribute(i).isNumeric()) {
                        double mean = 0.0;
                        double val = this.m_random.nextGaussian();
                        mean = !this.m_instances.instance(indices[k]).isMissing(i) ? this.m_instances.instance(indices[k]).value(i) : this.m_globalMeansOrModes[i];
                        val *= this.m_kernelParams[indices[k]][i];
                        values[indices[k]][i] = val += mean;
                    } else {
                        double[] dist = new double[this.m_instances.attribute(i).numValues()];
                        int j = 0;
                        while (j < dist.length) {
                            dist[j] = 1.0;
                            ++j;
                        }
                        if (!this.m_instances.instance(indices[k]).isMissing(i)) {
                            int n = (int)this.m_instances.instance(indices[k]).value(i);
                            dist[n] = dist[n] + 1.0;
                        } else {
                            int n = (int)this.m_globalMeansOrModes[i];
                            dist[n] = dist[n] + 1.0;
                        }
                        Utils.normalize(dist);
                        double[] cumDist = this.computeCumulativeDistribution(dist);
                        double randomVal = this.m_random.nextDouble();
                        int instVal = 0;
                        int j2 = 0;
                        while (j2 < cumDist.length) {
                            if (randomVal <= cumDist[j2]) {
                                instVal = j2;
                                break;
                            }
                            ++j2;
                        }
                        values[indices[k]][i] = instVal;
                    }
                }
                ++i;
            }
            ++k;
        }
        return values;
    }

    private double normalDens(double x, double mean, double stdDev) {
        double diff = x - mean;
        return 1.0 / (m_normConst * stdDev) * Math.exp(-(diff * diff / (2.0 * stdDev * stdDev)));
    }

    @Override
    public void setWeightingDimensions(boolean[] dims) {
        this.m_weightingDimensions = dims;
    }

    @Override
    public void setWeightingValues(double[] vals) {
        this.m_weightingValues = vals;
    }

    @Override
    public int getNumGeneratingModels() {
        if (this.m_instances != null) {
            return this.m_instances.numInstances();
        }
        return 0;
    }

    public void setKernelBandwidth(int kb) {
        this.m_kernelBandwidth = kb;
    }

    public int getKernelBandwidth() {
        return this.m_kernelBandwidth;
    }

    @Override
    public void setSeed(int seed) {
        this.m_seed = seed;
        this.m_random = new Random(this.m_seed);
    }

    private double distance(Instance first, Instance second) {
        double distance = 0.0;
        int i = 0;
        while (i < this.m_instances.numAttributes()) {
            if (i != this.m_instances.classIndex()) {
                double diff;
                double firstVal = this.m_globalMeansOrModes[i];
                double secondVal = this.m_globalMeansOrModes[i];
                switch (this.m_instances.attribute(i).type()) {
                    case 0: {
                        if (!first.isMissing(i)) {
                            firstVal = first.value(i);
                        }
                        if (!second.isMissing(i)) {
                            secondVal = second.value(i);
                        }
                        diff = this.norm(firstVal, i) - this.norm(secondVal, i);
                        break;
                    }
                    default: {
                        diff = 0.0;
                    }
                }
                distance += diff * diff;
            }
            ++i;
        }
        return Math.sqrt(distance);
    }

    private double norm(double x, int i) {
        if (Double.isNaN(this.m_Min[i]) || Utils.eq(this.m_Max[i], this.m_Min[i])) {
            return 0.0;
        }
        return (x - this.m_Min[i]) / (this.m_Max[i] - this.m_Min[i]);
    }

    private void updateMinMax(Instance instance) {
        int j = 0;
        while (j < this.m_instances.numAttributes()) {
            if (!instance.isMissing(j)) {
                if (Double.isNaN(this.m_Min[j])) {
                    this.m_Min[j] = instance.value(j);
                    this.m_Max[j] = instance.value(j);
                } else if (instance.value(j) < this.m_Min[j]) {
                    this.m_Min[j] = instance.value(j);
                } else if (instance.value(j) > this.m_Max[j]) {
                    this.m_Max[j] = instance.value(j);
                }
            }
            ++j;
        }
    }

    private void computeParams() throws Exception {
        this.m_Min = new double[this.m_instances.numAttributes()];
        this.m_Max = new double[this.m_instances.numAttributes()];
        int i = 0;
        while (i < this.m_instances.numAttributes()) {
            this.m_Max[i] = Double.NaN;
            this.m_Min[i] = Double.NaN;
            ++i;
        }
        i = 0;
        while (i < this.m_instances.numInstances()) {
            this.updateMinMax(this.m_instances.instance(i));
            ++i;
        }
        double[] distances = new double[this.m_instances.numInstances()];
        int i2 = 0;
        while (i2 < this.m_instances.numInstances()) {
            int j;
            int k;
            Instance current = this.m_instances.instance(i2);
            int j2 = 0;
            while (j2 < this.m_instances.numInstances()) {
                distances[j2] = this.distance(current, this.m_instances.instance(j2));
                ++j2;
            }
            int[] sorted = Utils.sort(distances);
            double bandwidth = distances[sorted[k = this.m_kernelBandwidth]];
            if (bandwidth <= 0.0) {
                j = k + 1;
                while (j < sorted.length) {
                    if (distances[sorted[j]] > bandwidth) {
                        bandwidth = distances[sorted[j]];
                        break;
                    }
                    ++j;
                }
                if (bandwidth <= 0.0) {
                    throw new Exception("All training instances coincide with test instance!");
                }
            }
            j = 0;
            while (j < this.m_instances.numAttributes()) {
                if (this.m_Max[j] - this.m_Min[j] > 0.0) {
                    this.m_kernelParams[i2][j] = bandwidth * (this.m_Max[j] - this.m_Min[j]);
                }
                ++j;
            }
            ++i2;
        }
    }
}

