/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.scripting;

import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.core.WekaException;
import weka.gui.ExtensionFileFilter;
import weka.gui.scripting.ScriptUtils;
import weka.gui.scripting.event.ScriptExecutionEvent;
import weka.gui.scripting.event.ScriptExecutionListener;

public abstract class Script
implements OptionHandler,
Serializable {
    private static final long serialVersionUID = 5053328052680586401L;
    public static final String BACKUP_EXTENSION = ".bak";
    protected Document m_Document;
    protected File m_Filename;
    protected String m_NewLine;
    protected boolean m_Modified;
    protected transient ScriptThread m_ScriptThread;
    protected HashSet<ScriptExecutionListener> m_FinishedListeners;

    public Script() {
        this(null);
    }

    public Script(Document doc) {
        this(doc, null);
    }

    public Script(Document doc, File file) {
        this.initialize();
        this.m_Document = doc;
        if (this.m_Document != null) {
            this.m_Document.addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    Script.this.m_Modified = true;
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    Script.this.m_Modified = true;
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    Script.this.m_Modified = true;
                }
            });
        }
        if (file != null) {
            this.open(file);
        }
    }

    protected void initialize() {
        this.m_Filename = null;
        this.m_NewLine = System.getProperty("line.separator");
        this.m_Modified = false;
        this.m_ScriptThread = null;
        this.m_FinishedListeners = new HashSet();
    }

    @Override
    public Enumeration<Option> listOptions() {
        return new Vector().elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
    }

    @Override
    public String[] getOptions() {
        return new String[0];
    }

    public abstract ExtensionFileFilter[] getFilters();

    public abstract String getDefaultExtension();

    public File getFilename() {
        return this.m_Filename;
    }

    public String getNewLine() {
        return this.m_NewLine;
    }

    public boolean isModified() {
        return this.m_Modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContent() {
        String result;
        if (this.m_Document == null) {
            return "";
        }
        try {
            Document document = this.m_Document;
            synchronized (document) {
                result = this.m_Document.getText(0, this.m_Document.getLength());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public void setContent(String value) {
        if (this.m_Document == null) {
            return;
        }
        try {
            this.m_Document.insertString(0, value, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean checkExtension(File file) {
        boolean result = false;
        ExtensionFileFilter[] filters = this.getFilters();
        int i = 0;
        while (i < filters.length) {
            String[] exts = filters[i].getExtensions();
            int n = 0;
            while (n < exts.length) {
                if (file.getName().endsWith(exts[n])) {
                    result = true;
                    break;
                }
                ++n;
            }
            if (result) break;
            ++i;
        }
        return result;
    }

    public void empty() {
        if (this.m_Document != null) {
            try {
                this.m_Document.remove(0, this.m_Document.getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_Modified = false;
        this.m_Filename = null;
    }

    public boolean open(File file) {
        boolean result;
        if (this.m_Document == null) {
            return true;
        }
        if (!this.checkExtension(file)) {
            System.err.println("Extension of file '" + file + "' is unknown!");
        }
        try {
            this.m_Document.remove(0, this.m_Document.getLength());
            String content = ScriptUtils.load(file);
            if (content == null) {
                throw new WekaException("Error reading content of file '" + file + "'!");
            }
            this.m_Document.insertString(0, content, null);
            this.m_Modified = false;
            this.m_Filename = file;
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.m_Document.remove(0, this.m_Document.getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = false;
            this.m_Filename = null;
        }
        return result;
    }

    public boolean save() {
        if (this.m_Filename == null) {
            return false;
        }
        return this.saveAs(this.m_Filename);
    }

    public boolean saveAs(File file) {
        boolean result;
        if (this.m_Document == null) {
            return true;
        }
        if (!this.checkExtension(file)) {
            file = new File(String.valueOf(file.getPath()) + this.getDefaultExtension());
        }
        if (file.exists()) {
            File backupFile = new File(String.valueOf(file.getPath()) + BACKUP_EXTENSION);
            try {
                ScriptUtils.copy(file, backupFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            result = ScriptUtils.save(file, this.m_Document.getText(0, this.m_Document.getLength()));
            this.m_Filename = file;
            this.m_Modified = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    protected abstract boolean canExecuteScripts();

    public abstract ScriptThread newThread(String[] var1);

    protected void preCheck(String[] args) throws Exception {
        if (this.m_ScriptThread != null) {
            throw new Exception("A script is currently running!");
        }
        if (this.m_Modified) {
            throw new Exception("The Script has been modified!");
        }
        if (this.m_Filename == null) {
            throw new Exception("The Script contains no content?");
        }
    }

    protected void execute(String[] args) {
        this.m_ScriptThread = this.newThread(args);
        try {
            this.m_ScriptThread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void start(String[] args) throws Exception {
        if (args == null) {
            args = new String[]{};
        }
        this.preCheck(args);
        this.execute(args);
    }

    public void stop() {
        if (this.isRunning()) {
            this.m_ScriptThread.stopScript();
            this.m_ScriptThread = null;
            this.notifyScriptFinishedListeners(new ScriptExecutionEvent(this, ScriptExecutionEvent.Type.STOPPED));
        }
    }

    public void run(File file, String[] args) {
        try {
            Script script = (Script)new SerializedObject(this).getObject();
            script.m_Filename = file;
            script.m_Modified = false;
            script.start(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isRunning() {
        return this.m_ScriptThread != null;
    }

    public void addScriptFinishedListener(ScriptExecutionListener l) {
        this.m_FinishedListeners.add(l);
    }

    public void removeScriptFinishedListener(ScriptExecutionListener l) {
        this.m_FinishedListeners.remove(l);
    }

    protected void notifyScriptFinishedListeners(ScriptExecutionEvent e) {
        Iterator<ScriptExecutionListener> iter = this.m_FinishedListeners.iterator();
        while (iter.hasNext()) {
            iter.next().scriptFinished(e);
        }
    }

    public String toString() {
        String result;
        try {
            result = this.m_Document == null ? "" : this.m_Document.getText(0, this.m_Document.getLength());
        }
        catch (Exception e) {
            result = "";
        }
        return result.toString();
    }

    protected static String makeOptionString(Script script) {
        StringBuffer result = new StringBuffer("");
        result.append("\nHelp requested:\n\n");
        result.append("-h or -help\n");
        result.append("\tDisplays this help screen.\n");
        result.append("-s <file>\n");
        result.append("\tThe script to execute.\n");
        Enumeration<Option> enm = script.listOptions();
        while (enm.hasMoreElements()) {
            Option option = enm.nextElement();
            result.append(String.valueOf(option.synopsis()) + '\n');
            result.append(String.valueOf(option.description()) + "\n");
        }
        result.append("\n");
        result.append("Any additional options are passed on to the script as\n");
        result.append("command-line parameters.\n");
        result.append("\n");
        return result.toString();
    }

    public static void runScript(Script script, String[] args) throws Exception {
        if (Utils.getFlag('h', args) || Utils.getFlag("help", args)) {
            System.out.println(Script.makeOptionString(script));
        } else {
            String tmpStr = Utils.getOption('s', args);
            if (tmpStr.length() == 0) {
                throw new WekaException("No script supplied!");
            }
            File scriptFile = new File(tmpStr);
            script.setOptions(args);
            Vector<String> options = new Vector<String>();
            int i = 0;
            while (i < args.length) {
                if (args[i].length() > 0) {
                    options.add(args[i]);
                }
                ++i;
            }
            script.run(scriptFile, options.toArray(new String[options.size()]));
        }
    }

    public static abstract class ScriptThread
    extends Thread {
        protected Script m_Owner;
        protected String[] m_Args;
        protected boolean m_Stopped;

        public ScriptThread(Script owner, String[] args) {
            this.m_Owner = owner;
            this.m_Args = (String[])args.clone();
        }

        public Script getOwner() {
            return this.m_Owner;
        }

        public String[] getArgs() {
            return this.m_Args;
        }

        protected abstract void doRun();

        @Override
        public void run() {
            this.m_Stopped = false;
            this.getOwner().notifyScriptFinishedListeners(new ScriptExecutionEvent(this.m_Owner, ScriptExecutionEvent.Type.STARTED));
            try {
                this.doRun();
                if (!this.m_Stopped) {
                    this.getOwner().notifyScriptFinishedListeners(new ScriptExecutionEvent(this.m_Owner, ScriptExecutionEvent.Type.FINISHED));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getOwner().notifyScriptFinishedListeners(new ScriptExecutionEvent(this.m_Owner, ScriptExecutionEvent.Type.ERROR, e));
            }
            this.getOwner().m_ScriptThread = null;
        }

        public void stopScript() {
            if (this.isAlive()) {
                this.m_Stopped = true;
                try {
                    this.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

