/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.StringReader;
import javax.swing.JComponent;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.JComponentWriter;
import weka.gui.visualize.PostscriptGraphics;

public class PostscriptWriter
extends JComponentWriter {
    public PostscriptWriter() {
        super(null);
    }

    public PostscriptWriter(JComponent c) {
        super(c);
    }

    public PostscriptWriter(JComponent c, File f) {
        super(c, f);
    }

    @Override
    public String getDescription() {
        return "Postscript-File";
    }

    @Override
    public String getExtension() {
        return ".eps";
    }

    @Override
    public void generateOutput() throws Exception {
        block12: {
            FilterOutputStream ostrm = null;
            try {
                try {
                    ostrm = new BufferedOutputStream(new FileOutputStream(this.getFile()));
                    PostscriptGraphics psg = new PostscriptGraphics(this.getComponent().getHeight(), this.getComponent().getWidth(), ostrm);
                    psg.setFont(this.getComponent().getFont());
                    psg.scale(this.getXScale(), this.getYScale());
                    this.getComponent().printAll(psg);
                    psg.finished();
                }
                catch (Exception e) {
                    System.err.println(e);
                    if (ostrm == null) break block12;
                    try {
                        ostrm.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (ostrm != null) {
                    try {
                        ostrm.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("building TreeVisualizer...");
        TreeBuild builder = new TreeBuild();
        PlaceNode2 arrange = new PlaceNode2();
        Node top = builder.create(new StringReader("digraph atree { top [label=\"the top\"] a [label=\"the first node\"] b [label=\"the second nodes\"] c [label=\"comes off of first\"] top->a top->b b->c }"));
        TreeVisualizer tv = new TreeVisualizer(null, top, (NodePlace)arrange);
        tv.setSize(800, 600);
        String filename = String.valueOf(System.getProperty("java.io.tmpdir")) + "test.eps";
        System.out.println("outputting to '" + filename + "'...");
        PostscriptWriter.toOutput(new PostscriptWriter(), tv, new File(filename));
        System.out.println("done!");
    }
}

