/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.functions.LinearRegression;
import weka.classifiers.functions.Logistic;
import weka.classifiers.rules.ZeroR;
import weka.clusterers.Clusterer;
import weka.clusterers.DensityBasedClusterer;
import weka.clusterers.MakeDensityBasedClusterer;
import weka.clusterers.SimpleKMeans;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ClusterMembership;
import weka.filters.unsupervised.attribute.Standardize;

public class RBFNetwork
extends AbstractClassifier
implements OptionHandler,
WeightedInstancesHandler {
    static final long serialVersionUID = -3669814959712675720L;
    private Logistic m_logistic;
    private LinearRegression m_linear;
    private ClusterMembership m_basisFilter;
    private Standardize m_standardize;
    private int m_numClusters = 2;
    protected double m_ridge = 1.0E-8;
    private int m_maxIts = -1;
    private int m_clusteringSeed = 1;
    private double m_minStdDev = 0.1;
    private Classifier m_ZeroR;

    public String globalInfo() {
        return "Class that implements a normalized Gaussian radial basisbasis function network.\nIt uses the k-means clustering algorithm to provide the basis functions and learns either a logistic regression (discrete class problems) or linear regression (numeric class problems) on top of that. Symmetric multivariate Gaussians are fit to the data from each cluster. If the class is nominal it uses the given number of clusters per class.It standardizes all numeric attributes to zero mean and unit variance.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Logistic().getCapabilities();
        result.or(new LinearRegression().getCapabilities());
        Capabilities classes = result.getClassCapabilities();
        result.and(new SimpleKMeans().getCapabilities());
        result.or(classes);
        return result;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        if (instances.numAttributes() == 1) {
            System.err.println("Cannot build model (only class attribute present in data!), using ZeroR model instead!");
            this.m_ZeroR = new ZeroR();
            this.m_ZeroR.buildClassifier(instances);
            return;
        }
        this.m_ZeroR = null;
        this.m_standardize = new Standardize();
        this.m_standardize.setInputFormat(instances);
        instances = Filter.useFilter((Instances)instances, (Filter)this.m_standardize);
        SimpleKMeans sk = new SimpleKMeans();
        sk.setNumClusters(this.m_numClusters);
        sk.setSeed(this.m_clusteringSeed);
        MakeDensityBasedClusterer dc = new MakeDensityBasedClusterer();
        dc.setClusterer((Clusterer)sk);
        dc.setMinStdDev(this.m_minStdDev);
        this.m_basisFilter = new ClusterMembership();
        this.m_basisFilter.setDensityBasedClusterer((DensityBasedClusterer)dc);
        this.m_basisFilter.setInputFormat(instances);
        Instances transformed = Filter.useFilter((Instances)instances, (Filter)this.m_basisFilter);
        if (instances.classAttribute().isNominal()) {
            this.m_linear = null;
            this.m_logistic = new Logistic();
            this.m_logistic.setRidge(this.m_ridge);
            this.m_logistic.setMaxIts(this.m_maxIts);
            this.m_logistic.buildClassifier(transformed);
        } else {
            this.m_logistic = null;
            this.m_linear = new LinearRegression();
            this.m_linear.setAttributeSelectionMethod(new SelectedTag(1, LinearRegression.TAGS_SELECTION));
            this.m_linear.setRidge(this.m_ridge);
            this.m_linear.buildClassifier(transformed);
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_ZeroR != null) {
            return this.m_ZeroR.distributionForInstance(instance);
        }
        this.m_standardize.input(instance);
        this.m_basisFilter.input(this.m_standardize.output());
        Instance transformed = this.m_basisFilter.output();
        return instance.classAttribute().isNominal() ? this.m_logistic.distributionForInstance(transformed) : this.m_linear.distributionForInstance(transformed);
    }

    public String toString() {
        if (this.m_ZeroR != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(((Object)((Object)this)).getClass().getName().replaceAll(".*\\.", "") + "\n");
            buf.append(((Object)((Object)this)).getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=") + "\n\n");
            buf.append("Warning: No model could be built, hence ZeroR model is used:\n\n");
            buf.append(this.m_ZeroR.toString());
            return buf.toString();
        }
        if (this.m_basisFilter == null) {
            return "No classifier built yet!";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Radial basis function network\n");
        sb.append(this.m_linear == null ? "(Logistic regression " : "(Linear regression ");
        sb.append("applied to K-means clusters as basis functions):\n\n");
        sb.append(this.m_linear == null ? this.m_logistic.toString() : this.m_linear.toString());
        return sb.toString();
    }

    public String maxItsTipText() {
        return "Maximum number of iterations for the logistic regression to perform. Only applied to discrete class problems.";
    }

    public int getMaxIts() {
        return this.m_maxIts;
    }

    public void setMaxIts(int newMaxIts) {
        this.m_maxIts = newMaxIts;
    }

    public String ridgeTipText() {
        return "Set the Ridge value for the logistic or linear regression.";
    }

    public void setRidge(double ridge) {
        this.m_ridge = ridge;
    }

    public double getRidge() {
        return this.m_ridge;
    }

    public String numClustersTipText() {
        return "The number of clusters for K-Means to generate.";
    }

    public void setNumClusters(int numClusters) {
        if (numClusters > 0) {
            this.m_numClusters = numClusters;
        }
    }

    public int getNumClusters() {
        return this.m_numClusters;
    }

    public String clusteringSeedTipText() {
        return "The random seed to pass on to K-means.";
    }

    public void setClusteringSeed(int seed) {
        this.m_clusteringSeed = seed;
    }

    public int getClusteringSeed() {
        return this.m_clusteringSeed;
    }

    public String minStdDevTipText() {
        return "Sets the minimum standard deviation for the clusters.";
    }

    public double getMinStdDev() {
        return this.m_minStdDev;
    }

    public void setMinStdDev(double newMinStdDev) {
        this.m_minStdDev = newMinStdDev;
    }

    public Enumeration<Option> listOptions() {
        Vector<Object> newVector = new Vector<Object>(5);
        newVector.addElement(new Option("\tSet the number of clusters (basis functions) to generate. (default = 2).", "B", 1, "-B <number>"));
        newVector.addElement(new Option("\tSet the random seed to be used by K-means. (default = 1).", "S", 1, "-S <seed>"));
        newVector.addElement(new Option("\tSet the ridge value for the logistic or linear regression.", "R", 1, "-R <ridge>"));
        newVector.addElement(new Option("\tSet the maximum number of iterations for the logistic regression. (default -1, until convergence).", "M", 1, "-M <number>"));
        newVector.addElement(new Option("\tSet the minimum standard deviation for the clusters. (default 0.1).", "W", 1, "-W <number>"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String stdString;
        String seedString;
        this.setDebug(Utils.getFlag((char)'D', (String[])options));
        String ridgeString = Utils.getOption((char)'R', (String[])options);
        this.m_ridge = ridgeString.length() != 0 ? Double.parseDouble(ridgeString) : 1.0E-8;
        String maxItsString = Utils.getOption((char)'M', (String[])options);
        this.m_maxIts = maxItsString.length() != 0 ? Integer.parseInt(maxItsString) : -1;
        String numClustersString = Utils.getOption((char)'B', (String[])options);
        if (numClustersString.length() != 0) {
            this.setNumClusters(Integer.parseInt(numClustersString));
        }
        if ((seedString = Utils.getOption((char)'S', (String[])options)).length() != 0) {
            this.setClusteringSeed(Integer.parseInt(seedString));
        }
        if ((stdString = Utils.getOption((char)'W', (String[])options)).length() != 0) {
            this.setMinStdDev(Double.parseDouble(stdString));
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-B");
        options.add("" + this.m_numClusters);
        options.add("-S");
        options.add("" + this.m_clusteringSeed);
        options.add("-R");
        options.add("" + this.m_ridge);
        options.add("-M");
        options.add("" + this.m_maxIts);
        options.add("-W");
        options.add("" + this.m_minStdDev);
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10951 $");
    }

    public static void main(String[] argv) {
        RBFNetwork.runClassifier((Classifier)new RBFNetwork(), (String[])argv);
    }
}

