/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Arrays;
import java.util.Random;
import weka.classifiers.Classifier;
import weka.classifiers.functions.RBFModel;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class RBFClassifier
extends RBFModel
implements WeightedInstancesHandler {
    private static final long serialVersionUID = -7847475556438394611L;

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    protected void initializeOutputLayer(Random random) {
        for (int i = 0; i < this.m_numUnits + 1; ++i) {
            for (int j = 0; j < this.m_numClasses; ++j) {
                this.m_RBFParameters[this.OFFSET_WEIGHTS + j * (this.m_numUnits + 1) + i] = 0.1 * random.nextGaussian();
            }
        }
    }

    @Override
    protected double calculateError(double[] outputs, Instance inst) {
        double SE = 0.0;
        for (int i = 0; i < this.m_numClasses; ++i) {
            double target = (int)inst.value(this.m_classIndex) == i ? 0.99 : 0.01;
            double err = this.getOutput(i, outputs, null) - target;
            SE += inst.weight() * err * err;
        }
        return SE;
    }

    @Override
    protected double postprocessError(double error) {
        double squaredSumOfWeights = 0.0;
        for (int k = 0; k < this.m_numUnits; ++k) {
            for (int i = 0; i < this.m_numClasses; ++i) {
                squaredSumOfWeights += this.m_RBFParameters[this.OFFSET_WEIGHTS + i * (this.m_numUnits + 1) + k] * this.m_RBFParameters[this.OFFSET_WEIGHTS + i * (this.m_numUnits + 1) + k];
            }
        }
        return (error + this.m_ridge * squaredSumOfWeights) / this.m_data.sumOfWeights();
    }

    @Override
    protected void postprocessGradient(double[] grad) {
        for (int k = 0; k < this.m_numUnits; ++k) {
            for (int i = 0; i < this.m_numClasses; ++i) {
                int n = this.OFFSET_WEIGHTS + i * (this.m_numUnits + 1) + k;
                grad[n] = grad[n] + this.m_ridge * 2.0 * this.m_RBFParameters[this.OFFSET_WEIGHTS + i * (this.m_numUnits + 1) + k];
            }
        }
        double factor = 1.0 / this.m_data.sumOfWeights();
        int i = 0;
        while (i < grad.length) {
            int n = i++;
            grad[n] = grad[n] * factor;
        }
    }

    @Override
    protected void updateGradient(double[] grad, Instance inst, double[] outputs, double[] sigmoidDerivativeOutput, double[] deltaHidden) {
        Arrays.fill(deltaHidden, 0.0);
        for (int j = 0; j < this.m_numClasses; ++j) {
            int i;
            double pred = this.getOutput(j, outputs, sigmoidDerivativeOutput);
            double target = (int)inst.value(this.m_classIndex) == j ? 0.99 : 0.01;
            double deltaOut = inst.weight() * (pred - target) * sigmoidDerivativeOutput[0];
            if (deltaOut <= this.m_tolerance && deltaOut >= -this.m_tolerance) continue;
            int offsetOW = this.OFFSET_WEIGHTS + j * (this.m_numUnits + 1);
            for (i = 0; i < this.m_numUnits; ++i) {
                int n = i;
                deltaHidden[n] = deltaHidden[n] + deltaOut * this.m_RBFParameters[offsetOW + i];
            }
            for (i = 0; i < this.m_numUnits; ++i) {
                int n = offsetOW + i;
                grad[n] = grad[n] + deltaOut * outputs[i];
            }
            int n = offsetOW + this.m_numUnits;
            grad[n] = grad[n] + deltaOut;
        }
    }

    protected double getOutput(int unit, double[] outputs, double[] d) {
        double result = 0.0;
        for (int i = 0; i < this.m_numUnits; ++i) {
            result += this.m_RBFParameters[this.OFFSET_WEIGHTS + unit * (this.m_numUnits + 1) + i] * outputs[i];
        }
        return this.sigmoid(-(result += this.m_RBFParameters[this.OFFSET_WEIGHTS + unit * (this.m_numUnits + 1) + this.m_numUnits]), d, 0);
    }

    protected double approxExp(double x, double[] d, int index) {
        double y = 1.0 + x / 4096.0;
        x = y * y;
        x *= x;
        x *= x;
        x *= x;
        x *= x;
        x *= x;
        x *= x;
        x *= x;
        x *= x;
        x *= x;
        x *= x;
        x *= x;
        if (d != null) {
            d[index] = x / y;
        }
        return x;
    }

    protected double sigmoid(double x, double[] d, int index) {
        double y = 1.0 + x / 4096.0;
        x = y * y;
        x *= x;
        x *= x;
        x *= x;
        x *= x;
        x *= x;
        x *= x;
        x *= x;
        x *= x;
        x *= x;
        x *= x;
        x *= x;
        double output = 1.0 / (1.0 + x);
        if (d != null) {
            d[index] = output * (1.0 - output) / y;
        }
        return output;
    }

    @Override
    protected double[] getDistribution(double[] outputs) {
        double[] dist = new double[this.m_numClasses];
        for (int i = 0; i < this.m_numClasses; ++i) {
            dist[i] = this.getOutput(i, outputs, null);
            if (dist[i] < 0.0) {
                dist[i] = 0.0;
                continue;
            }
            if (!(dist[i] > 1.0)) continue;
            dist[i] = 1.0;
        }
        Utils.normalize((double[])dist);
        return dist;
    }

    public String toString() {
        int j;
        if (this.m_RBFParameters == null) {
            return "Classifier not built yet.";
        }
        String s = "";
        for (int i = 0; i < this.m_numUnits; ++i) {
            int j2;
            if (i > 0) {
                s = s + "\n\n";
            }
            s = s + "Output weights for different classes:\n";
            for (j2 = 0; j2 < this.m_numClasses; ++j2) {
                s = s + this.m_RBFParameters[this.OFFSET_WEIGHTS + j2 * (this.m_numUnits + 1) + i] + "\t";
            }
            s = s + "\n\nUnit center:\n";
            for (j2 = 0; j2 < this.m_numAttributes; ++j2) {
                if (j2 == this.m_classIndex) continue;
                s = s + this.m_RBFParameters[this.OFFSET_CENTERS + i * this.m_numAttributes + j2] + "\t";
            }
            if (this.m_scaleOptimizationOption == 3) {
                s = s + "\n\nUnit scales:\n";
                for (j2 = 0; j2 < this.m_numAttributes; ++j2) {
                    if (j2 == this.m_classIndex) continue;
                    s = s + this.m_RBFParameters[this.OFFSET_SCALES + i * this.m_numAttributes + j2] + "\t";
                }
                continue;
            }
            if (this.m_scaleOptimizationOption != 2) continue;
            s = s + "\n\nUnit scale:\n";
            s = s + this.m_RBFParameters[this.OFFSET_SCALES + i] + "\t";
        }
        if (this.m_scaleOptimizationOption == 1) {
            s = s + "\n\nScale:\n";
            s = s + this.m_RBFParameters[this.OFFSET_SCALES] + "\t";
        }
        if (this.m_useAttributeWeights) {
            s = s + "\n\nAttribute weights:\n";
            for (j = 0; j < this.m_numAttributes; ++j) {
                if (j == this.m_classIndex) continue;
                s = s + this.m_RBFParameters[this.OFFSET_ATTRIBUTE_WEIGHTS + j] + "\t";
            }
        }
        s = s + "\n\nBias weights for different classes:\n";
        for (j = 0; j < this.m_numClasses; ++j) {
            s = s + this.m_RBFParameters[this.OFFSET_WEIGHTS + j * (this.m_numUnits + 1) + this.m_numUnits] + "\t";
        }
        return s;
    }

    public static void main(String[] argv) {
        RBFClassifier.runClassifier((Classifier)new RBFClassifier(), (String[])argv);
    }
}

