/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.Remove;

public class RemoveType
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    static final long serialVersionUID = -3563999462782486279L;
    protected Remove m_attributeFilter = new Remove();
    protected int m_attTypeToDelete = 2;
    protected boolean m_invert = false;
    public static final Tag[] TAGS_ATTRIBUTETYPE = new Tag[]{new Tag(1, "Delete nominal attributes"), new Tag(0, "Delete numeric attributes"), new Tag(2, "Delete string attributes"), new Tag(3, "Delete date attributes"), new Tag(4, "Delete relational attributes")};

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        int[] attsToDelete = new int[instanceInfo.numAttributes()];
        int numToDelete = 0;
        int i = 0;
        while (i < instanceInfo.numAttributes()) {
            block6: {
                block5: {
                    if (i != instanceInfo.classIndex()) break block5;
                    if (!this.m_invert) break block6;
                    attsToDelete[numToDelete++] = i;
                }
                if (instanceInfo.attribute(i).type() == this.m_attTypeToDelete) {
                    attsToDelete[numToDelete++] = i;
                }
            }
            ++i;
        }
        int[] finalAttsToDelete = new int[numToDelete];
        System.arraycopy(attsToDelete, 0, finalAttsToDelete, 0, numToDelete);
        this.m_attributeFilter.setAttributeIndicesArray(finalAttsToDelete);
        this.m_attributeFilter.setInvertSelection(this.m_invert);
        boolean result = this.m_attributeFilter.setInputFormat(instanceInfo);
        Instances afOutputFormat = this.m_attributeFilter.getOutputFormat();
        afOutputFormat.setRelationName(instanceInfo.relationName());
        this.setOutputFormat(afOutputFormat);
        return result;
    }

    @Override
    public boolean input(Instance instance) {
        return this.m_attributeFilter.input(instance);
    }

    @Override
    public boolean batchFinished() throws Exception {
        return this.m_attributeFilter.batchFinished();
    }

    @Override
    public Instance output() {
        return this.m_attributeFilter.output();
    }

    @Override
    public Instance outputPeek() {
        return this.m_attributeFilter.outputPeek();
    }

    @Override
    public int numPendingOutput() {
        return this.m_attributeFilter.numPendingOutput();
    }

    @Override
    public boolean isOutputFormatDefined() {
        return this.m_attributeFilter.isOutputFormatDefined();
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tAttribute type to delete. Valid options are \"nominal\", \n\t\"numeric\", \"string\", \"date\" and \"relational\".\n\t(default \"string\")", "T", 1, "-T <nominal|numeric|string|date|relational>"));
        newVector.addElement(new Option("\tInvert matching sense (i.e. only keep specified columns)", "V", 0, "-V"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tString = Utils.getOption('T', options);
        if (tString.length() != 0) {
            this.setAttributeTypeString(tString);
        }
        this.setInvertSelection(Utils.getFlag('V', options));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        if (this.getInvertSelection()) {
            options.add("-V");
        }
        options.add("-T");
        options.add(this.getAttributeTypeString());
        return options.toArray(new String[0]);
    }

    public String globalInfo() {
        return "Removes attributes of a given type.";
    }

    public String attributeTypeTipText() {
        return "The type of attribute to remove.";
    }

    public void setAttributeType(SelectedTag type) {
        if (type.getTags() == TAGS_ATTRIBUTETYPE) {
            this.m_attTypeToDelete = type.getSelectedTag().getID();
        }
    }

    public SelectedTag getAttributeType() {
        return new SelectedTag(this.m_attTypeToDelete, TAGS_ATTRIBUTETYPE);
    }

    public String invertSelectionTipText() {
        return "Determines whether action is to select or delete. If set to true, only the specified attributes will be kept; If set to false, specified attributes will be deleted.";
    }

    public boolean getInvertSelection() {
        return this.m_invert;
    }

    public void setInvertSelection(boolean invert) {
        this.m_invert = invert;
    }

    protected String getAttributeTypeString() {
        if (this.m_attTypeToDelete == 1) {
            return "nominal";
        }
        if (this.m_attTypeToDelete == 0) {
            return "numeric";
        }
        if (this.m_attTypeToDelete == 2) {
            return "string";
        }
        if (this.m_attTypeToDelete == 3) {
            return "date";
        }
        if (this.m_attTypeToDelete == 4) {
            return "relational";
        }
        return "unknown";
    }

    protected void setAttributeTypeString(String typeString) {
        if ((typeString = typeString.toLowerCase()).equals("nominal")) {
            this.m_attTypeToDelete = 1;
        } else if (typeString.equals("numeric")) {
            this.m_attTypeToDelete = 0;
        } else if (typeString.equals("string")) {
            this.m_attTypeToDelete = 2;
        } else if (typeString.equals("date")) {
            this.m_attTypeToDelete = 3;
        } else if (typeString.equals("relational")) {
            this.m_attTypeToDelete = 4;
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10215 $");
    }

    public static void main(String[] argv) {
        RemoveType.runFilter(new RemoveType(), argv);
    }
}

