/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.ht;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import weka.classifiers.trees.ht.SplitMetric;
import weka.classifiers.trees.ht.WeightMass;
import weka.core.ContingencyTables;
import weka.core.Utils;

public class InfoGainSplitMetric
extends SplitMetric
implements Serializable {
    private static final long serialVersionUID = 2173840581308675428L;
    protected double m_minFracWeightForTwoBranches;

    public InfoGainSplitMetric(double minFracWeightForTwoBranches) {
        this.m_minFracWeightForTwoBranches = minFracWeightForTwoBranches;
    }

    @Override
    public double evaluateSplit(Map<String, WeightMass> preDist, List<Map<String, WeightMass>> postDist) {
        double[] pre = new double[preDist.size()];
        int count = 0;
        for (Map.Entry<String, WeightMass> e : preDist.entrySet()) {
            pre[count++] = e.getValue().m_weight;
        }
        double preEntropy = ContingencyTables.entropy(pre);
        double[] distWeights = new double[postDist.size()];
        double totalWeight = 0.0;
        int i = 0;
        while (i < postDist.size()) {
            distWeights[i] = SplitMetric.sum(postDist.get(i));
            totalWeight += distWeights[i];
            ++i;
        }
        int fracCount = 0;
        double[] dArray = distWeights;
        int n = distWeights.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            if (d / totalWeight > this.m_minFracWeightForTwoBranches) {
                ++fracCount;
            }
            ++n2;
        }
        if (fracCount < 2) {
            return Double.NEGATIVE_INFINITY;
        }
        double postEntropy = 0.0;
        int i2 = 0;
        while (i2 < postDist.size()) {
            Map<String, WeightMass> d = postDist.get(i2);
            double[] post = new double[d.size()];
            count = 0;
            for (Map.Entry<String, WeightMass> e : d.entrySet()) {
                post[count++] = e.getValue().m_weight;
            }
            postEntropy += distWeights[i2] * ContingencyTables.entropy(post);
            ++i2;
        }
        if (totalWeight > 0.0) {
            postEntropy /= totalWeight;
        }
        return preEntropy - postEntropy;
    }

    @Override
    public double getMetricRange(Map<String, WeightMass> preDist) {
        int numClasses = preDist.size();
        if (numClasses < 2) {
            numClasses = 2;
        }
        return Utils.log2(numClasses);
    }
}

