/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyEditorSupport;
import javax.swing.JFrame;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertyValueSelector;

public class SelectedTagEditor
extends PropertyEditorSupport {
    @Override
    public String getJavaInitializationString() {
        SelectedTag s = (SelectedTag)this.getValue();
        Tag[] tags = s.getTags();
        String result = "new SelectedTag(" + s.getSelectedTag().getID() + ", {\n";
        int i = 0;
        while (i < tags.length) {
            result = String.valueOf(result) + "new Tag(" + tags[i].getID() + ",\"" + tags[i].getReadable() + "\")";
            if (i < tags.length - 1) {
                result = String.valueOf(result) + ',';
            }
            result = String.valueOf(result) + '\n';
            ++i;
        }
        return String.valueOf(result) + "})";
    }

    @Override
    public String getAsText() {
        SelectedTag s = (SelectedTag)this.getValue();
        return s.getSelectedTag().getReadable();
    }

    @Override
    public void setAsText(String text) {
        SelectedTag s = (SelectedTag)this.getValue();
        Tag[] tags = s.getTags();
        try {
            int i = 0;
            while (i < tags.length) {
                if (text.equals(tags[i].getReadable())) {
                    this.setValue(new SelectedTag(tags[i].getID(), tags));
                    return;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(text);
        }
    }

    @Override
    public String[] getTags() {
        SelectedTag s = (SelectedTag)this.getValue();
        Tag[] tags = s.getTags();
        String[] result = new String[tags.length];
        int i = 0;
        while (i < tags.length) {
            result[i] = tags[i].getReadable();
            ++i;
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            GenericObjectEditor.registerEditors();
            Tag[] tags = new Tag[]{new Tag(1, "First option"), new Tag(2, "Second option"), new Tag(3, "Third option"), new Tag(4, "Fourth option"), new Tag(5, "Fifth option")};
            SelectedTag initial = new SelectedTag(1, tags);
            SelectedTagEditor ce = new SelectedTagEditor();
            ce.setValue(initial);
            PropertyValueSelector ps = new PropertyValueSelector(ce);
            JFrame f = new JFrame();
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            f.getContentPane().setLayout(new BorderLayout());
            f.getContentPane().add((Component)ps, "Center");
            f.pack();
            f.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

