/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import weka.core.AbstractInstance;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Sourcable;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.PotentialClassIgnorer;

public class Standardize
extends PotentialClassIgnorer
implements UnsupervisedFilter,
Sourcable {
    static final long serialVersionUID = -6830769026855053281L;
    private double[] m_Means;
    private double[] m_StdDevs;

    public String globalInfo() {
        return "Standardizes all numeric attributes in the given dataset to have zero mean and unit variance (apart from the class attribute, if set).";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        this.m_StdDevs = null;
        this.m_Means = null;
        return true;
    }

    @Override
    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_Means == null) {
            this.bufferInput(instance);
            return false;
        }
        this.convertInstance(instance);
        return true;
    }

    @Override
    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_Means == null) {
            Instances input = this.getInputFormat();
            this.m_Means = new double[input.numAttributes()];
            this.m_StdDevs = new double[input.numAttributes()];
            int i = 0;
            while (i < input.numAttributes()) {
                if (input.attribute(i).isNumeric() && input.classIndex() != i) {
                    this.m_Means[i] = input.meanOrMode(i);
                    this.m_StdDevs[i] = Math.sqrt(input.variance(i));
                }
                ++i;
            }
            i = 0;
            while (i < input.numInstances()) {
                this.convertInstance(input.instance(i));
                ++i;
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    private void convertInstance(Instance instance) throws Exception {
        AbstractInstance inst = null;
        if (instance instanceof SparseInstance) {
            double[] newVals = new double[instance.numAttributes()];
            int[] newIndices = new int[instance.numAttributes()];
            double[] vals = instance.toDoubleArray();
            int ind = 0;
            int j = 0;
            while (j < instance.numAttributes()) {
                double value;
                if (instance.attribute(j).isNumeric() && !Utils.isMissingValue(vals[j]) && this.getInputFormat().classIndex() != j) {
                    value = this.m_StdDevs[j] > 0.0 ? (vals[j] - this.m_Means[j]) / this.m_StdDevs[j] : vals[j] - this.m_Means[j];
                    if (Double.isNaN(value)) {
                        throw new Exception("A NaN value was generated while standardizing attribute " + instance.attribute(j).name());
                    }
                    if (value != 0.0) {
                        newVals[ind] = value;
                        newIndices[ind] = j;
                        ++ind;
                    }
                } else {
                    value = vals[j];
                    if (value != 0.0) {
                        newVals[ind] = value;
                        newIndices[ind] = j;
                        ++ind;
                    }
                }
                ++j;
            }
            double[] tempVals = new double[ind];
            int[] tempInd = new int[ind];
            System.arraycopy(newVals, 0, tempVals, 0, ind);
            System.arraycopy(newIndices, 0, tempInd, 0, ind);
            inst = new SparseInstance(instance.weight(), tempVals, tempInd, instance.numAttributes());
        } else {
            double[] vals = instance.toDoubleArray();
            int j = 0;
            while (j < this.getInputFormat().numAttributes()) {
                if (instance.attribute(j).isNumeric() && !Utils.isMissingValue(vals[j]) && this.getInputFormat().classIndex() != j) {
                    vals[j] = this.m_StdDevs[j] > 0.0 ? (vals[j] - this.m_Means[j]) / this.m_StdDevs[j] : vals[j] - this.m_Means[j];
                    if (Double.isNaN(vals[j])) {
                        throw new Exception("A NaN value was generated while standardizing attribute " + instance.attribute(j).name());
                    }
                }
                ++j;
            }
            inst = new DenseInstance(instance.weight(), vals);
        }
        inst.setDataset(instance.dataset());
        this.push(inst);
    }

    @Override
    public String toSource(String className, Instances data) throws Exception {
        StringBuffer result = new StringBuffer();
        boolean[] process = new boolean[data.numAttributes()];
        int i = 0;
        while (i < data.numAttributes()) {
            process[i] = data.attribute(i).isNumeric() && i != data.classIndex();
            ++i;
        }
        result.append("class " + className + " {\n");
        result.append("\n");
        result.append("  /** lists which attributes will be processed */\n");
        result.append("  protected final static boolean[] PROCESS = new boolean[]{" + Utils.arrayToString(process) + "};\n");
        result.append("\n");
        result.append("  /** the computed means */\n");
        result.append("  protected final static double[] MEANS = new double[]{" + Utils.arrayToString(this.m_Means) + "};\n");
        result.append("\n");
        result.append("  /** the computed standard deviations */\n");
        result.append("  protected final static double[] STDEVS = new double[]{" + Utils.arrayToString(this.m_StdDevs) + "};\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * filters a single row\n");
        result.append("   * \n");
        result.append("   * @param i the row to process\n");
        result.append("   * @return the processed row\n");
        result.append("   */\n");
        result.append("  public static Object[] filter(Object[] i) {\n");
        result.append("    Object[] result;\n");
        result.append("\n");
        result.append("    result = new Object[i.length];\n");
        result.append("    for (int n = 0; n < i.length; n++) {\n");
        result.append("      if (PROCESS[n] && (i[n] != null)) {\n");
        result.append("        if (STDEVS[n] > 0)\n");
        result.append("          result[n] = (((Double) i[n]) - MEANS[n]) / STDEVS[n];\n");
        result.append("        else\n");
        result.append("          result[n] = ((Double) i[n]) - MEANS[n];\n");
        result.append("      }\n");
        result.append("      else {\n");
        result.append("        result[n] = i[n];\n");
        result.append("      }\n");
        result.append("    }\n");
        result.append("\n");
        result.append("    return result;\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * filters multiple rows\n");
        result.append("   * \n");
        result.append("   * @param i the rows to process\n");
        result.append("   * @return the processed rows\n");
        result.append("   */\n");
        result.append("  public static Object[][] filter(Object[][] i) {\n");
        result.append("    Object[][] result;\n");
        result.append("\n");
        result.append("    result = new Object[i.length][];\n");
        result.append("    for (int n = 0; n < i.length; n++) {\n");
        result.append("      result[n] = filter(i[n]);\n");
        result.append("    }\n");
        result.append("\n");
        result.append("    return result;\n");
        result.append("  }\n");
        result.append("}\n");
        return result.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] argv) {
        Standardize.runFilter(new Standardize(), argv);
    }
}

