/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class StringUtil {
    public static Collection<String> split(String str, String delimiter) {
        if (str == null) {
            return Collections.emptyList();
        }
        ArrayList<String> parts = new ArrayList<String>();
        String[] stringArray = str.split(delimiter);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            parts.add(p.trim());
            ++n2;
        }
        return parts;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static Object print(Object o) {
        return o;
    }

    public static String firstToUpper(String str) {
        String result = str.substring(1, str.length());
        result = String.valueOf(str.substring(0, 1).toUpperCase()) + result;
        return result;
    }

    public static String firstToLower(String str) {
        String result = str.substring(1, str.length());
        result = String.valueOf(str.substring(0, 1).toLowerCase()) + result;
        return result;
    }

    public static boolean areEqual(String s1, String s2) {
        return StringUtil.toString(s1).equalsIgnoreCase(StringUtil.toString(s2));
    }

    public static String toString(Object o) {
        if (o != null) {
            return o.toString();
        }
        return "";
    }

    public static String toString(Object o, String default_) {
        if (o != null) {
            return o.toString();
        }
        return default_;
    }

    public static String escapeHtml(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(string.length());
        boolean lastWasBlankChar = false;
        int len = string.length();
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (c == ' ') {
                if (lastWasBlankChar) {
                    lastWasBlankChar = false;
                    sb.append("&nbsp;");
                } else {
                    lastWasBlankChar = true;
                    sb.append(' ');
                }
            } else {
                lastWasBlankChar = false;
                if (c == '\"') {
                    sb.append("&quot;");
                } else if (c == '&') {
                    sb.append("&amp;");
                } else if (c == '<') {
                    sb.append("&lt;");
                } else if (c == '>') {
                    sb.append("&gt;");
                } else if (c == '\n') {
                    sb.append("&lt;br/&gt;");
                } else {
                    int ci = 0xFFFF & c;
                    if (ci < 160) {
                        sb.append(c);
                    } else {
                        sb.append("&#");
                        sb.append(new Integer(ci).toString());
                        sb.append(';');
                    }
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String reverse(String text) {
        return new StringBuilder(text).reverse().toString();
    }
}

