/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.ecl;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.ecl.exceptions.EclNotApplicableSuperRuleException;
import org.eclipse.epsilon.ecl.execute.context.IEclContext;
import org.eclipse.epsilon.ecl.trace.Match;
import org.eclipse.epsilon.ecl.trace.MatchTrace;
import org.eclipse.epsilon.eol.EolFormalParameter;
import org.eclipse.epsilon.eol.exceptions.EolIllegalReturnException;
import org.eclipse.epsilon.eol.exceptions.EolNoReturnException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.Return;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.types.EolMap;
import org.eclipse.epsilon.eol.types.EolModelElementType;
import org.eclipse.epsilon.erl.rules.ExtensibleNamedRule;

public class MatchRule
extends ExtensibleNamedRule
implements ModuleElement {
    protected AST compareAst;
    protected AST doAst;
    protected EolFormalParameter leftParameter;
    protected EolFormalParameter rightParameter;
    protected Collection<?> leftInstances;
    protected Collection<?> rightInstances;
    protected Collection<?> allOfLeftType;
    protected Collection<?> allOfRightType;
    protected AST guardAst = null;
    protected AST bodyAst = null;
    protected AST superRulesAst = null;

    public MatchRule(AST ast) {
        this.parse(ast);
    }

    @Override
    public AST getSuperRulesAst() {
        return AstUtil.getChild(this.ast, 78);
    }

    @Override
    public void parse(AST ast) {
        super.parse(ast);
        this.guardAst = AstUtil.getChild(ast, 79);
        this.bodyAst = AstUtil.getChild(ast, 61);
        AST leftParameterAst = ast.getFirstChild().getNextSibling();
        this.leftParameter = new EolFormalParameter(leftParameterAst);
        AST rightParameterAst = leftParameterAst.getNextSibling();
        this.rightParameter = new EolFormalParameter(rightParameterAst);
        this.compareAst = AstUtil.getChild(ast, 81);
        this.doAst = AstUtil.getChild(ast, 82);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean appliesTo(Object left, Object right, IEclContext context, boolean ofTypeOnly) throws EolRuntimeException {
        boolean appliesToTypes = false;
        appliesToTypes = !ofTypeOnly || this.isGreedy() ? this.getAllOfLeftKind(context).contains(left) && this.getAllOfRightKind(context).contains(right) : this.getAllOfLeftType(context).contains(left) && this.getAllOfRightType(context).contains(right);
        boolean guardSatisfied = true;
        if (this.isAbstract() || !appliesToTypes || this.guardAst == null) return appliesToTypes && guardSatisfied;
        context.getFrameStack().enterLocal(FrameType.PROTECTED, this.guardAst, new Variable[0]);
        context.getFrameStack().put(Variable.createReadOnlyVariable(this.leftParameter.getName(), left));
        context.getFrameStack().put(Variable.createReadOnlyVariable(this.rightParameter.getName(), right));
        context.getFrameStack().put(Variable.createReadOnlyVariable("self", this));
        Object result = context.getExecutorFactory().executeBlockOrExpressionAst(this.guardAst.getFirstChild(), context);
        context.getFrameStack().leaveLocal(this.guardAst);
        if (!(result instanceof Return)) throw new EolNoReturnException("Boolean", this.guardAst, context);
        Object value = ((Return)result).getValue();
        if (!(value instanceof Boolean)) throw new EolIllegalReturnException("Boolean", value, this.guardAst, context);
        guardSatisfied = (Boolean)value;
        return appliesToTypes && guardSatisfied;
    }

    public Collection<?> getAllOfRightType(IEclContext context) throws EolRuntimeException {
        if (this.rightInstances == null) {
            try {
                EolModelElementType rightType = (EolModelElementType)this.rightParameter.getType(context);
                this.rightInstances = rightType.getAllOfType();
            }
            catch (EolRuntimeException ex) {
                ex.setAst(this.rightParameter.getTypeAst());
                throw ex;
            }
        }
        return this.rightInstances;
    }

    public Collection<?> getAllOfLeftType(IEclContext context) throws EolRuntimeException {
        if (this.leftInstances == null) {
            try {
                EolModelElementType leftType = (EolModelElementType)this.leftParameter.getType(context);
                this.leftInstances = leftType.getAllOfType();
            }
            catch (EolRuntimeException ex) {
                ex.setAst(this.leftParameter.getTypeAst());
                throw ex;
            }
        }
        return this.leftInstances;
    }

    public Collection<?> getAllOfRightKind(IEclContext context) throws EolRuntimeException {
        if (this.allOfRightType == null) {
            try {
                EolModelElementType rightType = (EolModelElementType)this.rightParameter.getType(context);
                this.allOfRightType = rightType.getAllOfKind();
            }
            catch (EolRuntimeException ex) {
                ex.setAst(this.rightParameter.getTypeAst());
                throw ex;
            }
        }
        return this.allOfRightType;
    }

    public Collection<?> getAllOfLeftKind(IEclContext context) throws EolRuntimeException {
        if (this.allOfLeftType == null) {
            try {
                EolModelElementType leftType = (EolModelElementType)this.leftParameter.getType(context);
                this.allOfLeftType = leftType.getAllOfKind();
            }
            catch (EolRuntimeException ex) {
                ex.setAst(this.leftParameter.getTypeAst());
                throw ex;
            }
        }
        return this.allOfLeftType;
    }

    public void matchAll(IEclContext context, boolean ofTypeOnly) throws EolRuntimeException {
        Iterator<?> leftIterator = ofTypeOnly ? this.getAllOfLeftType(context).iterator() : this.getAllOfLeftKind(context).iterator();
        while (leftIterator.hasNext()) {
            Object leftInstance = leftIterator.next();
            Iterator<?> rightIterator = ofTypeOnly ? this.getAllOfRightType(context).iterator() : this.getAllOfRightKind(context).iterator();
            while (rightIterator.hasNext()) {
                Object rightInstance = rightIterator.next();
                if (!ofTypeOnly && context.getMatchTrace().getMatch(leftInstance, rightInstance) != null) continue;
                if (this.appliesTo(leftInstance, rightInstance, context, true)) {
                    this.match(leftInstance, rightInstance, context, false, null, false);
                    continue;
                }
                if (!this.appliesTo(leftInstance, rightInstance, context, false)) continue;
                this.match(leftInstance, rightInstance, context, false, null, false);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Match match(Object left, Object right, IEclContext context, boolean asSuperRule, EolMap matchInfo, boolean forcedMatch) throws EolRuntimeException {
        MatchTrace matchTrace = context.getMatchTrace();
        MatchTrace tempMatchTrace = context.getTempMatchTrace();
        Match match = null;
        Match tempMatch = null;
        if (!asSuperRule) {
            tempMatch = tempMatchTrace.getMatch(left, right);
            if (tempMatch != null) {
                return tempMatch;
            }
            tempMatch = tempMatchTrace.createMatch(left, right, true);
            tempMatch.setRule(this);
            tempMatchTrace.getMatches().add(tempMatch);
            match = matchTrace.getMatch(left, right);
            if (match != null) {
                tempMatchTrace.getMatches().remove(tempMatch);
                return match;
            }
        } else if (!this.appliesTo(left, right, context, false)) {
            throw new EclNotApplicableSuperRuleException(left, right, this, context);
        }
        match = new Match();
        match.setLeft(left);
        match.setRight(right);
        match.setMatching(true);
        match.setRule(this);
        if (this.superRules.size() > 0) {
            Iterator it = this.superRules.iterator();
            boolean matching = true;
            while (it.hasNext()) {
                MatchRule matchRule = (MatchRule)it.next();
                Match superRuleMatch = matchRule.match(left, right, context, true, match.getInfo(), false);
                boolean bl = matching = matching && superRuleMatch.isMatching();
            }
            match.setMatching(matching);
            if (!matching) {
                tempMatchTrace.getMatches().remove(tempMatch);
                matchTrace.getMatches().add(match);
                return match;
            }
        }
        FrameStack scope = context.getFrameStack();
        scope.enterLocal(FrameType.PROTECTED, this.ast, new Variable[0]);
        EolMap info = null;
        info = asSuperRule ? matchInfo : match.getInfo();
        scope.put(Variable.createReadOnlyVariable(this.leftParameter.getName(), left));
        scope.put(Variable.createReadOnlyVariable(this.rightParameter.getName(), right));
        scope.put(Variable.createReadOnlyVariable("matchInfo", info));
        context.getFrameStack().put(Variable.createReadOnlyVariable("self", this));
        if (this.compareAst != null) {
            Object result = context.getExecutorFactory().executeBlockOrExpressionAst(this.compareAst.getFirstChild(), context);
            if (!(result instanceof Return)) throw new EolNoReturnException("Boolean", this.compareAst, context);
            Object value = ((Return)result).getValue();
            if (!(value instanceof Boolean)) throw new EolIllegalReturnException("Boolean", value, this.compareAst, context);
            boolean matching = (Boolean)value;
            match.setMatching(matching);
        } else if (this.superRules.size() == 0) {
            match.setMatching(false);
        }
        if (!asSuperRule) {
            tempMatchTrace.getMatches().remove(tempMatch);
            if (forcedMatch || tempMatchTrace.getMatches().size() == 0) {
                matchTrace.getMatches().add(match);
            }
        }
        if (this.doAst != null && match.isMatching()) {
            context.getExecutorFactory().executeBlockOrExpressionAst(this.doAst.getFirstChild(), context);
        }
        scope.leaveLocal(this.ast);
        return match;
    }

    @Override
    public boolean isLazy() throws EolRuntimeException {
        return super.isLazy();
    }

    public String toString() {
        String str = this.name;
        str = String.valueOf(str) + " (";
        str = String.valueOf(str) + this.leftParameter.getTypeName() + ", " + this.rightParameter.getTypeName();
        str = String.valueOf(str) + ")";
        return str;
    }

    @Override
    public List<?> getChildren() {
        return Collections.emptyList();
    }
}

