/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.execute.context;

import java.util.ArrayDeque;
import java.util.Deque;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.egl.execute.context.ExecutableTemplateSpecification;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.Variable;

public class EglFrameStackManager {
    private final FrameStack frameStack;
    private final Deque<AST> localMarkers = new ArrayDeque<AST>();
    private final Deque<AST> globalMarkers = new ArrayDeque<AST>();

    public EglFrameStackManager(FrameStack frameStack) {
        this.frameStack = frameStack;
    }

    public void prepareFrameStackFor(ExecutableTemplateSpecification spec) {
        this.createFrameForTemplateSpecificGlobals();
        this.createOwnFrameForLocals();
        spec.addVariablesTo(this.frameStack);
    }

    public void restoreFrameStackToPreviousState() {
        this.frameStack.leaveLocal(this.localMarkers.pop());
        this.frameStack.leaveGlobal(this.globalMarkers.pop());
    }

    private void createFrameForTemplateSpecificGlobals() {
        AST frameGlobalStackMarker = new AST();
        this.globalMarkers.push(frameGlobalStackMarker);
        this.frameStack.enterGlobal(FrameType.UNPROTECTED, frameGlobalStackMarker, new Variable[0]);
    }

    private void createOwnFrameForLocals() {
        AST frameLocalStackMarker = new AST();
        this.localMarkers.push(frameLocalStackMarker);
        this.frameStack.enterLocal(FrameType.PROTECTED, frameLocalStackMarker, new Variable[0]);
    }
}

