/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.internal;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.antlr.runtime.Token;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.Region;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.egl.exceptions.EglRuntimeException;
import org.eclipse.epsilon.egl.exceptions.EglStoppedException;
import org.eclipse.epsilon.egl.internal.EglModule;
import org.eclipse.epsilon.egl.internal.EglOperationFactory;
import org.eclipse.epsilon.egl.internal.EglPreprocessorContext;
import org.eclipse.epsilon.egl.parse.problem.EglParseProblem;
import org.eclipse.epsilon.egl.preprocessor.Preprocessor;
import org.eclipse.epsilon.eol.EolModule;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

public class EglPreprocessorModule
extends EolModule {
    private final Preprocessor preprocessor = new Preprocessor();
    private EglPreprocessorContext context;
    private static final HashMap<String, Class<?>> importConfiguration = new HashMap();

    static {
        importConfiguration.put("eol", EolModule.class);
        importConfiguration.put("egl", EglModule.class);
    }

    public EglPreprocessorModule() {
        this.context = new EglPreprocessorContext(((EolModule)this).context);
    }

    @Override
    public EglPreprocessorContext getContext() {
        return this.context;
    }

    @Override
    public void reset() {
        super.reset();
        this.context = new EglPreprocessorContext(((EolModule)this).context);
    }

    public boolean preprocess(AST ast, File sourceFile, URI sourceUri) {
        this.sourceFile = sourceFile;
        this.sourceUri = sourceUri;
        String eol = this.preprocessor.convertToEol(ast);
        try {
            this.setOperationFactory(new EglOperationFactory());
            if (this.parse(eol, sourceFile)) {
                this.updateASTLocations(this.ast);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected void updateASTLocations(AST ast) {
        ast.setColumn(this.preprocessor.getTrace().getEglColumnNumberFor(ast.getLine(), ast.getColumn()));
        ast.setLine(this.preprocessor.getTrace().getEglLineNumberFor(ast.getLine()));
        for (Token token : ast.getExtraTokens()) {
            if (token == null) continue;
            token.setCharPositionInLine(this.preprocessor.getTrace().getEglColumnNumberFor(token.getLine(), token.getCharPositionInLine()));
            token.setLine(this.preprocessor.getTrace().getEglLineNumberFor(token.getLine()));
        }
        boolean done = this.updateRegionsOfStaticTextASTs(ast);
        if (!done) {
            for (AST child : ast.getChildren()) {
                this.updateASTLocations(child);
            }
        }
    }

    private boolean updateRegionsOfStaticTextASTs(AST ast) {
        if (ast.getType() == 9 && ast.getNumberOfChildren() == 2) {
            AST firstParameterAst;
            AST parametersAst;
            AST outAst = ast.getFirstChild();
            AST printAst = ast.getChild(1);
            if ("out".equals(outAst.getText()) && ("prinx".equals(printAst.getText()) || "printdyn".equals(printAst.getText())) && (parametersAst = printAst.getFirstChild()) != null && (firstParameterAst = parametersAst.getFirstChild()) != null) {
                ast.setImaginary(true);
                outAst.setImaginary(true);
                printAst.setImaginary(true);
                parametersAst.setImaginary(true);
                this.updateASTLocations(firstParameterAst);
                Region region = firstParameterAst.getRegion();
                Region adjustedRegion = null;
                if ("prinx".equals(printAst.getText()) && firstParameterAst.getType() == 14) {
                    adjustedRegion = new Region(region.getStart().getLine(), region.getStart().getColumn() + 1, region.getEnd().getLine(), region.getEnd().getColumn() - 1);
                    firstParameterAst.setRegion(adjustedRegion);
                } else {
                    adjustedRegion = region;
                }
                if ("\\n".equals(firstParameterAst.getText()) || "\\r\\n".equals(firstParameterAst.getText())) {
                    firstParameterAst.setImaginary(true);
                }
                for (AST imaginary : Arrays.asList(ast, outAst, printAst, parametersAst)) {
                    imaginary.setColumn(this.preprocessor.getTrace().getEglColumnNumberFor(imaginary.getLine(), imaginary.getColumn()));
                    imaginary.setLine(this.preprocessor.getTrace().getEglLineNumberFor(imaginary.getLine()));
                    imaginary.setImaginary(true);
                    imaginary.setRegion(adjustedRegion);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Object execute() throws EglRuntimeException {
        try {
            return super.execute();
        }
        catch (EolInternalException ex) {
            if (ex.getInternal() instanceof EglStoppedException) {
                return null;
            }
            if (ex.getInternal() instanceof EglRuntimeException) {
                throw new EglRuntimeException(ex);
            }
            throw new EglRuntimeException("Error encountered whilst processing template.", ex);
        }
        catch (EolRuntimeException ex) {
            if (ex instanceof EglRuntimeException) {
                throw (EglRuntimeException)ex;
            }
            throw new EglRuntimeException(ex);
        }
    }

    @Override
    public List<ParseProblem> getParseProblems() {
        List<ParseProblem> parseProblems = super.getParseProblems();
        int index = 0;
        while (index < parseProblems.size()) {
            ParseProblem problem = parseProblems.get(index);
            if (!(problem instanceof EglParseProblem)) {
                parseProblems.remove(index);
                parseProblems.add(index, new EglParseProblem(problem, this.preprocessor.getTrace()));
            }
            ++index;
        }
        return parseProblems;
    }

    @Override
    public final HashMap<String, Class<?>> getImportConfiguration() {
        return importConfiguration;
    }
}

