/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.emc.emf.AbstractEmfModel;
import org.eclipse.epsilon.emc.emf.CachedResourceSet;
import org.eclipse.epsilon.emc.emf.ContainmentChangeAdapter;
import org.eclipse.epsilon.emc.emf.EmfPropertySetter;
import org.eclipse.epsilon.emc.emf.EmfUtil;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotAnEnumerationValueException;
import org.eclipse.epsilon.eol.execute.introspection.IReflectivePropertySetter;
import org.eclipse.epsilon.eol.models.IReflectiveModel;

public class EmfModel
extends AbstractEmfModel
implements IReflectiveModel {
    public static final String PROPERTY_EXPAND = "expand";
    @Deprecated
    public static final String PROPERTY_IS_METAMODEL_FILE_BASED = "isMetamodelFileBased";
    public static final String PROPERTY_METAMODEL_URI = "metamodelUri";
    public static final String PROPERTY_FILE_BASED_METAMODEL_URI = "fileBasedMetamodelUri";
    @Deprecated
    public static final String PROPERTY_METAMODEL_FILE = "metamodelFile";
    public static final String PROPERTY_MODEL_URI = "modelUri";
    @Deprecated
    public static final String PROPERTY_MODEL_FILE = "modelFile";
    protected List<URI> metamodelUris = new ArrayList<URI>();
    protected List<EPackage> packages;
    protected boolean isMetamodelFileBased;
    protected URI modelUri = null;
    protected List<URI> metamodelFileUris = new ArrayList<URI>();
    protected boolean useExtendedMetadata = false;

    @Override
    public Collection<String> getPropertiesOf(String type) throws EolModelElementTypeNotFoundException {
        LinkedList<String> properties = new LinkedList<String>();
        for (EStructuralFeature feature : this.featuresForType(type)) {
            properties.add(feature.getName());
        }
        return properties;
    }

    @Override
    public boolean preventLoadingOfExternalModelElements() {
        if (this.isExpand()) {
            this.setExpand(false);
            return true;
        }
        return false;
    }

    @Override
    public void load(StringProperties properties, String basePath) throws EolModelLoadingException {
        PropertyMigrator.migrateDeprecatedProperties(properties);
        super.load(properties, basePath);
        this.modelUri = URI.createURI(properties.getProperty(PROPERTY_MODEL_URI));
        this.expand = properties.getBooleanProperty(PROPERTY_EXPAND, true);
        this.isMetamodelFileBased = properties.getBooleanProperty(PROPERTY_IS_METAMODEL_FILE_BASED, false);
        this.metamodelUris = this.toURIList(properties.getProperty(PROPERTY_METAMODEL_URI));
        this.metamodelFileUris = this.toURIList(properties.getProperty(PROPERTY_FILE_BASED_METAMODEL_URI));
        this.load();
    }

    @Override
    public boolean store() {
        if (this.modelImpl == null) {
            return false;
        }
        try {
            this.modelImpl.save(null);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected void loadModel() throws EolModelLoadingException {
        this.loadModelFromUri();
        this.setupContainmentChangeListeners();
    }

    public void setupContainmentChangeListeners() {
        if (this.modelImpl != null) {
            for (EObject eObject : this.allContents()) {
                boolean isAdapted = false;
                for (Adapter adapter : eObject.eAdapters()) {
                    if (!(adapter instanceof ContainmentChangeAdapter)) continue;
                    isAdapted = true;
                }
                if (isAdapted) continue;
                eObject.eAdapters().add(new ContainmentChangeAdapter(eObject, eObject.eResource()));
            }
        }
    }

    protected ResourceSet createResourceSet() {
        return new CachedResourceSet();
    }

    public void loadModelFromUri() throws EolModelLoadingException {
        ResourceSet resourceSet = this.createResourceSet();
        if (EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/2002/Ecore") == null) {
            EPackage.Registry.INSTANCE.put("http://www.eclipse.org/emf/2002/Ecore", EcorePackage.eINSTANCE);
        }
        this.determinePackagesFrom(resourceSet);
        for (EPackage ep : this.packages) {
            String nsUri = ep.getNsURI();
            if (nsUri == null || nsUri.trim().length() == 0) {
                nsUri = ep.getName();
            }
            resourceSet.getPackageRegistry().put(nsUri, ep);
        }
        resourceSet.getPackageRegistry().put("http://www.eclipse.org/emf/2002/Ecore", EcorePackage.eINSTANCE);
        Resource model = resourceSet.createResource(this.modelUri);
        if (this.readOnLoad) {
            try {
                model.load(null);
                if (this.expand) {
                    EcoreUtil.resolveAll(model);
                }
            }
            catch (IOException e) {
                throw new EolModelLoadingException(e, this);
            }
        }
        this.modelImpl = model;
    }

    public List<String> getMetamodelFiles() {
        ArrayList<String> files = new ArrayList<String>(this.metamodelFileUris.size());
        for (URI metamodelFileUri : this.metamodelFileUris) {
            files.add(EmfUtil.getFile(metamodelFileUri));
        }
        return files;
    }

    @Deprecated
    public boolean isMetamodelFileBased() {
        return this.isMetamodelFileBased;
    }

    @Deprecated
    public void setMetamodelFileBased(boolean isMetamodelFileBased) {
        this.isMetamodelFileBased = isMetamodelFileBased;
    }

    public List<String> getMetamodelUris() {
        ArrayList<String> uris = new ArrayList<String>(this.metamodelUris.size());
        for (URI metamodelUri : this.metamodelUris) {
            uris.add(metamodelUri.toString());
        }
        return uris;
    }

    public String getModelFile() {
        return EmfUtil.getFile(this.modelUri);
    }

    public URI getModelFileUri() {
        return this.modelUri;
    }

    public void setModelFileUri(URI modelFileUri) {
        this.modelUri = modelFileUri;
    }

    public List<URI> getMetamodelFileUris() {
        return this.metamodelFileUris;
    }

    public void setMetamodelFileUris(List<URI> fileUris) {
        this.metamodelFileUris = new ArrayList<URI>(fileUris);
    }

    public void setMetamodelFileUri(URI uri) {
        this.metamodelFileUris = Arrays.asList(uri);
    }

    public void setMetamodelUris(List<String> uris) {
        this.metamodelUris.clear();
        for (String sURI : uris) {
            this.metamodelUris.add(URI.createURI(sURI));
        }
    }

    public void setMetamodelUri(String uri) {
        this.metamodelUris = Arrays.asList(URI.createURI(uri));
    }

    public void setMetamodelFiles(List<String> paths) {
        this.metamodelFileUris.clear();
        for (String sPath : paths) {
            this.metamodelFileUris.add(URI.createFileURI(sPath));
        }
    }

    public void setMetamodelFile(String path) {
        this.setMetamodelFileUri(URI.createFileURI(path));
    }

    public void setModelFile(String path) {
        this.modelUri = URI.createFileURI(path);
    }

    @Override
    public IReflectivePropertySetter getPropertySetter() {
        return new EmfPropertySetter();
    }

    @Override
    public boolean hasProperty(String type, String property) throws EolModelElementTypeNotFoundException {
        return this.getPropertiesOf(type).contains(property);
    }

    @Override
    public boolean isEnumerationValue(Object object) {
        return object instanceof Enumerator;
    }

    @Override
    public String getEnumerationTypeOf(Object literal) throws EolNotAnEnumerationValueException {
        if (!this.isEnumerationValue(literal)) {
            throw new EolNotAnEnumerationValueException(literal);
        }
        if (literal instanceof EEnumLiteral) {
            return ((EEnumLiteral)literal).getEEnum().getName();
        }
        return ((Enumerator)literal).getClass().getSimpleName();
    }

    @Override
    public String getEnumerationLabelOf(Object literal) throws EolNotAnEnumerationValueException {
        if (!this.isEnumerationValue(literal)) {
            throw new EolNotAnEnumerationValueException(literal);
        }
        return ((Enumerator)literal).getName();
    }

    public String toString() {
        return "EmfModel [name=" + this.getName() + "]";
    }

    protected void determinePackagesFrom(ResourceSet resourceSet) throws EolModelLoadingException {
        this.packages = new ArrayList<EPackage>();
        for (URI metamodelFileUri : this.metamodelFileUris) {
            List<EPackage> metamodelPackages;
            try {
                metamodelPackages = EmfUtil.register(metamodelFileUri, resourceSet.getPackageRegistry());
            }
            catch (Exception e) {
                throw new EolModelLoadingException(e, this);
            }
            for (EPackage metamodelPackage : metamodelPackages) {
                this.packages.add(metamodelPackage);
                EmfUtil.collectDependencies(metamodelPackage, this.packages);
            }
        }
        for (URI metamodelUri : this.metamodelUris) {
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(metamodelUri.toString());
            if (ePackage == null) {
                throw new EolModelLoadingException(new IllegalArgumentException("Could not locate a metamodel with the URI '" + metamodelUri + "'. Please ensure that this metamodel has been registered with Epsilon."), this);
            }
            this.packages.add(ePackage);
            EmfUtil.collectDependencies(ePackage, this.packages);
        }
    }

    @Override
    public boolean hasPackage(String packageName) {
        return this.packageForName(packageName) != null;
    }

    private EPackage packageForName(String name) {
        String[] parts = name.split("::");
        int partIndex = 0;
        EPackage current = null;
        Collection<EPackage> next = this.getTopLevelPackages();
        do {
            if ((current = this.packageForName(parts[partIndex++], next)) == null) continue;
            next = current.getESubpackages();
        } while (current != null && partIndex < parts.length);
        return current;
    }

    private Collection<EPackage> getTopLevelPackages() {
        LinkedList<EPackage> packages = new LinkedList<EPackage>();
        for (Object pkg : this.getPackageRegistry().values()) {
            if (!(pkg instanceof EPackage)) continue;
            packages.add((EPackage)pkg);
        }
        return packages;
    }

    private EPackage packageForName(String name, Collection<EPackage> packages) {
        for (EPackage p : packages) {
            if (!name.equals(p.getName())) continue;
            return p;
        }
        return null;
    }

    private EList<EStructuralFeature> featuresForType(String type) throws EolModelElementTypeNotFoundException {
        return this.classForName(type).getEAllStructuralFeatures();
    }

    private List<URI> toURIList(String commaSeparatedList) {
        ArrayList<URI> list = new ArrayList<URI>();
        String[] stringArray = commaSeparatedList.trim().split("\\s*,\\s*");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.length() > 0) {
                list.add(URI.createURI(s));
            }
            ++n2;
        }
        return list;
    }

    static class PropertyMigrator {
        PropertyMigrator() {
        }

        public static void migrateDeprecatedProperties(StringProperties properties) {
            PropertyMigrator.migrateModelFileProperty(properties);
            PropertyMigrator.migrateMetamodelFileProperty(properties);
        }

        private static void migrateModelFileProperty(StringProperties properties) {
            PropertyMigrator.migrateUriValue(properties, EmfModel.PROPERTY_MODEL_FILE, EmfModel.PROPERTY_MODEL_URI);
        }

        private static void migrateMetamodelFileProperty(StringProperties properties) {
            PropertyMigrator.migrateUriValue(properties, EmfModel.PROPERTY_METAMODEL_FILE, EmfModel.PROPERTY_FILE_BASED_METAMODEL_URI);
        }

        private static void migrateUriValue(StringProperties properties, String oldProperty, String newProperty) {
            if (properties.hasValueFor(oldProperty) && !properties.hasValueFor(newProperty)) {
                String oldValue = properties.getProperty(oldProperty);
                File oldFile = new File(oldValue);
                if (oldFile.canRead() || oldFile.getParentFile() != null && oldFile.getParentFile().canRead()) {
                    properties.put(newProperty, EmfUtil.createFileBasedURI(oldValue));
                } else {
                    properties.put(newProperty, EmfUtil.createPlatformResourceURI(oldValue));
                }
            }
        }
    }
}

