/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf.m0;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.emc.emf.EmfModel;
import org.eclipse.epsilon.eol.EolModule;
import org.eclipse.epsilon.eol.EolOperation;
import org.eclipse.epsilon.eol.IEolModule;
import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.execute.introspection.AbstractPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.AbstractPropertySetter;
import org.eclipse.epsilon.eol.execute.introspection.IPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.IReflectivePropertySetter;

public class EmfM0Model
extends EmfModel {
    protected File m0SpecificationFile;
    protected IEolModule eolModule;

    @Override
    public void load(StringProperties properties, String basePath) throws EolModelLoadingException {
        this.name = properties.getProperty("name");
        String[] aliases = properties.getProperty("aliases").split(",");
        int i = 0;
        while (i < aliases.length) {
            this.aliases.add(aliases[i].trim());
            ++i;
        }
        this.setMetamodelFile(properties.getProperty("metamodelFile"));
        this.setMetamodelUri(properties.getProperty("metamodelUri"));
        this.isMetamodelFileBased = Boolean.parseBoolean(properties.getProperty("isMetamodelFileBased"));
        this.m0SpecificationFile = new File(String.valueOf(basePath) + properties.getProperty("m0SpecificationFile"));
        this.readOnLoad = Boolean.parseBoolean(properties.getProperty("readOnLoad"));
        this.storeOnDisposal = Boolean.parseBoolean(properties.getProperty("storeOnDisposal"));
        this.load();
    }

    @Override
    protected void loadModel() throws EolModelLoadingException {
        super.loadModel();
        this.eolModule = new EolModule();
        try {
            this.eolModule.parse(this.m0SpecificationFile);
            this.eolModule.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        EmfModel copy = new EmfModel();
        copy.getAliases().addAll(this.getAliases());
        copy.setMetamodelFiles(this.getMetamodelFiles());
        copy.setMetamodelUris(this.getMetamodelUris());
        copy.setModelFile(this.getModelFile());
        copy.setMetamodelFileBased(this.isMetamodelFileBased());
        copy.setModelImpl(this.getModelImpl());
        copy.setReadOnLoad(this.isReadOnLoad());
        copy.setStoredOnDisposal(this.isStoredOnDisposal());
        copy.setName("Model");
        this.eolModule.getContext().getModelRepository().addModel(copy);
    }

    public EolOperation getHelper(String name) {
        ListIterator li = this.eolModule.getDeclaredOperations().listIterator();
        while (li.hasNext()) {
            EolOperation helper = (EolOperation)li.next();
            if (!helper.getName().equals(name)) continue;
            return helper;
        }
        return null;
    }

    @Override
    public IPropertyGetter getPropertyGetter() {
        return new EmfM0PropertyGetter();
    }

    @Override
    public IReflectivePropertySetter getPropertySetter() {
        return new EmfM0PropertySetter();
    }

    @Override
    protected Collection<EObject> getAllOfTypeFromModel(String metaClass) throws EolModelElementTypeNotFoundException {
        EolOperation allOfTypeHelper = this.getHelper("allOfType");
        Collection allOfType = null;
        try {
            allOfType = (Collection)allOfTypeHelper.execute(metaClass, new ArrayList(), this.eolModule.getContext());
        }
        catch (EolRuntimeException rex) {
            this.eolModule.getContext().getErrorStream().print(rex);
        }
        return allOfType;
    }

    @Override
    protected Collection<EObject> getAllOfKindFromModel(String metaClass) throws EolModelElementTypeNotFoundException {
        EolOperation allOfKindHelper = this.getHelper("allOfKind");
        Collection allOfKind = null;
        try {
            allOfKind = (Collection)allOfKindHelper.execute(metaClass, new ArrayList(), this.eolModule.getContext());
        }
        catch (EolRuntimeException rex) {
            this.eolModule.getContext().getErrorStream().print(rex);
        }
        return allOfKind;
    }

    @Override
    public boolean hasType(String type) {
        EolOperation hasTypeHelper = this.getHelper("hasType");
        boolean hasType = false;
        try {
            hasType = (Boolean)hasTypeHelper.execute(type, new ArrayList(), this.eolModule.getContext());
        }
        catch (EolRuntimeException rex) {
            this.eolModule.getContext().getErrorStream().print(rex);
        }
        return hasType;
    }

    public File getM0SpecificationFile() {
        return this.m0SpecificationFile;
    }

    public void setM0SpecificationFile(File specification) {
        this.m0SpecificationFile = specification;
    }

    public IEolModule getEolModule() {
        return this.eolModule;
    }

    public void setEolModule(IEolModule eolModule) {
        this.eolModule = eolModule;
    }

    class EmfM0PropertyGetter
    extends AbstractPropertyGetter {
        EmfM0PropertyGetter() {
        }

        @Override
        public Object invoke(Object object, String property) throws EolRuntimeException {
            ArrayList<String> parameterValues = new ArrayList<String>();
            parameterValues.add(property);
            EolOperation propertyGetter = EmfM0Model.this.eolModule.getDeclaredOperations().getOperation(object, "getProperty", parameterValues, EmfM0Model.this.eolModule.getContext());
            if (propertyGetter != null) {
                return propertyGetter.execute(object, parameterValues, EmfM0Model.this.eolModule.getContext());
            }
            return null;
        }
    }

    class EmfM0PropertySetter
    extends AbstractPropertySetter
    implements IReflectivePropertySetter {
        EmfM0PropertySetter() {
        }

        @Override
        public void invoke(Object value) throws EolRuntimeException {
            ArrayList<Object> parameterValues = new ArrayList<Object>();
            parameterValues.add(this.property);
            parameterValues.add(value);
            EolOperation propertySetter = EmfM0Model.this.eolModule.getDeclaredOperations().getOperation(this.object, "setProperty", parameterValues, EmfM0Model.this.eolModule.getContext());
            if (propertySetter != null) {
                propertySetter.execute(this.object, parameterValues, EmfM0Model.this.eolModule.getContext());
            }
        }

        @Override
        public Object coerce(Object value) throws EolIllegalPropertyException {
            return value;
        }

        @Override
        public boolean conforms(Object value) throws EolIllegalPropertyException {
            return true;
        }
    }
}

