/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.graphml;

import org.eclipse.epsilon.emc.graphml.DomUtil;
import org.jdom.Element;

public class GraphmlConfiguration {
    protected String nodeTypeKey;
    protected String nodePropertiesKey;
    protected String nodeContentsKey;
    protected String nodePrimarySlotPrototypeNameKey;
    protected String edgeTypeKey;
    protected String edgePropertiesKey;
    protected String edgePrimarySlotPrototypeNameKey;
    protected String edgeSourceKey;
    protected String edgeTargetKey;
    protected String edgeRoleInSourceKey;
    protected String edgeRoleInTargetKey;
    protected Element root;

    public GraphmlConfiguration(Element root) {
        this.root = root;
        this.nodeTypeKey = this.getKeyId("Type", "node");
        this.nodePropertiesKey = this.getKeyId("Properties", "node");
        this.nodePrimarySlotPrototypeNameKey = this.getKeyId("Default", "node");
        this.nodeContentsKey = this.getKeyId("Contents", "node");
        this.edgeTypeKey = this.getKeyId("Type", "edge");
        this.edgePropertiesKey = this.getKeyId("Properties", "edge");
        this.edgePrimarySlotPrototypeNameKey = this.getKeyId("Default", "edge");
        this.edgeSourceKey = this.getKeyId("Source", "edge");
        this.edgeTargetKey = this.getKeyId("Target", "edge");
        this.edgeRoleInSourceKey = this.getKeyId("Role in source", "edge");
        this.edgeRoleInTargetKey = this.getKeyId("Role in target", "edge");
    }

    protected String getKeyId(String attrName, String forName) {
        for (Element key : DomUtil.getChildren(this.root, "key")) {
            if (!key.getAttributeValue("attr.name", "").equalsIgnoreCase(attrName) || !key.getAttributeValue("for", "").equals(forName)) continue;
            return key.getAttributeValue("id");
        }
        return null;
    }

    public String getNodePropertiesKey() {
        return this.nodePropertiesKey;
    }

    public String getNodeContentsKey() {
        return this.nodeContentsKey;
    }

    public String getEdgePropertiesKey() {
        return this.edgePropertiesKey;
    }

    public String getNodeTypeKey() {
        return this.nodeTypeKey;
    }

    public String getEdgeTypeKey() {
        return this.edgeTypeKey;
    }

    public String getNodePrimarySlotPrototypeNameKey() {
        return this.nodePrimarySlotPrototypeNameKey;
    }

    public String getEdgePrimarySlotPrototypeNameKey() {
        return this.edgePrimarySlotPrototypeNameKey;
    }

    public String getEdgeSourceKey() {
        return this.edgeSourceKey;
    }

    public String getEdgeTargetKey() {
        return this.edgeTargetKey;
    }

    public String getEdgeRoleInSourceKey() {
        return this.edgeRoleInSourceKey;
    }

    public String getEdgeRoleInTargetKey() {
        return this.edgeRoleInTargetKey;
    }
}

