/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.plainxml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.emc.plainxml.Binding;
import org.eclipse.epsilon.emc.plainxml.DomUtil;
import org.eclipse.epsilon.emc.plainxml.PlainXmlPropertyGetter;
import org.eclipse.epsilon.emc.plainxml.PlainXmlPropertySetter;
import org.eclipse.epsilon.emc.plainxml.PlainXmlType;
import org.eclipse.epsilon.emc.plainxml.StringInputStream;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolEnumerationValueNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.execute.introspection.IPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.IPropertySetter;
import org.eclipse.epsilon.eol.models.CachedModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PlainXmlModel
extends CachedModel<Element> {
    protected Document document;
    protected String uri;
    protected File file;
    protected String xml;
    protected ArrayList<Element> createdElements = new ArrayList();
    protected ArrayList<Binding> bindings = new ArrayList();
    protected static String ELEMENT_TYPE = "Element";
    protected static String DEFAULT_NEW_TAG_NAME = "element";
    public static String PROPERTY_FILE = "file";
    public static String PROPERTY_URI = "uri";

    public static void main(String[] args) throws Exception {
        PlainXmlModel m = new PlainXmlModel();
        m.setXml("<?xml version='1.0'?><foo/>");
        m.load();
        Object x = m.createInstance("t_zoo");
        m.setRoot((Node)x);
        System.err.println(m.getXml());
    }

    public Node getRoot() {
        return this.document.getFirstChild();
    }

    public void setRoot(Node node) {
        Node oldRoot = this.getRoot();
        if (oldRoot != null) {
            this.document.removeChild(oldRoot);
        }
        this.document.appendChild(node);
    }

    @Override
    protected Collection<Element> allContentsFromModel() {
        ArrayList<Element> elements = new ArrayList<Element>();
        this.collectAllElements(this.document, elements);
        for (Element created : this.createdElements) {
            if (elements.contains(created) || created.getParentNode() != null) continue;
            elements.add(created);
        }
        return elements;
    }

    public List<Binding> getBindings() {
        return this.bindings;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getXml() {
        try {
            StringWriter sw = new StringWriter();
            DOMSource xmlSource = new DOMSource(this.document);
            StreamResult result = new StreamResult(sw);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(xmlSource, result);
            return sw.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public Document getDocument() {
        return this.document;
    }

    public void bind(String sourceTag, String sourceAttribute, String targetTag, String targetAttribute, boolean many) {
        this.bindings.add(new Binding(sourceTag, sourceAttribute, targetTag, targetAttribute, many));
    }

    @Override
    protected Element createInstanceInModel(String type) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        return this.createInstance(type, (Collection)Collections.emptyList());
    }

    @Override
    public Element createInstance(String type, Collection<Object> parameters) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        String tagName = null;
        boolean root = false;
        if (ELEMENT_TYPE.equals(type)) {
            tagName = parameters.size() == 1 ? "" + parameters.iterator().next() : DEFAULT_NEW_TAG_NAME;
        } else {
            Object param;
            PlainXmlType plainXmlType = PlainXmlType.parse(type);
            if (plainXmlType != null) {
                tagName = plainXmlType.getTagName();
            }
            if (parameters.size() == 1 && (param = parameters.iterator().next()) instanceof Boolean) {
                root = (Boolean)param;
            }
        }
        Element newElement = this.document.createElement(tagName);
        if (!root) {
            this.createdElements.add(newElement);
        } else {
            this.document.appendChild(newElement);
        }
        return newElement;
    }

    @Override
    protected boolean deleteElementInModel(Object instance) throws EolRuntimeException {
        if (!(instance instanceof Element)) {
            return false;
        }
        Element e = (Element)instance;
        if (e.getParentNode() != null) {
            e.getParentNode().removeChild(e);
        }
        this.createdElements.remove(e);
        for (Element child : DomUtil.getChildren(e)) {
            this.deleteElement(child);
        }
        return true;
    }

    public void collectAllElements(Node root, ArrayList<Element> elements) {
        if (root instanceof Element) {
            elements.add((Element)root);
        }
        NodeList childNodes = root.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node o = childNodes.item(i);
            if (o instanceof Element) {
                this.collectAllElements((Element)o, elements);
            }
            ++i;
        }
    }

    @Override
    protected Collection<Element> getAllOfKindFromModel(String type) throws EolModelElementTypeNotFoundException {
        return this.getAllOfType(type);
    }

    @Override
    protected Collection<Element> getAllOfTypeFromModel(String type) throws EolModelElementTypeNotFoundException {
        if (ELEMENT_TYPE.equals(type)) {
            return this.allContents();
        }
        ArrayList<Element> allOfType = null;
        PlainXmlType plainXmlType = PlainXmlType.parse(type);
        if (plainXmlType == null) {
            throw new EolModelElementTypeNotFoundException(this.getName(), type);
        }
        if (allOfType == null) {
            allOfType = new ArrayList<Element>();
            for (Object o : this.allContents()) {
                Element e = (Element)o;
                if (!e.getTagName().equals(plainXmlType.getTagName())) continue;
                allOfType.add(e);
            }
        }
        return allOfType;
    }

    @Override
    protected void disposeModel() {
    }

    @Override
    public Object getElementById(String id) {
        return null;
    }

    @Override
    public String getElementId(Object instance) {
        return null;
    }

    @Override
    public void setElementId(Object instance, String newId) {
    }

    @Override
    public Object getEnumerationValue(String enumeration, String label) throws EolEnumerationValueNotFoundException {
        return null;
    }

    @Override
    public String getTypeNameOf(Object instance) {
        if (instance instanceof Element) {
            return "t_" + ((Element)instance).getTagName();
        }
        return instance.getClass().getName();
    }

    @Override
    protected Object getCacheKeyForType(String type) throws EolModelElementTypeNotFoundException {
        return type;
    }

    @Override
    protected Collection<String> getAllTypeNamesOf(Object instance) {
        return Collections.singleton(this.getTypeNameOf(instance));
    }

    @Override
    public Object getTypeOf(Object instance) {
        return instance.getClass();
    }

    @Override
    public boolean hasType(String type) {
        return ELEMENT_TYPE.equals(type) || PlainXmlType.parse(type) != null;
    }

    @Override
    public boolean isInstantiable(String type) {
        return this.hasType(type);
    }

    @Override
    public boolean isModelElement(Object instance) {
        return instance instanceof Element;
    }

    @Override
    protected void loadModel() throws EolModelLoadingException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.document = this.readOnLoad ? (this.file != null ? documentBuilder.parse(this.file) : (this.uri != null ? documentBuilder.parse(this.uri) : documentBuilder.parse(new StringInputStream(this.xml)))) : documentBuilder.newDocument();
        }
        catch (Exception ex) {
            throw new EolModelLoadingException(ex, this);
        }
    }

    @Override
    public void load(StringProperties properties, String basePath) throws EolModelLoadingException {
        super.load(properties, basePath);
        String filePath = properties.getProperty(PROPERTY_FILE);
        if (filePath != null && filePath.trim().length() > 0) {
            if (basePath != null) {
                filePath = String.valueOf(basePath) + filePath;
            }
            this.file = new File(filePath);
        } else {
            this.uri = properties.getProperty(PROPERTY_URI);
        }
        this.load();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean owns(Object instance) {
        block1: {
            if (!(instance instanceof Element)) break block1;
            e = (Element)instance;
            parent = e.getParentNode();
            if (parent != null) ** GOTO lbl7
            return this.createdElements.contains(instance);
lbl-1000:
            // 1 sources

            {
                parent = parent.getParentNode();
lbl7:
                // 2 sources

                ** while (parent.getParentNode() != null)
            }
lbl8:
            // 1 sources

            return parent == this.document || this.createdElements.contains(parent) != false;
        }
        return false;
    }

    @Override
    public boolean store(String location) {
        try {
            DOMSource xmlSource = new DOMSource(this.document);
            StreamResult result = new StreamResult(new FileOutputStream(location));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(xmlSource, result);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean store() {
        if (this.file != null) {
            return this.store(this.file.getAbsolutePath());
        }
        return this.store(this.uri);
    }

    @Override
    public IPropertyGetter getPropertyGetter() {
        return new PlainXmlPropertyGetter(this);
    }

    @Override
    public IPropertySetter getPropertySetter() {
        return new PlainXmlPropertySetter(this);
    }
}

