/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.plainxml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epsilon.emc.plainxml.Binding;
import org.eclipse.epsilon.emc.plainxml.BindingMatcher;
import org.eclipse.epsilon.emc.plainxml.DomUtil;
import org.eclipse.epsilon.emc.plainxml.LoudList;
import org.eclipse.epsilon.emc.plainxml.LoudListChangeListener;
import org.eclipse.epsilon.emc.plainxml.PlainXmlModel;
import org.eclipse.epsilon.emc.plainxml.PlainXmlProperty;
import org.eclipse.epsilon.emc.plainxml.TagMatcher;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.introspection.java.JavaPropertyGetter;
import org.w3c.dom.Element;

public class PlainXmlPropertyGetter
extends JavaPropertyGetter {
    protected PlainXmlModel model;

    public PlainXmlPropertyGetter(PlainXmlModel model) {
        this.model = model;
    }

    @Override
    public Object invoke(Object object, String property) throws EolRuntimeException {
        if (object instanceof Element) {
            final Element e = (Element)object;
            if ("children".equals(property)) {
                return DomUtil.getChildren(e);
            }
            if ("text".equals(property)) {
                return e.getTextContent();
            }
            if ("parent".equals(property)) {
                if (e.getParentNode() instanceof Element) {
                    return e.getParentNode();
                }
                return null;
            }
            PlainXmlProperty p = PlainXmlProperty.parse(property);
            if (p != null) {
                if (p.isAttribute()) {
                    return p.cast(e.getAttribute(p.getProperty()));
                }
                if (p.isText()) {
                    return p.cast(e.getTextContent());
                }
                if (p.isReference()) {
                    for (final Binding binding : BindingMatcher.getMatchingBindings(this.model, e, p.getProperty())) {
                        if (binding.isMany()) {
                            LoudList<Element> referenced = new LoudList<Element>();
                            String[] referencedIds = e.getAttribute(p.getProperty()).split(",");
                            for (Object o : this.model.allContents()) {
                                Element candidate = (Element)o;
                                if (!TagMatcher.matches(candidate, binding.getTargetTag())) continue;
                                String[] stringArray = referencedIds;
                                int n = referencedIds.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String referencedId = stringArray[n2];
                                    if (candidate.getAttribute(binding.getTargetAttribute()).equals(referencedId.trim())) {
                                        referenced.add(candidate);
                                    }
                                    ++n2;
                                }
                            }
                            referenced.addListener(new LoudListChangeListener<Element>(){

                                @Override
                                public void listChanged(LoudList<Element> list) {
                                    String newAttributeValue = "";
                                    Iterator li = list.iterator();
                                    while (li.hasNext()) {
                                        Element i = (Element)li.next();
                                        newAttributeValue = String.valueOf(newAttributeValue) + i.getAttribute(binding.getTargetAttribute());
                                        if (!li.hasNext()) continue;
                                        newAttributeValue = String.valueOf(newAttributeValue) + ", ";
                                    }
                                    e.setAttribute(binding.getSourceAttribute(), newAttributeValue);
                                }
                            });
                            return referenced;
                        }
                        String referencedId = e.getAttribute(p.getProperty());
                        for (Object o : this.model.allContents()) {
                            Element candidate = (Element)o;
                            if (!candidate.getTagName().matches(binding.getTargetTag()) || !candidate.getAttribute(binding.getTargetAttribute()).equals(referencedId.trim())) continue;
                            return candidate;
                        }
                    }
                } else {
                    List<Element> children = DomUtil.getChildren(e);
                    ArrayList<Element> result = new ArrayList<Element>();
                    for (Element child : children) {
                        if (!child.getTagName().equals(p.getProperty())) continue;
                        result.add(child);
                    }
                    if (p.isMany()) {
                        return result;
                    }
                    if (result.size() > 0) {
                        return result.get(0);
                    }
                    return null;
                }
            }
        }
        return super.invoke(object, property);
    }
}

