/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.plainxml;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.epsilon.emc.plainxml.Binding;
import org.eclipse.epsilon.emc.plainxml.PlainXmlModel;
import org.eclipse.epsilon.emc.plainxml.PlainXmlProperty;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.introspection.java.JavaPropertySetter;
import org.eclipse.epsilon.eol.execute.operations.contributors.IterableOperationContributor;
import org.w3c.dom.Element;

public class PlainXmlPropertySetter
extends JavaPropertySetter {
    protected PlainXmlModel model = null;

    public PlainXmlPropertySetter(PlainXmlModel model) {
        this.model = model;
    }

    @Override
    public void invoke(Object value) throws EolRuntimeException {
        if (this.object instanceof Element) {
            Element e = (Element)this.object;
            if ("text".equals(this.property)) {
                e.setTextContent(String.valueOf(value));
                return;
            }
            PlainXmlProperty p = PlainXmlProperty.parse(this.property);
            if (p != null) {
                if (p.isAttribute()) {
                    e.setAttribute(p.getProperty(), "" + p.cast(String.valueOf(value)));
                    return;
                }
                if (p.isText()) {
                    e.setTextContent("" + p.cast(String.valueOf(value)));
                    return;
                }
                if (p.isReference()) {
                    String sourceTag = e.getTagName();
                    for (Binding binding : this.model.getBindings()) {
                        String referenceId;
                        Element candidate;
                        if (!sourceTag.matches(binding.getSourceTag()) || !p.getProperty().matches(binding.getSourceAttribute())) continue;
                        String sourceAttribute = p.getProperty();
                        if (binding.isMany()) {
                            ArrayList<String> referenceIds = new ArrayList<String>();
                            ArrayList<Object> values = null;
                            if (value instanceof Collection) {
                                values = (ArrayList<Object>)value;
                            } else {
                                values = new ArrayList<Object>();
                                values.add(value);
                            }
                            for (Object e2 : values) {
                                String referenceId2;
                                Element candidate2 = (Element)e2;
                                if (!candidate2.getTagName().matches(binding.getTargetTag()) || (referenceId2 = candidate2.getAttribute(binding.getTargetAttribute())) == null || referenceId2.trim().length() <= 0) continue;
                                referenceIds.add(referenceId2);
                            }
                            e.setAttribute(sourceAttribute, new IterableOperationContributor(referenceIds).concat(", "));
                            return;
                        }
                        if (!(value instanceof Element) || !(candidate = (Element)value).getTagName().matches(binding.getTargetTag()) || (referenceId = candidate.getAttribute(binding.getTargetAttribute())) == null || referenceId.trim().length() <= 0) continue;
                        e.setAttribute(sourceAttribute, referenceId);
                        return;
                    }
                }
            }
        }
        super.invoke(value);
    }
}

