/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol;

import java.io.File;
import org.eclipse.epsilon.eol.EolModule;
import org.eclipse.epsilon.eol.IEolModule;
import org.eclipse.epsilon.eol.exceptions.EolEvaluatorException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.models.IModel;

public class EolEvaluator {
    private final IEolModule module = new EolModule();
    private boolean statementsExecuted = false;

    public EolEvaluator(IModel ... models) {
        IModel[] iModelArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IModel model = iModelArray[n2];
            this.module.getContext().getModelRepository().addModel(model);
            ++n2;
        }
    }

    public IEolContext getContext() {
        return this.module.getContext();
    }

    public void dispose() {
        try {
            this.getContext().getModelRepository().dispose();
            this.getContext().dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Object executeInteral(String statement) {
        this.statementsExecuted = true;
        try {
            if (this.module.parse(statement)) {
                return this.module.execute();
            }
            throw new EolEvaluatorException(this.module.getParseProblems());
        }
        catch (Exception e) {
            throw new EolEvaluatorException("Could not execute '" + statement + "'", e);
        }
    }

    private static String asEolStatement(Object o) {
        return "return " + o.toString() + ";";
    }

    public Object evaluate(Object o) {
        return this.executeInteral(EolEvaluator.asEolStatement(o));
    }

    public void execute(String statement) {
        this.executeInteral(statement);
    }

    public void setVariable(String name, String eolStatement) {
        this.setVariable(name, this.evaluate(eolStatement));
    }

    public void setVariable(String name, Object value) {
        this.module.getContext().getFrameStack().put(Variable.createReadOnlyVariable(name, value));
    }

    public void importFile(File file) {
        if (this.statementsExecuted) {
            throw new IllegalStateException("Cannot import files after calls to execute, evaluate or setVariable have occurred");
        }
        try {
            if (this.module.parse("import '" + file.getAbsolutePath() + "';") && this.module.getParseProblems().isEmpty()) {
                return;
            }
        }
        catch (Exception e) {
            throw new EolEvaluatorException("Could not import: " + file.getAbsolutePath(), e);
        }
        throw new EolEvaluatorException("Errors when parsing: " + file.getAbsolutePath() + "-" + this.module.getParseProblems());
    }
}

