/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.TokenStream;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.EpsilonParser;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.common.util.ListSet;
import org.eclipse.epsilon.eol.AbstractModule;
import org.eclipse.epsilon.eol.EolImport;
import org.eclipse.epsilon.eol.EolModelDefinition;
import org.eclipse.epsilon.eol.EolModelGroupDefinition;
import org.eclipse.epsilon.eol.EolModule;
import org.eclipse.epsilon.eol.EolOperation;
import org.eclipse.epsilon.eol.EolOperationFactory;
import org.eclipse.epsilon.eol.EolOperations;
import org.eclipse.epsilon.eol.EolSystem;
import org.eclipse.epsilon.eol.IEolLibraryModule;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.parse.AstExplorer;
import org.eclipse.epsilon.eol.parse.EolLexer;
import org.eclipse.epsilon.eol.parse.EolParser;

public abstract class EolLibraryModule
extends AbstractModule
implements IEolLibraryModule {
    protected EolOperations declaredOperations = new EolOperations();
    protected List<EolImport> imports = new ArrayList<EolImport>();
    protected EolOperations operations = null;
    protected List<EolModelDefinition> declaredModelDefinitions = new ArrayList<EolModelDefinition>();
    protected List<EolModelGroupDefinition> declaredModelGroupDefinitions = new ArrayList<EolModelGroupDefinition>();
    protected Set<EolModelDefinition> modelDefinitions = null;
    protected Set<EolModelGroupDefinition> modelGroupDefinitions = null;
    protected EolOperationFactory operationFactory = new EolOperationFactory();
    private IEolLibraryModule parent;

    public static void main(String[] args) throws Exception {
        EolModule module = new EolModule();
        module.parse("if (true) transaction { a = 5; abort;}");
        new AstExplorer(module.getAst(), EolParser.class).setVisible(true);
    }

    @Override
    public Lexer createLexer(InputStream inputStream) {
        ANTLRInputStream input = null;
        try {
            input = new ANTLRInputStream(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new EolLexer(input);
    }

    @Override
    public EpsilonParser createParser(TokenStream tokenStream) {
        return new EolParser(tokenStream);
    }

    @Override
    public String getMainRule() {
        return "eolModule";
    }

    @Override
    public EolOperations getDeclaredOperations() {
        return this.declaredOperations;
    }

    public HashMap<String, Class<?>> getImportConfiguration() {
        HashMap importConfiguration = new HashMap();
        importConfiguration.put("eol", EolModule.class);
        return importConfiguration;
    }

    @Override
    public void buildModel() throws Exception {
        this.checkImports();
        for (String extension : this.getImportConfiguration().keySet()) {
            this.imports.addAll(this.getImportsByExtension(extension, this.getImportConfiguration().get(extension)));
        }
        for (AST helperAst : AstUtil.getChildren(this.ast, 28)) {
            EolOperation helper = this.operationFactory.createOperation(helperAst);
            this.declaredOperations.add(helper);
        }
    }

    protected void prepareContext(IEolContext context) {
        EolSystem system = new EolSystem();
        system.setContext(context);
        context.setModule(this);
        for (EolImport import_ : this.getImports()) {
            import_.setContext(context);
        }
        context.getFrameStack().putGlobal(Variable.createReadOnlyVariable("null", null));
        context.getFrameStack().putGlobal(Variable.createReadOnlyVariable("System", system));
    }

    @Override
    public void reset() {
        this.imports.clear();
        this.declaredOperations.clear();
        this.operations = null;
    }

    @Override
    public AST getAst() {
        return this.ast;
    }

    @Override
    public List<ModuleElement> getChildren() {
        ArrayList<ModuleElement> children = new ArrayList<ModuleElement>();
        children.addAll(this.imports);
        children.addAll(this.declaredOperations);
        return children;
    }

    @Override
    public File getSourceFile() {
        return this.sourceFile;
    }

    @Override
    public List<EolImport> getImports() {
        return this.imports;
    }

    public String toString() {
        if (this.sourceFile != null) {
            return this.sourceFile.getAbsolutePath();
        }
        return super.toString();
    }

    @Override
    public Set<EolModelDefinition> getModelDefinitions() {
        if (this.modelDefinitions == null) {
            this.modelDefinitions = new ListSet<EolModelDefinition>();
            for (EolImport import_ : this.imports) {
                if (!import_.isLoaded() || !(import_.getModule() instanceof IEolLibraryModule)) continue;
                this.modelDefinitions.addAll(((IEolLibraryModule)import_.getModule()).getModelDefinitions());
            }
            this.modelDefinitions.addAll(this.getDeclaredModelDefinitions());
        }
        return this.modelDefinitions;
    }

    @Override
    public EolOperations getOperations() {
        if (this.operations == null) {
            this.operations = new EolOperations();
            this.operations.addAll(this.getDeclaredOperations());
            for (EolImport import_ : this.imports) {
                if (!import_.isLoaded() || !(import_.getModule() instanceof IEolLibraryModule)) continue;
                this.operations.addAll(((IEolLibraryModule)import_.getModule()).getOperations());
            }
        }
        return this.operations;
    }

    protected Collection<EolImport> getImportsByExtension(String extension, Class<?> moduleImplClass) {
        ArrayList<EolImport> imports = new ArrayList<EolImport>();
        for (AST importAst : AstUtil.getChildren(this.ast, 65)) {
            EolImport import_;
            IModule module;
            block8: {
                module = null;
                try {
                    module = (IModule)moduleImplClass.newInstance();
                    if (!(module instanceof IEolLibraryModule)) break block8;
                    ((IEolLibraryModule)module).setParentModule(this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (!(import_ = new EolImport(importAst, this, module)).getPath().endsWith("." + extension)) continue;
            if (this.sourceUri == null && this.sourceFile == null) {
                import_.load(null);
            } else if (this.sourceUri != null) {
                import_.load(this.sourceUri);
            } else {
                import_.load(this.sourceFile.toURI());
            }
            if (!import_.isLoaded()) {
                ParseProblem problem = new ParseProblem();
                problem.setLine(importAst.getLine());
                String reason = !import_.isFound() ? "File " + importAst.getFirstChild().getText() + " not found" : "File " + importAst.getFirstChild().getText() + " contains errors: " + import_.getModule().getParseProblems();
                problem.setReason(reason);
                this.getParseProblems().add(problem);
            }
            imports.add(import_);
        }
        return imports;
    }

    protected void checkImports() {
        for (AST importAst : AstUtil.getChildren(this.ast, 65)) {
            String importedFile = importAst.getFirstChild().getText();
            boolean validExtension = false;
            for (String extension : this.getImportConfiguration().keySet()) {
                if (!importedFile.endsWith("." + extension)) continue;
                validExtension = true;
            }
            if (validExtension) continue;
            ParseProblem problem = new ParseProblem();
            problem.setLine(importAst.getLine());
            problem.setReason("Importing " + importAst.getFirstChild().getText() + " is not supported in this language");
            problem.setSeverity(1);
            this.getParseProblems().add(problem);
        }
    }

    @Override
    public List<EolModelDefinition> getDeclaredModelDefinitions() {
        return this.declaredModelDefinitions;
    }

    @Override
    public List<EolModelGroupDefinition> getDeclaredModelGroupDefinitions() {
        return this.declaredModelGroupDefinitions;
    }

    @Override
    public Set<EolModelGroupDefinition> getModelGroupDefinitions() {
        if (this.modelGroupDefinitions == null) {
            this.modelGroupDefinitions = new ListSet<EolModelGroupDefinition>();
            for (EolImport import_ : this.imports) {
                if (!import_.isLoaded() || !(import_.getModule() instanceof IEolLibraryModule)) continue;
                this.modelGroupDefinitions.addAll(((IEolLibraryModule)import_.getModule()).getModelGroupDefinitions());
            }
            this.modelGroupDefinitions.addAll(this.getDeclaredModelGroupDefinitions());
        }
        return this.modelGroupDefinitions;
    }

    @Override
    public EolOperationFactory getOperationFactory() {
        return this.operationFactory;
    }

    @Override
    public void setOperationFactory(EolOperationFactory operationFactory) {
        this.operationFactory = operationFactory;
    }

    @Override
    public IEolLibraryModule getParentModule() {
        return this.parent;
    }

    @Override
    public void setParentModule(IEolLibraryModule parent) {
        this.parent = parent;
    }
}

