/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute;

import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.EolTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.EolUndefinedVariableException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelNotFoundException;
import org.eclipse.epsilon.eol.execute.AbstractExecutor;
import org.eclipse.epsilon.eol.execute.ContextlessOperationExecutor;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.types.EolModelElementType;
import org.eclipse.epsilon.eol.types.EolType;

public class NameExecutor
extends AbstractExecutor {
    public Object execute(AST ast, IEolContext context, boolean returnVariable) throws EolRuntimeException {
        String name = ast.getText();
        Variable variable = null;
        FrameStack scope = context.getFrameStack();
        if (ast.getFirstChild() != null && ast.getFirstChild().getType() == 46) {
            return new ContextlessOperationExecutor().execute(ast, context);
        }
        variable = scope.get(name);
        if (variable != null && variable.getDeprecationInfo() != null) {
            context.getWarningStream().println("Warning: " + variable.getDeprecationInfo().getMessage());
        }
        if (variable == null && name.indexOf("!") > -1) {
            variable = this.getModelElementType(name, context);
        }
        if (variable == null) {
            try {
                IModel model = context.getModelRepository().getModelByName(name);
                if (model != null) {
                    variable = Variable.createReadOnlyVariable(name, model);
                }
            }
            catch (EolModelNotFoundException model) {
                // empty catch block
            }
        }
        if (variable == null) {
            try {
                AbstractExecutor typeExecutor = context.getExecutorFactory().getExecutorFor(63);
                EolType type = (EolType)typeExecutor.execute(ast, context);
                if (type != null) {
                    variable = Variable.createReadOnlyVariable(type.getName(), type);
                }
            }
            catch (EolTypeNotFoundException eolTypeNotFoundException) {
                // empty catch block
            }
        }
        if (variable == null) {
            throw new EolUndefinedVariableException(name, ast);
        }
        if (returnVariable) {
            return variable;
        }
        return variable.getValue();
    }

    @Override
    public Object execute(AST ast, IEolContext context) throws EolRuntimeException {
        return this.execute(ast, context, false);
    }

    public Variable getModelElementType(String name, IEolContext context) {
        try {
            EolModelElementType type = null;
            type = EolModelElementType.forName(name, context);
            return Variable.createReadOnlyVariable(name, type);
        }
        catch (EolRuntimeException rex) {
            return null;
        }
    }
}

