/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations;

import java.util.HashMap;
import org.eclipse.epsilon.eol.execute.operations.AbstractOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.AggregateOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.AsOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.ClosureOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.CollectOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.ExistsOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.FindOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.ForAllOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.MapByOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.OneOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.RejectOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.SelectOneOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.SelectOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.SortByOperation;
import org.eclipse.epsilon.eol.execute.operations.simple.assertions.AssertErrorOperation;
import org.eclipse.epsilon.eol.execute.operations.simple.assertions.AssertOperation;

public class OperationFactory {
    protected HashMap<String, AbstractOperation> operationCache = new HashMap();

    public OperationFactory() {
        this.createCache();
    }

    protected void createCache() {
        this.operationCache.put("assert", new AssertOperation());
        this.operationCache.put("assertError", new AssertErrorOperation());
        this.operationCache.put("collect", new CollectOperation());
        this.operationCache.put("exists", new ExistsOperation());
        this.operationCache.put("one", new OneOperation());
        this.operationCache.put("forAll", new ForAllOperation());
        this.operationCache.put("reject", new RejectOperation());
        this.operationCache.put("select", new SelectOperation());
        this.operationCache.put("aggregate", new AggregateOperation());
        this.operationCache.put("selectOne", new SelectOneOperation());
        this.operationCache.put("closure", new ClosureOperation());
        this.operationCache.put("sortBy", new SortByOperation());
        this.operationCache.put("mapBy", new MapByOperation());
        this.operationCache.put("as", new AsOperation());
        this.operationCache.put("find", new FindOperation());
    }

    public AbstractOperation getOperationFor(String name) {
        return this.operationCache.get(name);
    }
}

