/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.declarative;

import java.util.Collection;
import java.util.List;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.execute.operations.declarative.IteratorOperation;
import org.eclipse.epsilon.eol.types.EolType;

public class ClosureOperation
extends IteratorOperation {
    public void closure(Collection<?> source, String iteratorName, EolType iteratorType, AST expressionAST, IEolContext context, Collection<Object> closure) throws EolRuntimeException {
        FrameStack scope = context.getFrameStack();
        for (Object listItem : source) {
            if (iteratorType != null && !iteratorType.isKind(listItem)) continue;
            scope.enterLocal(FrameType.UNPROTECTED, expressionAST, new Variable[0]);
            scope.put(Variable.createReadOnlyVariable(iteratorName, listItem));
            Object bodyResult = context.getExecutorFactory().executeAST(expressionAST, context);
            if (bodyResult != null) {
                for (Object result : CollectionUtil.asCollection(bodyResult)) {
                    if (result == null || closure.contains(result)) continue;
                    closure.add(result);
                    this.closure(CollectionUtil.asCollection(bodyResult), iteratorName, iteratorType, expressionAST, context, closure);
                }
            }
            scope.leaveLocal(expressionAST);
        }
    }

    @Override
    public Object execute(Object target, Variable iterator, AST expressionAst, IEolContext context) throws EolRuntimeException {
        Collection<?> source = CollectionUtil.asCollection(target);
        List<Object> result = CollectionUtil.createDefaultList();
        this.closure(source, iterator.getName(), iterator.getType(), expressionAst, context, result);
        return result;
    }
}

