/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.declarative;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.operations.declarative.CollectOperation;
import org.eclipse.epsilon.eol.execute.prettyprinting.PrettyPrinterManager;
import org.eclipse.epsilon.eol.types.EolSequence;
import org.eclipse.epsilon.eol.types.NumberUtil;

public class SortByOperation
extends CollectOperation {
    @Override
    public Object execute(Object obj, AST operationAst, IEolContext context) throws EolRuntimeException {
        List<?> source = CollectionUtil.asList(obj);
        List<?> collected = CollectionUtil.asList(super.execute(obj, operationAst, context));
        ArrayList<DecoratedObject> decoratedObjects = new ArrayList<DecoratedObject>();
        int index = 0;
        while (index < collected.size()) {
            decoratedObjects.add(new DecoratedObject(source.get(index), collected.get(index)));
            ++index;
        }
        Collections.sort(decoratedObjects, new DecoratedObjectComparator(context.getPrettyPrinterManager()));
        EolSequence result = new EolSequence();
        int index2 = 0;
        while (index2 < collected.size()) {
            result.add(((DecoratedObject)decoratedObjects.get(index2)).getObject());
            ++index2;
        }
        return result;
    }

    class DecoratedObject {
        protected Object object;
        protected Object decoration;

        public DecoratedObject(Object object, Object decoration) {
            this.object = object;
            this.decoration = decoration;
        }

        public Object getObject() {
            return this.object;
        }

        public void setObject(Object object) {
            this.object = object;
        }

        public Object getDecoration() {
            return this.decoration;
        }

        public void setDecoration(Object decoration) {
            this.decoration = decoration;
        }
    }

    class DecoratedObjectComparator
    implements Comparator<DecoratedObject> {
        protected PrettyPrinterManager p;

        public DecoratedObjectComparator(PrettyPrinterManager p) {
            this.p = p;
        }

        @Override
        public int compare(DecoratedObject do1, DecoratedObject do2) {
            Object o1 = do1.getDecoration();
            Object o2 = do2.getDecoration();
            if (o1 instanceof Number && o2 instanceof Number) {
                if (NumberUtil.greaterThan((Number)o2, (Number)o1)) {
                    return -1;
                }
                if (NumberUtil.greaterThan((Number)o1, (Number)o2)) {
                    return 1;
                }
                return 0;
            }
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            String str1 = this.p.print(o1);
            String str2 = this.p.print(o2);
            return str1.compareTo(str2);
        }
    }
}

