/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.prettyprinting;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.epsilon.common.util.StringUtil;
import org.eclipse.epsilon.eol.execute.introspection.IUndefined;
import org.eclipse.epsilon.eol.execute.prettyprinting.PrettyPrinter;
import org.eclipse.epsilon.eol.execute.prettyprinting.PrettyPrinterManager;
import org.eclipse.epsilon.eol.types.EolCollectionType;
import org.eclipse.epsilon.eol.types.EolMap;
import org.eclipse.epsilon.eol.types.EolNoType;

public class DefaultPrettyPrinter
implements PrettyPrinter {
    protected PrettyPrinterManager manager = null;
    protected int maximumCollectionSize = 100;

    public DefaultPrettyPrinter(PrettyPrinterManager manager) {
        this.manager = manager;
    }

    @Override
    public boolean appliesTo(Object o) {
        return true;
    }

    @Override
    public String print(Object o) {
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            String result = String.valueOf(EolCollectionType.getTypeName(c)) + " {";
            if (c.size() > this.maximumCollectionSize) {
                result = String.valueOf(result) + " ... large collection with more than " + this.maximumCollectionSize + " elements ... ";
            } else {
                Iterator li = c.iterator();
                while (li.hasNext()) {
                    Object next = li.next();
                    result = String.valueOf(result) + this.manager.print(next);
                    if (!li.hasNext()) continue;
                    result = String.valueOf(result) + ", ";
                }
            }
            result = String.valueOf(result) + "}";
            return result;
        }
        if (o instanceof EolMap) {
            String simpleClassName = o.getClass().getSimpleName();
            String result = String.valueOf(simpleClassName.substring(3, simpleClassName.length())) + " {";
            Iterator li = ((EolMap)o).keySet().iterator();
            while (li.hasNext()) {
                Object key = li.next();
                Object value = ((EolMap)o).get(key);
                result = String.valueOf(result) + this.manager.print(key) + "->" + this.manager.print(value);
                if (!li.hasNext()) continue;
                result = String.valueOf(result) + ", ";
            }
            result = String.valueOf(result) + "}";
            return result;
        }
        if (o instanceof IUndefined || o instanceof EolNoType.EolNoTypeInstance) {
            return "";
        }
        return StringUtil.toString(o);
    }

    public int getMaximumCollectionSize() {
        return this.maximumCollectionSize;
    }

    public void setMaximumCollectionSize(int maximumCollectionSize) {
        this.maximumCollectionSize = maximumCollectionSize;
    }
}

