/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.parse;

import java.awt.Component;
import java.awt.SystemColor;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.StringUtil;

public class OldAstViewer
extends JFrame {
    JTree tree = new JTree();

    public OldAstViewer(AST ast) {
        this.tree.setModel(new ASTModel(ast));
        this.tree.setCellRenderer(new ASTTreeCellRenderer());
        this.getContentPane().add(new JScrollPane(this.tree));
        this.setTitle("AST Viewer");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 500, 500);
        this.setVisible(true);
    }

    class ASTModel
    implements TreeModel {
        private AST ast = null;

        public ASTModel(AST ast) {
            this.ast = ast;
        }

        public AST toAST(Object o) {
            return (AST)o;
        }

        @Override
        public Object getRoot() {
            return this.ast;
        }

        @Override
        public Object getChild(Object arg0, int arg1) {
            AST child = this.toAST(arg0).getFirstChild();
            int i = 0;
            while (i < arg1) {
                if ((child = child.getNextSibling()) == null) {
                    return ((AST)arg0).getAnnotationsAst();
                }
                ++i;
            }
            return child;
        }

        @Override
        public int getChildCount(Object arg0) {
            if (((AST)arg0).getAnnotationsAst() != null) {
                return this.toAST(arg0).getNumberOfChildren() + 1;
            }
            return this.toAST(arg0).getNumberOfChildren();
        }

        @Override
        public boolean isLeaf(Object arg0) {
            return this.toAST(arg0).getNumberOfChildren() == 0;
        }

        @Override
        public void valueForPathChanged(TreePath arg0, Object arg1) {
        }

        @Override
        public int getIndexOfChild(Object arg0, Object arg1) {
            return 0;
        }

        @Override
        public void addTreeModelListener(TreeModelListener arg0) {
        }

        @Override
        public void removeTreeModelListener(TreeModelListener arg0) {
        }
    }

    class ASTTreeCellRenderer
    implements TreeCellRenderer {
        ASTTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree arg0, Object arg1, boolean selected, boolean expanded, boolean leaf, int row, boolean arg6) {
            JLabel label = new JLabel();
            AST ast = (AST)arg1;
            if (selected) {
                label.setOpaque(true);
                label.setBackground(SystemColor.activeCaption);
                label.setForeground(SystemColor.activeCaptionText);
            }
            label.setIcon(new ImageIcon(ASTTreeCellRenderer.class.getResource("node.gif")));
            label.setText("<html>" + this.getText(ast) + " (" + ast.getType() + ")" + "<font color='#C0C0C0'>" + " (Line:" + ast.getLine() + ",Col:" + ast.getColumn() + ")" + "</font>" + "</html>");
            return label;
        }

        private String getText(AST ast) {
            String str = StringUtil.escapeHtml(ast.getText());
            str = str.replaceAll("\r", "<font color='#336699'>\\\\r</font>");
            str = str.replaceAll("\n", "<font color='#336699'>\\\\n</font>");
            str = str.replaceAll("\t", "<font color='#336699'>\\\\t</font>");
            return str;
        }
    }
}

