/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class LazyIntegerList
implements List<Integer> {
    protected int min;
    protected int max;

    public static void main(String[] args) {
        LazyIntegerList list = new LazyIntegerList(10, 5);
        ListIterator<Integer> li = list.listIterator();
        System.err.println(list.get(10));
    }

    public LazyIntegerList(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean add(Integer e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, Integer element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends Integer> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Integer)) {
            return false;
        }
        Integer i = (Integer)o;
        if (this.min <= this.max) {
            return this.min <= i && i <= this.max;
        }
        return this.max <= i && i <= this.min;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return this.size() > 0;
    }

    @Override
    public Integer get(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        if (this.min <= this.max) {
            return this.min + index;
        }
        return this.min - index;
    }

    @Override
    public int indexOf(Object o) {
        if (!(o instanceof Integer)) {
            return -1;
        }
        Integer i = (Integer)o;
        if (!this.contains(i)) {
            return -1;
        }
        if (this.min <= this.max) {
            return i - this.min;
        }
        return this.min - i;
    }

    @Override
    public boolean isEmpty() {
        return this.size() > 0;
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.listIterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public ListIterator<Integer> listIterator() {
        return new LazyIntegerListIterator(this.min, this.max);
    }

    @Override
    public ListIterator<Integer> listIterator(int index) {
        return null;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer set(int index, Integer element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return Math.abs(this.max - this.min) + 1;
    }

    @Override
    public List<Integer> subList(int fromIndex, int toIndex) {
        return null;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        int j = 0;
        for (int i : this) {
            array[j] = i;
            ++j;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    public class LazyIntegerListIterator
    implements ListIterator<Integer> {
        protected int min;
        protected int max;
        protected int current;

        public LazyIntegerListIterator(int min, int max) {
            this.min = min;
            this.max = max;
            this.current = min <= max ? min - 1 : min + 1;
        }

        @Override
        public void add(Integer arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            if (this.min <= this.max) {
                return this.current < this.max;
            }
            return this.current > this.max;
        }

        @Override
        public boolean hasPrevious() {
            if (this.min <= this.max) {
                return this.current > this.min;
            }
            return this.current < this.max;
        }

        @Override
        public Integer next() {
            if (this.hasNext()) {
                this.current = this.min <= this.max ? ++this.current : --this.current;
                return this.current;
            }
            throw new IllegalStateException();
        }

        @Override
        public int nextIndex() {
            if (this.min <= this.max) {
                return this.current - this.min + 1;
            }
            return this.max - this.current + 1;
        }

        @Override
        public Integer previous() {
            if (this.hasPrevious()) {
                this.current = this.min <= this.max ? --this.current : ++this.current;
                return this.current;
            }
            throw new IllegalStateException();
        }

        @Override
        public int previousIndex() {
            if (this.min <= this.max) {
                return this.current - this.min - 1;
            }
            return this.max - this.current - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Integer arg0) {
            throw new UnsupportedOperationException();
        }
    }
}

