/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.epl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.epsilon.common.module.AbstractModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.epl.NoMatch;
import org.eclipse.epsilon.epl.Role;
import org.eclipse.epsilon.epl.combinations.DynamicList;

public class Domain
extends AbstractModuleElement {
    protected boolean dynamic = false;
    protected Role role;

    public Domain(AST ast, Role role) {
        this.ast = ast;
        this.dynamic = "from".equals(ast.getText());
        this.role = role;
    }

    @Override
    public List<?> getChildren() {
        return Collections.emptyList();
    }

    public DynamicList<Object> getValues(final IEolContext context, final String type) throws EolRuntimeException {
        DynamicList<Object> r = new DynamicList<Object>(){

            @Override
            protected List<Object> getValues() throws Exception {
                if (!Domain.this.role.isActive(context, true)) {
                    return NoMatch.asList();
                }
                ArrayList result = context.getExecutorFactory().executeBlockOrExpressionAst(Domain.this.ast.getFirstChild(), context, Object.class, Collections.emptyList());
                if (!(result instanceof Collection)) {
                    ArrayList results = new ArrayList();
                    results.add(result);
                    result = results;
                }
                ArrayList<Object> filtered = new ArrayList<Object>();
                for (Object o : (Collection)result) {
                    IModel owningModel = context.getModelRepository().getOwningModel(o);
                    if (owningModel == null || !owningModel.isOfKind(o, type)) continue;
                    filtered.add(o);
                }
                return filtered;
            }
        };
        r.setResetable(this.isDynamic());
        return r;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }
}

