/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.epl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.epsilon.common.module.AbstractModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.eol.annotations.EolAnnotationsUtil;
import org.eclipse.epsilon.eol.annotations.EolSimpleAnnotation;
import org.eclipse.epsilon.eol.annotations.IEolAnnotation;
import org.eclipse.epsilon.epl.Role;

public class Pattern
extends AbstractModuleElement {
    protected String name;
    protected List<Role> roles = new ArrayList<Role>();
    protected AST doAst = null;
    protected AST matchAst = null;
    protected AST noMatchAst = null;
    protected AST onMatchAst = null;
    protected int level = 0;

    public Pattern(AST ast) {
        this.ast = ast;
        this.name = ast.getText();
        IEolAnnotation levelAnnotation = EolAnnotationsUtil.getAnnotation(ast, "level");
        if (levelAnnotation != null && levelAnnotation instanceof EolSimpleAnnotation) {
            EolSimpleAnnotation simpleLevelAnnotation = (EolSimpleAnnotation)levelAnnotation;
            this.level = Integer.parseInt(simpleLevelAnnotation.getValue(null));
        }
        this.doAst = AstUtil.getChild(ast, 87);
        if (this.doAst != null) {
            this.doAst = this.doAst.getFirstChild();
        }
        this.matchAst = AstUtil.getChild(ast, 84);
        if (this.matchAst != null) {
            this.matchAst = this.matchAst.getFirstChild();
        }
        this.noMatchAst = AstUtil.getChild(ast, 85);
        if (this.noMatchAst != null) {
            this.noMatchAst = this.noMatchAst.getFirstChild();
        }
        this.onMatchAst = AstUtil.getChild(ast, 86);
        if (this.onMatchAst != null) {
            this.onMatchAst = this.onMatchAst.getFirstChild();
        }
        for (AST roleAst : AstUtil.getChildren(ast, 83)) {
            this.roles.add(new Role(roleAst));
        }
    }

    public String getName() {
        return this.name;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    @Override
    public List<?> getChildren() {
        return Collections.emptyList();
    }

    public AST getMatchAst() {
        return this.matchAst;
    }

    public AST getDoAst() {
        return this.doAst;
    }

    public AST getNoMatchAst() {
        return this.noMatchAst;
    }

    public AST getOnMatchAst() {
        return this.onMatchAst;
    }

    public int getLevel() {
        return this.level;
    }
}

