/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.epl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.epsilon.common.module.AbstractModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.Return;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.types.EolModelElementType;
import org.eclipse.epsilon.eol.types.EolSequence;
import org.eclipse.epsilon.epl.Cardinality;
import org.eclipse.epsilon.epl.Domain;
import org.eclipse.epsilon.epl.Guard;
import org.eclipse.epsilon.epl.NoMatch;
import org.eclipse.epsilon.epl.RuntimeExceptionThrower;
import org.eclipse.epsilon.epl.combinations.DynamicList;

public class Role
extends AbstractModuleElement {
    protected ArrayList<String> names = new ArrayList();
    protected AST typeAst;
    protected Domain domain = null;
    protected Guard guard = null;
    protected EolModelElementType type = null;
    protected boolean negative;
    protected Cardinality cardinality = new Cardinality(1, 1);
    protected AST optionalAst = null;
    protected AST activeAst = null;
    protected boolean isActiveCache = false;

    public Role(AST ast) {
        AST activeAst;
        AST optionalAst;
        AST noAST;
        AST guardAst;
        this.ast = ast;
        for (AST nameAst : AstUtil.getChildren(ast, 19)) {
            this.names.add(nameAst.getText());
        }
        this.typeAst = AstUtil.getChild(ast, 63);
        AST domainAst = AstUtil.getChild(ast, 82);
        if (domainAst != null) {
            this.domain = new Domain(domainAst, this);
        }
        if ((guardAst = AstUtil.getChild(ast, 79)) != null) {
            this.guard = new Guard(guardAst);
        }
        this.negative = (noAST = AstUtil.getChild(ast, 88)) != null;
        AST cardinalityAst = AstUtil.getChild(ast, 81);
        if (cardinalityAst != null) {
            this.cardinality = new Cardinality(cardinalityAst);
        }
        if ((optionalAst = AstUtil.getChild(ast, 89)) != null) {
            this.optionalAst = optionalAst.getFirstChild();
        }
        if ((activeAst = AstUtil.getChild(ast, 90)) != null) {
            this.activeAst = activeAst.getFirstChild();
        }
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    public boolean isActive(IEolContext context) throws EolRuntimeException {
        return this.isActive(context, false);
    }

    public boolean isActive(IEolContext context, boolean forceRecompute) throws EolRuntimeException {
        if (forceRecompute) {
            this.isActiveCache = this.activeAst == null ? true : (Boolean)context.getExecutorFactory().executeBlockOrExpressionAst(this.activeAst, context, Boolean.class, true);
        }
        return this.isActiveCache;
    }

    public boolean isOptional(IEolContext context) throws EolRuntimeException {
        if (this.optionalAst == null) {
            return false;
        }
        return (Boolean)context.getExecutorFactory().executeBlockOrExpressionAst(this.optionalAst, context, Boolean.class, true);
    }

    public boolean isNegative() {
        return this.negative;
    }

    public List<String> getNames() {
        return this.names;
    }

    @Override
    public List<?> getChildren() {
        return Collections.emptyList();
    }

    public Domain getDomain() {
        return this.domain;
    }

    public Guard getGuard() {
        return this.guard;
    }

    public List<Object> getInstances(final IEolContext context) throws EolRuntimeException {
        DynamicList instances = null;
        instances = this.domain != null ? this.domain.getValues(context, this.typeAst.getText()) : new DynamicList<Object>(){

            @Override
            protected List<Object> getValues() throws Exception {
                Collection<?> allInstances;
                if (!Role.this.isActive(context, true)) {
                    return NoMatch.asList();
                }
                if (Role.this.type == null) {
                    Role.this.type = EolModelElementType.forName(Role.this.typeAst.getText(), context);
                }
                if ((allInstances = Role.this.type.getAllOfKind()) instanceof List) {
                    return (List)allInstances;
                }
                EolSequence<Object> sequence = new EolSequence<Object>();
                sequence.addAll(allInstances);
                return sequence;
            }
        };
        instances.setExceptionHandler(new RuntimeExceptionThrower(context));
        instances.setResetable(instances.isResetable() || this.activeAst != null);
        if (this.isNegative()) {
            return this.getNegative(instances, context);
        }
        if (this.getCardinality().isMany()) {
            return this.getAll(instances, context);
        }
        return instances;
    }

    protected List<Object> getAll(final DynamicList<Object> instances, final IEolContext context) {
        DynamicList<Object> allValues = new DynamicList<Object>(){

            @Override
            protected List<Object> getValues() throws Exception {
                ArrayList filtered = new ArrayList();
                if (Role.this.getGuard() != null) {
                    for (Object o : instances) {
                        context.getFrameStack().enterLocal(FrameType.UNPROTECTED, Role.this.getGuard().getAst(), Variable.createReadOnlyVariable(Role.this.getNames().get(0), o));
                        boolean ok = (Boolean)context.getExecutorFactory().executeBlockOrExpressionAst(Role.this.getGuard().getAst().getFirstChild(), context, Boolean.class, false);
                        if (ok) {
                            filtered.add(o);
                        }
                        context.getFrameStack().leaveLocal(Role.this.getGuard().getAst());
                    }
                } else {
                    filtered.addAll(instances);
                }
                ArrayList<Object> result = new ArrayList<Object>();
                if (Role.this.getCardinality().isInBounds(filtered.size())) {
                    result.add(filtered);
                }
                return result;
            }

            @Override
            public void reset() {
                super.reset();
                instances.reset();
            }
        };
        allValues.setExceptionHandler(instances.getExceptionHandler());
        allValues.setResetable(instances.isResetable());
        return allValues;
    }

    protected List<Object> getNegative(final DynamicList<Object> instances, final IEolContext context) {
        DynamicList<Object> negativeDomainValues = new DynamicList<Object>(){

            @Override
            protected List<Object> getValues() throws Exception {
                if (Role.this.getGuard() != null) {
                    for (Object o : instances) {
                        boolean result = true;
                        Return ret = null;
                        context.getFrameStack().enterLocal(FrameType.UNPROTECTED, Role.this.getGuard().getAst(), Variable.createReadOnlyVariable(Role.this.getNames().get(0), o));
                        ret = (Return)context.getExecutorFactory().executeBlockOrExpressionAst(Role.this.getGuard().getAst().getFirstChild(), context);
                        context.getFrameStack().leaveLocal(Role.this.getGuard().getAst());
                        if (ret.getValue() instanceof Boolean) {
                            result = (Boolean)ret.getValue();
                        }
                        if (!result) continue;
                        return new ArrayList<Object>();
                    }
                } else if (instances.size() > 0) {
                    return new ArrayList<Object>();
                }
                ArrayList<Object> noMatchList = new ArrayList<Object>();
                noMatchList.add(NoMatch.INSTANCE);
                return noMatchList;
            }

            @Override
            public void reset() {
                super.reset();
                instances.reset();
            }
        };
        negativeDomainValues.setExceptionHandler(instances.getExceptionHandler());
        negativeDomainValues.setResetable(instances.isResetable());
        return negativeDomainValues;
    }
}

