/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.erl;

import java.util.Comparator;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.common.util.StringUtil;
import org.eclipse.epsilon.eol.EolImport;
import org.eclipse.epsilon.eol.EolLabeledBlock;
import org.eclipse.epsilon.eol.EolLibraryModule;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.erl.IErlModule;
import org.eclipse.epsilon.erl.rules.INamedRule;
import org.eclipse.epsilon.erl.rules.LabeledNamedRule;
import org.eclipse.epsilon.erl.rules.NamedRules;

public abstract class ErlModule
extends EolLibraryModule
implements IErlModule {
    protected NamedRules declaredPre = new NamedRules();
    protected NamedRules declaredPost = new NamedRules();
    protected NamedRules pre = null;
    protected NamedRules post = null;

    @Override
    public void buildModel() throws Exception {
        super.buildModel();
        for (AST preBlockAst : AstUtil.getChildren(this.ast, this.getPreBlockTokenType())) {
            this.declaredPre.add(new LabeledNamedRule(preBlockAst, "pre"));
        }
        for (AST postBlockAst : AstUtil.getChildren(this.ast, this.getPostBlockTokenType())) {
            this.declaredPost.add(new LabeledNamedRule(postBlockAst, "post"));
        }
    }

    @Override
    public NamedRules getPost() {
        if (this.post == null) {
            this.post = new NamedRules();
            for (EolImport import_ : this.imports) {
                if (!import_.isLoaded() || !(import_.getModule() instanceof IErlModule)) continue;
                IErlModule module = (IErlModule)import_.getModule();
                this.post.addAll(module.getPost());
            }
            this.post.addAll(this.declaredPost);
        }
        return this.post;
    }

    @Override
    public NamedRules getPre() {
        if (this.pre == null) {
            this.pre = new NamedRules();
            for (EolImport import_ : this.imports) {
                if (!import_.isLoaded() || !(import_.getModule() instanceof IErlModule)) continue;
                IErlModule module = (IErlModule)import_.getModule();
                this.pre.addAll(module.getPre());
            }
            this.pre.addAll(this.declaredPre);
        }
        return this.pre;
    }

    @Override
    public NamedRules getDeclaredPost() {
        return this.declaredPost;
    }

    @Override
    public NamedRules getDeclaredPre() {
        return this.declaredPre;
    }

    protected void execute(NamedRules namedRules, IEolContext context) throws EolRuntimeException {
        for (INamedRule namedRule : namedRules) {
            context.getExecutorFactory().executeAST(namedRule.getAst(), context);
        }
    }

    protected abstract int getPreBlockTokenType();

    protected abstract int getPostBlockTokenType();

    @Override
    public void reset() {
        super.reset();
        this.pre = null;
        this.post = null;
        this.declaredPre.clear();
        this.declaredPost.clear();
    }

    class EolLabeledBlockComparator
    implements Comparator<EolLabeledBlock> {
        EolLabeledBlockComparator() {
        }

        @Override
        public int compare(EolLabeledBlock o1, EolLabeledBlock o2) {
            if (StringUtil.areEqual(o1.getName(), o2.getName())) {
                return 0;
            }
            return 1;
        }
    }
}

