/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.erl.rules;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.annotations.EolAnnotationsUtil;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.erl.exceptions.ErlCircularRuleInheritanceException;
import org.eclipse.epsilon.erl.exceptions.ErlRuleNotFoundException;
import org.eclipse.epsilon.erl.rules.NamedRule;
import org.eclipse.epsilon.erl.rules.NamedRules;

public abstract class ExtensibleNamedRule
extends NamedRule {
    protected ArrayList<AST> superRulesAsts = new ArrayList();
    protected NamedRules superRules = new NamedRules();
    protected NamedRules allSuperRules = new NamedRules();
    protected Boolean isGreedy = null;
    protected Boolean isAbstract = null;
    protected Boolean isLazy = null;

    public boolean isGreedy() throws EolRuntimeException {
        if (this.isGreedy == null) {
            this.isGreedy = EolAnnotationsUtil.getBooleanAnnotationValue(this.ast, "greedy", null);
        }
        return this.isGreedy;
    }

    public boolean isAbstract() throws EolRuntimeException {
        if (this.isAbstract == null) {
            this.isAbstract = EolAnnotationsUtil.getBooleanAnnotationValue(this.ast, "abstract", null);
        }
        return this.isAbstract;
    }

    public boolean isLazy() throws EolRuntimeException {
        if (this.isLazy == null) {
            this.isLazy = EolAnnotationsUtil.getBooleanAnnotationValue(this.ast, "lazy", null);
        }
        return this.isLazy;
    }

    public void calculateSuperRules(NamedRules allRules) throws ErlRuleNotFoundException, ErlCircularRuleInheritanceException {
        this.superRules = new NamedRules();
        this.calculateSuperRules(this, allRules, this.superRules, false);
        this.allSuperRules = new NamedRules();
        this.calculateSuperRules(this, allRules, this.allSuperRules, true);
    }

    protected void calculateSuperRules(ExtensibleNamedRule rule, NamedRules allRules, NamedRules collectedRules, boolean recursive) throws ErlRuleNotFoundException, ErlCircularRuleInheritanceException {
        ListIterator<AST> li = rule.superRulesAsts.listIterator();
        while (li.hasNext()) {
            AST superRuleAst = li.next();
            String superRuleName = superRuleAst.getText();
            ExtensibleNamedRule superRule = (ExtensibleNamedRule)allRules.getRule(superRuleName);
            if (superRule != null) {
                if (collectedRules.getRule(superRule.getName()) != null) {
                    throw new ErlCircularRuleInheritanceException(superRule);
                }
                collectedRules.add(superRule);
                if (!recursive) continue;
                this.calculateSuperRules(superRule, allRules, collectedRules, true);
                continue;
            }
            throw new ErlRuleNotFoundException(superRuleAst);
        }
    }

    public void parse(AST ast) {
        this.ast = ast;
        this.name = ast.getFirstChild().getText();
        AST superRulesAst = this.getSuperRulesAst();
        if (superRulesAst != null) {
            AST superRuleAst = superRulesAst.getFirstChild();
            while (superRuleAst != null) {
                this.superRulesAsts.add(superRuleAst);
                superRuleAst = superRuleAst.getNextSibling();
            }
        }
    }

    public abstract AST getSuperRulesAst();

    public NamedRules getAllSuperRules() {
        return this.allSuperRules;
    }

    public NamedRules getSuperRules() {
        return this.superRules;
    }
}

