/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.etl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.eol.EolFormalParameter;
import org.eclipse.epsilon.eol.annotations.EolAnnotationsUtil;
import org.eclipse.epsilon.eol.exceptions.EolIllegalReturnException;
import org.eclipse.epsilon.eol.exceptions.EolNoReturnException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.Return;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.types.EolModelElementType;
import org.eclipse.epsilon.eol.types.EolType;
import org.eclipse.epsilon.erl.rules.ExtensibleNamedRule;
import org.eclipse.epsilon.erl.rules.INamedRule;
import org.eclipse.epsilon.etl.execute.context.IEtlContext;
import org.eclipse.epsilon.etl.trace.TransformationTrace;
import org.eclipse.epsilon.etl.trace.Transformations;

public class TransformRule
extends ExtensibleNamedRule
implements ModuleElement {
    protected EolFormalParameter sourceParameter;
    protected List<EolFormalParameter> targetParameters = new ArrayList<EolFormalParameter>();
    protected AST guardAst = null;
    protected AST bodyAst = null;
    protected IEtlContext context;
    protected EolModelElementType sourceType = null;
    protected Collection<Object> rejected = new ArrayList<Object>();
    protected Set<Object> transformedElements = new HashSet<Object>();
    protected Boolean isPrimary = null;

    public TransformRule(AST ast) {
        this.parse(ast);
    }

    @Override
    public AST getSuperRulesAst() {
        return AstUtil.getChild(this.ast, 78);
    }

    public List<EolFormalParameter> getTargetParameters() {
        return this.targetParameters;
    }

    @Override
    public void parse(AST ast) {
        super.parse(ast);
        this.guardAst = AstUtil.getChild(ast, 79);
        this.bodyAst = AstUtil.getChild(ast, 61);
        AST sourceParameterAst = ast.getFirstChild().getNextSibling();
        this.sourceParameter = new EolFormalParameter(sourceParameterAst);
        AST targetParametersAst = sourceParameterAst.getNextSibling();
        AST targetParameterAst = targetParametersAst.getFirstChild();
        while (targetParameterAst != null) {
            EolFormalParameter targetParameter = new EolFormalParameter(targetParameterAst);
            this.targetParameters.add(targetParameter);
            targetParameterAst = targetParameterAst.getNextSibling();
        }
    }

    public boolean hasTransformed(Object source) {
        return this.transformedElements.contains(source);
    }

    public Collection<?> getAllOfSourceType(IEtlContext context) throws EolRuntimeException {
        try {
            EolModelElementType sourceType = (EolModelElementType)this.sourceParameter.getType(context);
            return sourceType.getAllOfType();
        }
        catch (EolRuntimeException ex) {
            ex.setAst(this.sourceParameter.getTypeAst());
            throw ex;
        }
    }

    public EolModelElementType getSourceType(IEolContext context) throws EolRuntimeException {
        if (this.sourceType == null) {
            this.sourceType = (EolModelElementType)this.sourceParameter.getType(context);
        }
        return this.sourceType;
    }

    public boolean appliesTo(Object source, IEtlContext context, boolean asSuperRule) throws EolRuntimeException {
        return this.appliesTo(source, context, asSuperRule, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean appliesTo(Object source, IEtlContext context, boolean asSuperRule, boolean checkTypes) throws EolRuntimeException {
        if (this.hasTransformed(source)) {
            return true;
        }
        if (this.rejected.contains(source)) {
            return false;
        }
        boolean appliesToTypes = !checkTypes ? true : (this.isGreedy() || asSuperRule ? this.getSourceType(context).isKind(source) : this.getSourceType(context).isType(source));
        boolean guardSatisfied = true;
        if (appliesToTypes && this.guardAst != null) {
            context.getFrameStack().enterLocal(FrameType.PROTECTED, this.guardAst, new Variable[0]);
            context.getFrameStack().put(Variable.createReadOnlyVariable(this.sourceParameter.getName(), source));
            context.getFrameStack().put(Variable.createReadOnlyVariable("self", this));
            Object result = context.getExecutorFactory().executeBlockOrExpressionAst(this.guardAst.getFirstChild(), context);
            context.getFrameStack().leaveLocal(this.guardAst);
            if (!(result instanceof Return)) throw new EolNoReturnException("Boolean", this.guardAst, context);
            Object value = Return.getValue(result);
            if (!(value instanceof Boolean)) throw new EolIllegalReturnException("Boolean", value, this.guardAst, context);
            guardSatisfied = (Boolean)value;
        }
        boolean applies = appliesToTypes && guardSatisfied;
        for (INamedRule superRule : this.getSuperRules()) {
            TransformRule rule = (TransformRule)superRule;
            if (rule.appliesTo(source, context, true)) continue;
            applies = false;
            break;
        }
        if (applies) return applies;
        this.rejected.add(source);
        return applies;
    }

    public boolean contains(Collection<Object> col, Object o) {
        Iterator<Object> it = col.iterator();
        while (it.hasNext()) {
            if (it.next() != o) continue;
            return true;
        }
        return false;
    }

    public void transformAll(IEtlContext context, List<Object> excluded) throws EolRuntimeException {
        Collection<?> all = null;
        all = this.isGreedy() ? this.getSourceType(context).getAllOfKind() : this.getSourceType(context).getAllOfType();
        for (Object instance : all) {
            if (excluded.contains(instance) || !this.appliesTo(instance, context, false)) continue;
            this.transform(instance, context);
        }
    }

    public Collection<?> transform(Object source, Collection<?> targets, IEtlContext context) throws EolRuntimeException {
        this.transformedElements.add(source);
        this.executeSuperRulesAndBody(source, targets, context);
        return targets;
    }

    public Collection<?> transform(Object source, IEtlContext context) throws EolRuntimeException {
        TransformationTrace transformationTrace = context.getTransformationTrace();
        if (this.hasTransformed(source)) {
            Transformations transformations = transformationTrace.getTransformations(source);
            return transformations.getTargets(this.name);
        }
        this.transformedElements.add(source);
        List<Object> targets = CollectionUtil.createDefaultList();
        for (EolFormalParameter targetParameter : this.targetParameters) {
            EolType targetParameterType = targetParameter.getType(context);
            targets.add(targetParameterType.createInstance());
        }
        transformationTrace.add(source, targets, this);
        this.executeSuperRulesAndBody(source, targets, context);
        return targets;
    }

    protected void executeSuperRulesAndBody(Object source, Collection<?> targets_, IEtlContext context) throws EolRuntimeException {
        List<?> targets = CollectionUtil.asList(targets_);
        for (TransformRule superRule : this.superRules) {
            superRule.transform(source, targets, context);
        }
        FrameStack scope = context.getFrameStack();
        Variable[] variables = new Variable[]{};
        scope.enterLocal(FrameType.PROTECTED, this.ast, variables);
        scope.put(Variable.createReadOnlyVariable(this.sourceParameter.getName(), source));
        scope.put(Variable.createReadOnlyVariable("self", this));
        int i = 0;
        while (i < this.targetParameters.size()) {
            EolFormalParameter targetParameter = this.targetParameters.get(i);
            scope.put(Variable.createReadOnlyVariable(targetParameter.getName(), targets.get(i)));
            ++i;
        }
        context.getExecutorFactory().executeAST(this.bodyAst, context);
        scope.leaveLocal(this.ast);
    }

    @Override
    public List<?> getChildren() {
        return Collections.emptyList();
    }

    public String toString() {
        String targetTypes = "";
        Iterator<EolFormalParameter> it = this.targetParameters.iterator();
        while (it.hasNext()) {
            EolFormalParameter fp = it.next();
            targetTypes = String.valueOf(targetTypes) + fp.getTypeName();
            if (!it.hasNext()) continue;
            targetTypes = String.valueOf(targetTypes) + ", ";
        }
        return String.valueOf(this.name) + " (" + this.sourceParameter.getTypeName() + ") : " + targetTypes;
    }

    public boolean isPrimary() throws EolRuntimeException {
        if (this.isPrimary == null) {
            this.isPrimary = EolAnnotationsUtil.getBooleanAnnotationValue(this.ast, "primary", null);
        }
        return this.isPrimary;
    }

    public boolean canTransformExcluded(IEtlContext context) throws EolRuntimeException {
        return EolAnnotationsUtil.getBooleanAnnotationValue(this.ast, "excluded", context, false, true);
    }

    public void dispose() {
        this.transformedElements.clear();
        this.rejected.clear();
        this.rejected = null;
        this.transformedElements = null;
    }
}

