/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eunit.operations;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.epsilon.common.dt.extensions.ClassBasedExtension;
import org.eclipse.epsilon.common.dt.extensions.IllegalExtensionException;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.FileUtil;
import org.eclipse.epsilon.eol.exceptions.EolAssertionException;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelNotFoundException;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eunit.extensions.IModelComparator;

public class ExtraEUnitOperationContributor
extends OperationContributor {
    private static final Set<String> ASSERTEQUALDIRS_IGNORED_FILENAMES = new HashSet<String>();

    static {
        ASSERTEQUALDIRS_IGNORED_FILENAMES.add(".svn");
        ASSERTEQUALDIRS_IGNORED_FILENAMES.add(".git");
    }

    @Override
    public boolean contributesTo(Object target) {
        return true;
    }

    public void assertEqualFiles(String pathExpected, String pathActual) throws EolAssertionException, EolInternalException {
        this.compareTrees(pathExpected, pathActual, true);
    }

    public void assertEqualDirectories(String pathExpected, String pathActual) throws EolAssertionException, EolInternalException {
        this.compareTrees(pathExpected, pathActual, true);
    }

    public void assertEqualModels(String expectedModelName, String obtainedModelName) throws EolModelNotFoundException, EolAssertionException, EolInternalException, IllegalExtensionException {
        this.compareModels(null, expectedModelName, obtainedModelName, true, new HashMap<String, Object>());
    }

    public void assertEqualModels(String expectedModelName, String obtainedModelName, Map<String, Object> options) throws EolModelNotFoundException, EolAssertionException, EolInternalException, IllegalExtensionException {
        this.compareModels(null, expectedModelName, obtainedModelName, true, options);
    }

    public void assertEqualModels(String message, String expectedModelName, String obtainedModelName) throws EolModelNotFoundException, EolAssertionException, EolInternalException, IllegalExtensionException {
        this.compareModels(message, expectedModelName, obtainedModelName, true, new HashMap<String, Object>());
    }

    public void assertEqualModels(String message, String expectedModelName, String obtainedModelName, Map<String, Object> options) throws EolModelNotFoundException, EolAssertionException, EolInternalException, IllegalExtensionException {
        this.compareModels(message, expectedModelName, obtainedModelName, true, options);
    }

    public void assertNotEqualFiles(String pathExpected, String pathActual) throws EolAssertionException, EolInternalException {
        this.compareTrees(pathExpected, pathActual, false);
    }

    public void assertNotEqualDirectories(String pathExpected, String pathActual) throws EolAssertionException, EolInternalException {
        this.compareTrees(pathExpected, pathActual, false);
    }

    public void assertNotEqualModels(String expectedModelName, String obtainedModelName) throws EolModelNotFoundException, EolAssertionException, EolInternalException, IllegalExtensionException {
        this.compareModels(null, expectedModelName, obtainedModelName, false, new HashMap<String, Object>());
    }

    public void assertNotEqualModels(String expectedModelName, String obtainedModelName, Map<String, Object> options) throws EolModelNotFoundException, EolAssertionException, EolInternalException, IllegalExtensionException {
        this.compareModels(null, expectedModelName, obtainedModelName, false, options);
    }

    public void assertNotEqualModels(String message, String expectedModelName, String obtainedModelName) throws EolModelNotFoundException, EolAssertionException, EolInternalException, IllegalExtensionException {
        this.compareModels(message, expectedModelName, obtainedModelName, false, new HashMap<String, Object>());
    }

    public void assertNotEqualModels(String message, String expectedModelName, String obtainedModelName, Map<String, Object> options) throws EolModelNotFoundException, EolAssertionException, EolInternalException, IllegalExtensionException {
        this.compareModels(message, expectedModelName, obtainedModelName, false, options);
    }

    public void assertMatchingLine(String pathExpected, String regexp) throws EolInternalException {
        this.assertMatchingLine(null, pathExpected, regexp);
    }

    public void assertMatchingLine(String message, String pathExpected, String regexp) throws EolInternalException {
        if (message == null) {
            message = String.format("No lines matched '%s' from start to finish", regexp);
        }
        this.assertLineMatchingPredicate(message, pathExpected, regexp, new Predicate2<Pattern, String>(){

            @Override
            public boolean evaluate(Pattern regexp, String line) {
                return regexp.matcher(line).matches();
            }
        });
    }

    public void assertLineWithMatch(String pathExpected, String regexp) throws EolInternalException {
        this.assertLineWithMatch(null, pathExpected, regexp);
    }

    public void assertLineWithMatch(String message, String pathExpected, String regexp) throws EolInternalException {
        if (message == null) {
            message = String.format("No lines contained a match for '%s'", regexp);
        }
        this.assertLineMatchingPredicate(message, pathExpected, regexp, new Predicate2<Pattern, String>(){

            @Override
            public boolean evaluate(Pattern regexp, String line) {
                return regexp.matcher(line).find();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void assertLineMatchingPredicate(String message, String pathExpected, String regexp, Predicate2<Pattern, String> predicate) throws EolInternalException {
        BufferedReader reader = null;
        try {
            String string;
            Pattern regex = Pattern.compile(regexp);
            reader = new BufferedReader(new FileReader(new File(pathExpected)));
            String line = reader.readLine();
            if (line != null) {
            }
            AST ast = this.context.getFrameStack().getCurrentStatement();
            if (message != null) {
                string = message;
                throw new EolAssertionException(string, ast, null, null, null);
            }
            string = String.format("No lines matched '%s' from start to finish", regexp);
            throw new EolAssertionException(string, ast, null, null, null);
        }
        catch (Exception ex) {
            throw new EolInternalException(ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new EolInternalException(e);
                }
            }
        }
    }

    private void compareTrees(String pathExpected, String pathActual, boolean mustBeEqual) throws EolAssertionException, EolInternalException {
        File fileExpected = new File(pathExpected);
        File fileActual = new File(pathActual);
        try {
            FileUtil.checkFileExists(fileExpected);
            FileUtil.checkFileExists(fileActual);
            if (FileUtil.sameContents(fileExpected, fileActual, ASSERTEQUALDIRS_IGNORED_FILENAMES) == mustBeEqual) {
                return;
            }
            if (mustBeEqual) {
                fileExpected = FileUtil.copyToTemp(fileExpected);
                fileActual = FileUtil.copyToTemp(fileActual);
            } else {
                fileActual = null;
                fileExpected = null;
            }
        }
        catch (Exception ex) {
            throw new EolInternalException(ex);
        }
        String message = String.format("Expected %s and %s to be %s, but they weren't", pathExpected, pathActual, mustBeEqual ? "equal" : "different");
        AST ast = this.context.getFrameStack().getCurrentStatement();
        throw new EolAssertionException(message, ast, fileExpected, fileActual, null);
    }

    private IModel getModel(String name) throws EolModelNotFoundException {
        return this.context.getModelRepository().getModelByName(name);
    }

    private void compareModels(String message, String expectedModelName, String actualModelName, boolean mustBeEqual, Map<String, Object> options) throws EolModelNotFoundException, EolAssertionException, EolInternalException, IllegalExtensionException {
        IModel actualCModel;
        IModel expectedCModel = this.getModel(expectedModelName);
        IModelComparator comparator = this.getComparator(expectedCModel, actualCModel = this.getModel(actualModelName));
        if (comparator == null) {
            throw new IllegalArgumentException("No matching comparator has been found for " + expectedCModel + " and " + actualCModel);
        }
        comparator.configure(options);
        Object delta = null;
        boolean bExpectedEmpty = expectedCModel.allContents().isEmpty();
        boolean bActualEmpty = actualCModel.allContents().isEmpty();
        try {
            if (!bExpectedEmpty && !bActualEmpty) {
                delta = comparator.compare(expectedCModel, actualCModel);
            } else if (bExpectedEmpty != bActualEmpty) {
                delta = "expected " + (bExpectedEmpty ? "is" : "is not") + " empty, actual " + (bActualEmpty ? "is" : "is not") + " empty";
            }
        }
        catch (Exception e) {
            throw new EolInternalException(e);
        }
        if (delta == null == mustBeEqual) {
            return;
        }
        if (message == null) {
            message = bExpectedEmpty ? "Expected " + actualModelName + (mustBeEqual ? " to be also" : " not to be") + " empty, but it is " + (bActualEmpty ? "empty" : "not") : "Expected " + actualModelName + " to be " + (mustBeEqual ? "equal" : "different") + " to " + expectedModelName + ", but it is " + (bActualEmpty ? "empty" : "not");
        }
        if (mustBeEqual) {
            throw new EolAssertionException(message.toString(), this.context.getFrameStack().getCurrentStatement(), expectedCModel, actualCModel, delta);
        }
        throw new EolAssertionException(message.toString(), this.context.getFrameStack().getCurrentStatement(), null, null, null);
    }

    private IModelComparator getComparator(IModel expectedCModel, IModel actualCModel) throws IllegalExtensionException {
        try {
            Class.forName("org.eclipse.epsilon.common.dt.extensions.ClassBasedExtension");
            List comparators = ClassBasedExtension.getImplementations((String)"org.eclipse.epsilon.eunit.engine.comparator", IModelComparator.class);
            for (IModelComparator comparator : comparators) {
                if (!comparator.canCompare(expectedCModel, actualCModel)) continue;
                return comparator;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private static interface Predicate2<T, U> {
        public boolean evaluate(T var1, U var2);
    }
}

