/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.evl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.epsilon.common.module.AbstractModuleElement;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.eol.exceptions.EolIllegalReturnException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelNotFoundException;
import org.eclipse.epsilon.eol.execute.Return;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.types.EolModelElementType;
import org.eclipse.epsilon.evl.EvlConstraint;
import org.eclipse.epsilon.evl.EvlConstraints;
import org.eclipse.epsilon.evl.execute.context.IEvlContext;

public class EvlConstraintContext
extends AbstractModuleElement {
    protected AST guardAst = null;
    protected EvlConstraints constraints = new EvlConstraints();
    protected AST typeAst;
    protected EolModelElementType type = null;
    protected boolean ofTypeOnly;
    protected String name;

    public List<ModuleElement> getChildren() {
        return new ArrayList<ModuleElement>(this.constraints.values());
    }

    public void build(AST ast) {
        this.ast = ast;
        this.typeAst = ast.getFirstChild();
        this.ofTypeOnly = false;
        this.name = this.typeAst.getText();
        this.guardAst = AstUtil.getChild(ast, 79);
        for (AST constraintAst : AstUtil.getChildren(ast, 80, 81)) {
            EvlConstraint constraint = new EvlConstraint();
            constraint.setConstraintContext(this);
            constraint.build(constraintAst);
            this.constraints.addConstraint(constraint);
            AST aST = constraintAst.getNextSibling();
        }
    }

    public boolean appliesTo(Object object, IEvlContext context) throws EolRuntimeException {
        if (this.ofTypeOnly && this.getAllOfSourceType(context).contains(object) || !this.ofTypeOnly && this.getAllOfSourceKind(context).contains(object)) {
            if (this.guardAst != null) {
                context.getFrameStack().enterLocal(FrameType.UNPROTECTED, this.guardAst, new Variable[0]);
                context.getFrameStack().put(Variable.createReadOnlyVariable("self", object));
                Object result = context.getExecutorFactory().executeBlockOrExpressionAst(this.guardAst.getFirstChild(), context);
                if (result instanceof Return) {
                    result = Return.getValue(result);
                }
                context.getFrameStack().leaveLocal(this.guardAst);
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
                throw new EolIllegalReturnException("Boolean", result, this.guardAst, context);
            }
            return true;
        }
        return false;
    }

    public void checkAll(IEvlContext context) throws EolRuntimeException {
        Collection<?> allOfKind = this.getAllOfSourceKind(context);
        for (Object object : allOfKind) {
            if (!this.appliesTo(object, context)) continue;
            for (EvlConstraint constraint : this.constraints.values()) {
                if (constraint.isLazy(context) || !constraint.appliesTo(object, context)) continue;
                constraint.check(object, context);
            }
        }
    }

    public EvlConstraints getConstraints() {
        return this.constraints;
    }

    public Collection<?> getAllOfSourceType(IEvlContext context) throws EolModelElementTypeNotFoundException, EolModelNotFoundException {
        if (this.type == null) {
            this.type = EolModelElementType.forName(this.typeAst.getText(), context);
        }
        return this.type.getAllOfType();
    }

    public Collection<?> getAllOfSourceKind(IEvlContext context) throws EolModelElementTypeNotFoundException, EolModelNotFoundException {
        if (this.type == null) {
            this.type = EolModelElementType.forName(this.typeAst.getText(), context);
        }
        return this.type.getAllOfKind();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }
}

