/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.equivalences;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.flock.context.ConservativeCopyContext;
import org.eclipse.epsilon.flock.context.EquivalenceEstablishmentContext;
import org.eclipse.epsilon.flock.emc.wrappers.ModelElement;
import org.eclipse.epsilon.flock.equivalences.Equivalence;
import org.eclipse.epsilon.flock.execution.TypeMappingContext;
import org.eclipse.epsilon.flock.execution.exceptions.FlockRuntimeException;
import org.eclipse.epsilon.flock.model.domain.MigrationStrategy;

public class Equivalences {
    private final List<Equivalence> equivalences = new LinkedList<Equivalence>();

    public static Equivalences establishFrom(MigrationStrategy strategy, EquivalenceEstablishmentContext context) throws FlockRuntimeException {
        Equivalences equivalences = new Equivalences();
        for (TypeMappingContext c : context.getTypeMappingContexts()) {
            equivalences.add(strategy.createEquivalence(c));
        }
        return equivalences;
    }

    protected void add(Equivalence equivalence) {
        this.equivalences.add(equivalence);
    }

    public ModelElement getEquivalent(ModelElement original) {
        for (Equivalence candidate : this.equivalences) {
            if (!candidate.getOriginal().equals(original)) continue;
            return candidate.getEquivalent();
        }
        return null;
    }

    public void conservativeCopy(MigrationStrategy strategy, ConservativeCopyContext context) throws FlockRuntimeException {
        for (Equivalence equivalence : this.equivalences) {
            context.automaticallyPopulateEquivalent(strategy, equivalence);
        }
    }

    public void applyRules(MigrationStrategy strategy) throws FlockRuntimeException {
        for (Equivalence equivalence : this.equivalences) {
            strategy.applyRulesTo(equivalence.getContext());
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Equivalence equivalence : this.equivalences) {
            builder.append(equivalence);
            builder.append('\n');
        }
        return builder.toString();
    }
}

