/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.model.domain.common;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;

public abstract class FlockConstruct
implements ModuleElement {
    private final AST ast;
    private final Collection<String> annotations;

    public FlockConstruct(AST ast, Collection<String> annotations) {
        this.ast = ast;
        this.annotations = annotations;
    }

    @Override
    public AST getAst() {
        return this.ast;
    }

    @Override
    public List<?> getChildren() {
        return Collections.emptyList();
    }

    protected boolean isAnnotatedWith(String annotation) {
        return this.annotations.contains(annotation);
    }

    protected String getAnnotationString() {
        StringBuilder annotationString = new StringBuilder();
        Iterator<String> annotationsIterator = this.annotations.iterator();
        while (annotationsIterator.hasNext()) {
            annotationString.append('@');
            annotationString.append(annotationsIterator.next());
            if (annotationsIterator.hasNext()) {
                annotationString.append(',');
            }
            annotationString.append(' ');
        }
        return annotationString.toString();
    }

    public int hashCode() {
        return this.annotations.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FlockConstruct)) {
            return false;
        }
        FlockConstruct other = (FlockConstruct)object;
        return this.annotations.equals(other.annotations);
    }
}

