/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.model.domain.typemappings;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.flock.context.MigrationStrategyCheckingContext;
import org.eclipse.epsilon.flock.equivalences.Equivalence;
import org.eclipse.epsilon.flock.equivalences.factory.DefaultEquivalenceFactory;
import org.eclipse.epsilon.flock.equivalences.factory.EquivalenceFactory;
import org.eclipse.epsilon.flock.execution.TypeMappingContext;
import org.eclipse.epsilon.flock.execution.exceptions.FlockRuntimeException;
import org.eclipse.epsilon.flock.model.domain.typemappings.TypeMappingConstruct;

public class TypeMappingConstructs {
    private final List<TypeMappingConstruct> typeMappingConstructs = new LinkedList<TypeMappingConstruct>();
    private final EquivalenceFactory defaultEquivalenceFactory;

    public TypeMappingConstructs(TypeMappingConstruct ... typeMappings) {
        this(DefaultEquivalenceFactory.getInstance());
        this.typeMappingConstructs.addAll(Arrays.asList(typeMappings));
    }

    public TypeMappingConstructs(EquivalenceFactory defaultEquivalenceFactory) {
        this.defaultEquivalenceFactory = defaultEquivalenceFactory;
    }

    public void add(TypeMappingConstruct typeMapping) {
        this.typeMappingConstructs.add(typeMapping);
    }

    public void check(MigrationStrategyCheckingContext context) {
        for (TypeMappingConstruct typeMapping : this.typeMappingConstructs) {
            typeMapping.check(context);
        }
    }

    public Equivalence createEquivalence(TypeMappingContext context) throws FlockRuntimeException {
        for (TypeMappingConstruct typeMapping : this.typeMappingConstructs) {
            if (!context.isEligibleFor(typeMapping)) continue;
            return context.createEquivalenceUsing(typeMapping);
        }
        return context.createEquivalenceUsing(this.defaultEquivalenceFactory);
    }
}

