/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.generate.model;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epsilon.egl.EglTemplate;
import org.eclipse.epsilon.egl.EglTemplateFactory;
import org.eclipse.epsilon.emc.emf.EmfMetaModel;
import org.eclipse.epsilon.emc.emf.EmfModel;
import org.eclipse.epsilon.emc.emf.EmfUtil;
import org.eclipse.epsilon.emc.emf.InMemoryEmfModel;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.etl.IEtlModule;
import org.eclipse.epsilon.hutn.exceptions.HutnGenerationException;
import org.eclipse.epsilon.hutn.generate.AbstractGenerator;
import org.eclipse.epsilon.hutn.model.hutn.ClassObject;
import org.eclipse.epsilon.hutn.model.hutn.HutnPackage;
import org.eclipse.epsilon.hutn.model.hutn.NsUri;
import org.eclipse.epsilon.hutn.model.hutn.Spec;
import org.eclipse.epsilon.hutn.util.EmcUtil;
import org.eclipse.epsilon.hutn.util.EpsilonUtil;

public class ModelGenerator
extends AbstractGenerator {
    private final IModel source;
    private final Collection<IModel> metaModels = new LinkedList<IModel>();
    private final List<String> metaModelUris = new LinkedList<String>();
    private boolean generateTransformationForWholeMetamodel = false;

    public ModelGenerator(Spec spec) throws HutnGenerationException {
        if (spec.getNsUris().isEmpty()) {
            throw new IllegalArgumentException("Spec does not contain any nsUris: " + spec);
        }
        try {
            this.source = new InMemoryEmfModel("Intermediate", spec.eResource(), HutnPackage.eINSTANCE);
            for (NsUri nsUri : spec.getNsUris()) {
                this.metaModelUris.add(nsUri.getValue());
                EmfMetaModel metaModel = new EmfMetaModel("MetaModel", nsUri.getValue());
                metaModel.load();
                this.metaModels.add(metaModel);
            }
        }
        catch (EolModelLoadingException e) {
            throw new HutnGenerationException(e);
        }
    }

    public ModelGenerator(Spec spec, File ... metaModelFiles) throws HutnGenerationException {
        try {
            this.source = new InMemoryEmfModel("Intermediate", spec.eResource(), HutnPackage.eINSTANCE);
            File[] fileArray = metaModelFiles;
            int n = metaModelFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File metaModelFile = fileArray[n2];
                this.metaModelUris.add(URI.createFileURI(metaModelFile.getAbsolutePath()).toString());
                EmfUtil.register(URI.createFileURI(metaModelFile.getAbsolutePath()), EPackage.Registry.INSTANCE);
                this.metaModels.add(EmcUtil.loadMetaModel("MetaModel", metaModelFile));
                ++n2;
            }
        }
        catch (Exception e) {
            throw new HutnGenerationException(e);
        }
    }

    protected String[] getNsUrisForTargetModel() throws EolModelElementTypeNotFoundException {
        LinkedList<String> nsUris = new LinkedList<String>();
        for (IModel metaModel : this.metaModels) {
            for (Object o : metaModel.getAllOfType("EPackage")) {
                if (!(o instanceof EPackage)) continue;
                nsUris.add(((EPackage)o).getNsURI());
            }
        }
        return nsUris.toArray(new String[0]);
    }

    @Override
    protected EmfModel generate(Resource resource) throws HutnGenerationException {
        try {
            InMemoryEmfModel target = new InMemoryEmfModel("Model", resource, this.getNsUrisForTargetModel());
            IEtlModule transformer = EpsilonUtil.initialiseEtlModule(this.source, target, new IModel[0]);
            target.setMetamodelUris(this.metaModelUris);
            target.setModelFile("foo.model");
            target.load();
            transformer.parse(this.generateTransformation());
            if (!transformer.getParseProblems().isEmpty()) {
                throw new HutnGenerationException("Could not parse transformation: " + transformer.getParseProblems());
            }
            transformer.execute();
            return target;
        }
        catch (Exception e) {
            if (e instanceof HutnGenerationException) {
                throw (HutnGenerationException)e;
            }
            throw new HutnGenerationException(e);
        }
    }

    public void forceGenerationOfTransformationForWholeMetamodel() {
        this.generateTransformationForWholeMetamodel = true;
    }

    public String generateTransformation() throws HutnGenerationException {
        try {
            EglTemplateFactory generator = new EglTemplateFactory();
            generator.getContext().getModelRepository().addModel(this.source);
            EglTemplate template = generator.load(ModelGenerator.class.getResource("GenerateIntermediate2ModelTransformation.egl").toURI());
            Collection<EClass> classes = this.generateTransformationForWholeMetamodel ? this.getAllClassesFromMetamodel() : this.getOnlyClassesThatAreUsedInSource();
            generator.getContext().getFrameStack().putGlobal(Variable.createReadOnlyVariable("classes", classes));
            String transformation = template.process();
            return transformation;
        }
        catch (Exception e) {
            throw new HutnGenerationException(e);
        }
    }

    private Collection<EClass> getOnlyClassesThatAreUsedInSource() throws EolRuntimeException {
        HashSet<EClass> classes = new HashSet<EClass>();
        for (Object o : this.source.getAllOfKind("ClassObject")) {
            classes.add(((ClassObject)o).getEClass());
        }
        return classes;
    }

    private Collection<EClass> getAllClassesFromMetamodel() throws EolRuntimeException {
        HashSet<EClass> classes = new HashSet<EClass>();
        for (IModel metaModel : this.metaModels) {
            for (Object clazz : metaModel.getAllOfKind("EClass")) {
                classes.add((EClass)clazz);
            }
        }
        return classes;
    }
}

