/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.unparser.internal;

import org.eclipse.epsilon.hutn.model.hutn.Object;

abstract class Unparser {
    protected final StringBuilder builder;

    public Unparser() {
        this.builder = new StringBuilder();
    }

    public Unparser(StringBuilder builder) {
        this.builder = builder;
    }

    public String unparse() {
        this.doUnparse();
        return this.builder.toString();
    }

    protected abstract void doUnparse();

    protected void appendSpace() {
        this.builder.append(' ');
    }

    protected void appendNewLine() {
        this.builder.append('\n');
    }

    protected void appendStringValue(String value) {
        this.builder.append('\"');
        this.builder.append(value);
        this.builder.append('\"');
    }

    protected void appendSignature(Object co) {
        this.appendSignature(co.getType(), co.getIdentifier());
    }

    protected void appendSignature(String type, String identifier) {
        this.unparseType(type);
        this.unparseIdentifier(identifier);
    }

    private void unparseType(String type) {
        this.builder.append(type);
        this.appendSpace();
    }

    private void unparseIdentifier(String identifier) {
        if (identifier != null) {
            this.appendStringValue(identifier);
        }
    }
}

