/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.xmi;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.hutn.exceptions.HutnValidationException;
import org.eclipse.epsilon.hutn.model.hutn.Spec;
import org.eclipse.epsilon.hutn.unparser.HutnUnparser;
import org.eclipse.epsilon.hutn.validation.model.HutnValidator;
import org.eclipse.epsilon.hutn.xmi.HutnXmiBridgeException;
import org.eclipse.epsilon.hutn.xmi.UriContentReader;
import org.eclipse.epsilon.hutn.xmi.parser.SpecGeneratingXmiParser;
import org.eclipse.epsilon.hutn.xmi.postprocessor.CoercionPostProcessor;
import org.eclipse.epsilon.hutn.xmi.postprocessor.IdentifierPostProcessor;
import org.eclipse.epsilon.hutn.xmi.postprocessor.UriFragmentPostProcessor;
import org.xml.sax.SAXException;

public class Xmi2Hutn {
    private final Spec spec;
    private final HutnUnparser unparser;

    public Xmi2Hutn(String xmi) throws HutnXmiBridgeException {
        try {
            this.spec = new SpecGeneratingXmiParser(xmi).parse();
            new UriFragmentPostProcessor(this.spec).process();
            new CoercionPostProcessor(this.spec).process();
            new IdentifierPostProcessor(this.spec).process();
            this.unparser = new HutnUnparser(this.spec);
        }
        catch (SAXException e) {
            throw new HutnXmiBridgeException(e);
        }
        catch (IOException e) {
            throw new HutnXmiBridgeException(e);
        }
    }

    public Xmi2Hutn(URI uri) throws HutnXmiBridgeException {
        this(new UriContentReader(uri).readContents());
    }

    public Spec getSpec() {
        return this.spec;
    }

    public String getHutn() {
        return this.unparser.unparse();
    }

    public Collection<ParseProblem> checkConformanceWithRegisteredMetamodel() throws HutnXmiBridgeException {
        if (this.spec == null) {
            return Collections.emptyList();
        }
        try {
            return this.improveReasonsOf(new HutnValidator().getProblemsForIntermediateModel(this.spec));
        }
        catch (HutnValidationException e) {
            throw new HutnXmiBridgeException(e);
        }
    }

    private List<ParseProblem> improveReasonsOf(List<ParseProblem> problems) {
        for (ParseProblem problem : problems) {
            this.improveReason(problem);
        }
        return problems;
    }

    private void improveReason(ParseProblem problem) {
        if ("Unrecognised classifier: UnknownType".equals(problem.getReason())) {
            problem.setReason("Unable to determine the type of this model element.");
        }
    }
}

