/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.xmi.parser;

import java.io.IOException;
import java.io.StringReader;
import org.eclipse.epsilon.hutn.model.hutn.HutnFactory;
import org.eclipse.epsilon.hutn.model.hutn.Spec;
import org.eclipse.epsilon.hutn.xmi.parser.sax.SpecGeneratingContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SpecGeneratingXmiParser {
    private final String xmi;
    private XMLReader reader;
    private SpecGeneratingContentHandler handler;
    private static final boolean DEBUG = false;

    public SpecGeneratingXmiParser(String xmi) {
        this.xmi = xmi;
    }

    public Spec parse() throws SAXException, IOException {
        this.initialiseXmlReader();
        return this.doParse();
    }

    private void initialiseXmlReader() throws SAXException {
        this.reader = XMLReaderFactory.createXMLReader();
        this.handler = new SpecGeneratingContentHandler();
        this.reader.setContentHandler(this.handler);
    }

    private Spec doParse() throws IOException {
        try {
            this.reader.parse(new InputSource(new StringReader(this.xmi)));
            return this.handler.getSpec();
        }
        catch (SAXException e) {
            return HutnFactory.eINSTANCE.createSpec();
        }
    }
}

