/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.xmi.parser.generator;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epsilon.hutn.model.hutn.ClassObject;
import org.eclipse.epsilon.hutn.model.hutn.ContainmentSlot;
import org.eclipse.epsilon.hutn.model.hutn.HutnFactory;
import org.eclipse.epsilon.hutn.model.hutn.NsUri;
import org.eclipse.epsilon.hutn.model.hutn.PackageObject;
import org.eclipse.epsilon.hutn.model.hutn.Slot;
import org.eclipse.epsilon.hutn.model.hutn.Spec;
import org.eclipse.epsilon.hutn.xmi.util.EmfUtil;
import org.eclipse.epsilon.hutn.xmi.util.HutnUtil;
import org.eclipse.epsilon.hutn.xmi.util.Stack;

public class SpecGenerator {
    private final Spec spec = HutnFactory.eINSTANCE.createSpec();
    private final Stack<ClassObject> stack = new Stack();
    private ContainmentSlot containingSlot;

    public SpecGenerator() {
        EmfUtil.createResource(this.spec);
    }

    public Spec getSpec() {
        return this.spec;
    }

    public void initialise() {
        this.initialise(null);
    }

    public void initialise(String nsUri) {
        this.addPackageObject(nsUri);
    }

    public void generateTopLevelClassObject(String identifier, String type, int lineNumber) {
        if (this.getPackageObject() == null) {
            throw new IllegalStateException("Cannot create a top-level class object until initialise has been called");
        }
        if (this.isGenerating()) {
            throw new IllegalStateException("Cannot create a top-level class object when generating another class object");
        }
        this.getPackageObject().getClassObjects().add(this.createClassObject(identifier, type, lineNumber));
    }

    public void generateContainedClassObject(String containingFeature, String identifier, int lineNumber) {
        EStructuralFeature feature = HutnUtil.determineFeatureFromMetaClass(this.getCurrentClassObject(), containingFeature);
        if (EmfUtil.isContainmentReference(feature)) {
            this.generateContainedClassObject(containingFeature, identifier, feature.getEType().getName(), lineNumber);
        } else {
            this.generateContainedClassObject(containingFeature, identifier, "UnknownType", lineNumber);
        }
    }

    public void generateContainedClassObject(String containingFeature, String identifier, String type, int lineNumber) {
        if (!this.isGenerating()) {
            throw new IllegalStateException("Cannot generate a contained class object when not generating any other class objects");
        }
        this.containingSlot = this.stack.peek().findOrCreateContainmentSlot(containingFeature);
        this.addButDoNotOverwriteLineNumberOf(this.containingSlot, lineNumber);
        this.containingSlot.getClassObjects().add(this.createClassObject(identifier, type, lineNumber));
    }

    public ClassObject getCurrentClassObject() {
        return this.stack.peek();
    }

    public boolean hasCurrentClassObject() {
        return !this.stack.isEmpty();
    }

    public void stopGeneratingCurrentClassObject() {
        this.stack.pop();
    }

    public void stopGeneratingAndDeleteCurrentClassObject() {
        this.stopGeneratingCurrentClassObject();
        if (this.containingSlot != null) {
            this.stack.peek().getSlots().remove(this.containingSlot);
        }
    }

    public void addAttributeValue(String featureName, String value, int lineNumber) {
        Slot<?> slot = this.determineSlot(featureName);
        this.addButDoNotOverwriteLineNumberOf(slot, lineNumber);
        this.getCurrentClassObject().getSlots().add(slot);
        HutnUtil.addValueToSlot(slot, value);
    }

    private Slot<?> determineSlot(String featureName) {
        Slot<Object> slot = HutnUtil.determineSlotFromMetaFeature(this.getCurrentClassObject(), featureName);
        if (slot instanceof ContainmentSlot) {
            this.getCurrentClassObject().getSlots().remove(this.getCurrentClassObject().findSlot(featureName));
            slot = this.getCurrentClassObject().findOrCreateReferenceSlot(featureName);
        } else if (slot == null) {
            slot = this.getCurrentClassObject().findOrCreateAttributeSlot(featureName);
        }
        return slot;
    }

    private void addButDoNotOverwriteLineNumberOf(Slot<?> slot, int lineNumber) {
        if (slot.getLine() == 0) {
            slot.setLine(lineNumber);
        }
    }

    private boolean isGenerating() {
        return this.getCurrentClassObject() != null;
    }

    private PackageObject getPackageObject() {
        if (this.spec.getObjects().isEmpty()) {
            return null;
        }
        return (PackageObject)this.spec.getObjects().get(0);
    }

    private void addPackageObject(String nsUri) {
        PackageObject po = HutnFactory.eINSTANCE.createPackageObject();
        po.setType("package");
        this.spec.getObjects().add(po);
        if (nsUri != null) {
            this.addNsUri(nsUri);
            if (EPackage.Registry.INSTANCE.getEPackage(nsUri) != null) {
                po.getMetamodel().add(EPackage.Registry.INSTANCE.getEPackage(nsUri));
            }
        }
    }

    private void addNsUri(String nsUri) {
        NsUri nsUriObject = HutnFactory.eINSTANCE.createNsUri();
        nsUriObject.setValue(nsUri);
        this.spec.getNsUris().add(nsUriObject);
    }

    private ClassObject createClassObject(String identifier, String type, int line) {
        ClassObject co = HutnFactory.eINSTANCE.createClassObject();
        co.setType(type);
        if (identifier != null) {
            co.setIdentifier(identifier);
        }
        co.setLine(line);
        this.stack.push(co);
        return co;
    }
}

