/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.xmi.postprocessor;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.epsilon.hutn.model.hutn.ClassObject;
import org.eclipse.epsilon.hutn.model.hutn.ReferenceSlot;
import org.eclipse.epsilon.hutn.model.hutn.Spec;
import org.eclipse.epsilon.hutn.xmi.postprocessor.ClassObjectNamer;
import org.eclipse.epsilon.hutn.xmi.util.EmfUtil;

public class IdentifierPostProcessor {
    private final Spec spec;
    private final ClassObjectNamer classObjectNamer = new ClassObjectNamer();
    private final Map<String, String> renamings = new HashMap<String, String>();

    public IdentifierPostProcessor(Spec spec) {
        this.spec = spec;
    }

    public void process() {
        this.renameClassObjects();
        this.updateReferenceSlots();
    }

    private void renameClassObjects() {
        for (ClassObject co : this.allClassObjects()) {
            this.renameClassObject(co, this.classObjectNamer.name(co));
        }
    }

    private List<ClassObject> allClassObjects() {
        return EmfUtil.getAllModelElementsOfType(this.spec, ClassObject.class);
    }

    private void renameClassObject(ClassObject co, String newIdentifier) {
        this.renamings.put(co.getIdentifier(), newIdentifier);
        co.setIdentifier(newIdentifier);
    }

    private void updateReferenceSlots() {
        for (ReferenceSlot slot : this.allReferenceSlots()) {
            LinkedList<String> newValues = new LinkedList<String>();
            for (String identifier : slot.getValues()) {
                String newValue = this.renamings.containsKey(identifier) ? this.renamings.get(identifier) : identifier;
                newValues.add(newValue);
            }
            slot.getValues().clear();
            slot.getValues().addAll(newValues);
        }
    }

    private List<ReferenceSlot> allReferenceSlots() {
        return EmfUtil.getAllModelElementsOfType(this.spec, ReferenceSlot.class);
    }
}

